/*
 * Decompiled with CFR 0.152.
 */
package app.spring.data.jpa.com.aol.micro.server;

import app.spring.data.jpa.com.aol.micro.server.SpringDataEntity;
import com.aol.micro.server.MicroserverApp;
import com.aol.micro.server.config.Config;
import com.aol.micro.server.config.Microserver;
import com.aol.micro.server.module.Module;
import com.aol.micro.server.rest.client.nio.AsyncRestClient;
import com.aol.micro.server.testing.RestAgent;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Microserver(properties={"db.connection.driver", "org.hsqldb.jdbcDriver", "db.connection.url", "jdbc:hsqldb:mem:aname", "db.connection.username", "sa", "db.connection.dialect", "org.hibernate.dialect.HSQLDialect", "db.connection.ddl.auto", "create-drop"}, entityScan={"app.spring.data.jpa.com.aol.micro.server"})
@EnableJpaRepositories
public class SpringDataTest {
    private final AsyncRestClient<List<SpringDataEntity>> listClient = new AsyncRestClient(1000, 1000).withGenericResponse(List.class, new Class[]{SpringDataEntity.class});
    RestAgent rest = new RestAgent();
    MicroserverApp server;

    @Before
    public void startServer() {
        Config.reset();
        this.server = new MicroserverApp(new Module[]{() -> "hibernate-app"});
        this.server.start();
    }

    @After
    public void stopServer() {
        this.server.stop();
    }

    @Test
    public void runAppAndBasicTest() throws InterruptedException, ExecutionException {
        Assert.assertThat((Object)this.rest.get("http://localhost:8080/hibernate-app/persistence/create"), (Matcher)CoreMatchers.is((Object)"ok"));
    }
}

