/*
 * Decompiled with CFR 0.152.
 */
package app.spring.data.jpa.com.aol.micro.server;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="t_spring_data", uniqueConstraints={@UniqueConstraint(columnNames={"name", "value"})})
public class SpringDataEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String value;
    private int version;

    @Version
    @Column(name="version", nullable=false)
    public int getVersion() {
        return this.version;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    public Long getId() {
        return this.id;
    }

    @Column(name="name", nullable=false)
    public String getName() {
        return this.name;
    }

    @Column(name="value", nullable=false)
    public String getValue() {
        return this.value;
    }

    public static SpringDataEntityBuilder builder() {
        return new SpringDataEntityBuilder();
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public SpringDataEntity() {
    }

    @ConstructorProperties(value={"id", "name", "value", "version"})
    public SpringDataEntity(Long id, String name, String value, int version) {
        this.id = id;
        this.name = name;
        this.value = value;
        this.version = version;
    }

    public static class SpringDataEntityBuilder {
        private Long id;
        private String name;
        private String value;
        private int version;

        SpringDataEntityBuilder() {
        }

        public SpringDataEntityBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public SpringDataEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SpringDataEntityBuilder value(String value) {
            this.value = value;
            return this;
        }

        public SpringDataEntityBuilder version(int version) {
            this.version = version;
            return this;
        }

        public SpringDataEntity build() {
            return new SpringDataEntity(this.id, this.name, this.value, this.version);
        }

        public String toString() {
            return "SpringDataEntity.SpringDataEntityBuilder(id=" + this.id + ", name=" + this.name + ", value=" + this.value + ", version=" + this.version + ")";
        }
    }
}

