/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.spring;

import com.aol.micro.server.config.Config;
import com.aol.micro.server.spring.SpringDBConfig;
import com.aol.micro.server.spring.datasource.DataDataSourceBuilder;
import com.aol.micro.server.spring.datasource.JdbcConfig;
import com.aol.micro.server.spring.datasource.hibernate.HibernateSessionBuilder;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class HibernateSpringConfigurer
implements SpringDBConfig {
    private ConfigurableListableBeanFactory beanFactory;
    private JdbcConfig jdbc;
    private DataSource dataSource;
    private Config config;
    private AnnotationConfigWebApplicationContext rootContext;

    public void createSpringApp(String name) {
        JdbcConfig jdbc = this.buildJdbcProperties(this.rootContext, name);
        DataSource dataSource = null;
        dataSource = this.rootContext.containsBean(name + "dataSource") ? (DataSource)this.rootContext.getBean(name + "dataSource") : this.buildDataSource(name, jdbc);
        SessionFactory sessionFactory = this.buildSession(name, this.config, dataSource, jdbc);
        this.beanFactory.registerSingleton(name + "SessionFactory", (Object)sessionFactory);
        this.beanFactory.registerSingleton(name + "HibernateTransactionManager", (Object)this.buildTransactionManager(name, this.config, dataSource, jdbc));
    }

    private DataSource buildDataSource(String name, JdbcConfig jdbc) {
        return DataDataSourceBuilder.builder().env(jdbc).build().mainDataSource();
    }

    private JdbcConfig buildJdbcProperties(AnnotationConfigWebApplicationContext rootContext, String name) {
        return JdbcConfig.builder().properties((Properties)rootContext.getBean("propertyFactory")).name(name).build();
    }

    private HibernateTransactionManager buildTransactionManager(String name, Config config, DataSource dataSource, JdbcConfig jdbc) {
        return HibernateSessionBuilder.builder().packages((List)config.getDataSources().get((Object)name)).dataSource(dataSource).env(jdbc).build().transactionManager();
    }

    private SessionFactory buildSession(String name, Config config, DataSource dataSource, JdbcConfig jdbc) {
        return HibernateSessionBuilder.builder().packages((List)config.getDataSources().get((Object)name)).dataSource(dataSource).env(jdbc).build().sessionFactory();
    }

    public void setBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setJdbc(JdbcConfig jdbc) {
        this.jdbc = jdbc;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setRootContext(AnnotationConfigWebApplicationContext rootContext) {
        this.rootContext = rootContext;
    }
}

