/*
 * Decompiled with CFR 0.152.
 */
package nonautoscan.com.aol.micro.server;

import com.aol.micro.server.SchedulingConfiguration;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@Configuration
@EnableScheduling
@EnableAsync
public class ScheduleAndAsyncConfig
implements SchedulingConfiguration {
    private int executorThreadPoolSize;
    private int schedulerThreadPoolSize;

    @Value(value="${default.task.executor.size:3}")
    public void setExecutorThreadPoolSize(int executorThreadPoolSize) {
        this.executorThreadPoolSize = executorThreadPoolSize;
    }

    @Value(value="${default.scheduler.executor.size:3}")
    public void setSchedulerThreadPoolSize(int schedulerThreadPoolSize) {
        this.schedulerThreadPoolSize = schedulerThreadPoolSize;
    }

    public Executor getAsyncExecutor() {
        return this.taskExecutor();
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler((Object)this.taskScheduler());
    }

    @Bean(destroyMethod="shutdown")
    public Executor taskScheduler() {
        return Executors.newScheduledThreadPool(this.schedulerThreadPoolSize);
    }

    @Bean
    public Executor taskExecutor() {
        return Executors.newFixedThreadPool(this.executorThreadPoolSize);
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return null;
    }
}

