/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.module;

import com.aol.cyclops.data.collections.extensions.persistent.PStackX;
import com.aol.micro.server.auto.discovery.JaxRsResource;
import com.aol.micro.server.auto.discovery.JaxRsResourceWrapper;
import com.aol.micro.server.module.Module;
import com.aol.micro.server.servers.model.FilterData;
import com.aol.micro.server.servers.model.ServerData;
import com.aol.micro.server.servers.model.ServletData;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.springframework.context.ApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

public class ModuleDataExtractor {
    private final Module module;

    public PStackX getRestResources(ApplicationContext rootContext) {
        ArrayList<Object> resources = new ArrayList<Object>();
        this.module.getRestResourceClasses().forEach(it -> resources.addAll(rootContext.getBeansOfType(it).values()));
        this.module.getRestAnnotationClasses().forEach(it -> resources.addAll(rootContext.getBeansWithAnnotation(it).values()));
        rootContext.getBeansWithAnnotation(JaxRsResource.class).forEach((n, it) -> resources.add(it));
        rootContext.getBeansOfType(JaxRsResourceWrapper.class).forEach((n, it) -> resources.add(it.getResource()));
        resources.addAll(this.module.getJaxRsResourceObjects());
        return PStackX.fromCollection(resources);
    }

    public List<FilterData> createFilteredDataList(ServerData data) {
        Map<String, Filter> filterMap = this.module.getFilters(data);
        return filterMap.entrySet().stream().map(e -> new FilterData((String)e.getKey(), ((Filter)e.getValue()).getClass().getName(), (Filter)new DelegatingFilterProxy((Filter)e.getValue()))).collect(Collectors.toList());
    }

    public List<ServletData> createServletDataList(ServerData data) {
        Map<String, Servlet> servletMap = this.module.getServlets(data);
        return servletMap.entrySet().stream().map(e -> new ServletData(((Servlet)e.getValue()).getClass().getName(), ((Servlet)e.getValue()).getClass(), (String)e.getKey())).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"module"})
    public ModuleDataExtractor(Module module) {
        this.module = module;
    }
}

