/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.spring;

import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.StreamUtils;
import com.aol.micro.server.Plugin;
import com.aol.micro.server.PluginLoader;
import com.aol.micro.server.config.Config;
import com.aol.micro.server.config.ConfigAccessor;
import com.aol.micro.server.spring.SpringBuilder;
import com.aol.micro.server.spring.SpringDBConfig;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class SpringApplicationConfigurator
implements SpringBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public ConfigurableApplicationContext createSpringApp(Config config, Class ... classes) {
        this.logger.debug("Configuring Spring");
        AnnotationConfigWebApplicationContext rootContext = new AnnotationConfigWebApplicationContext();
        rootContext.setAllowCircularReferences(config.isAllowCircularReferences());
        rootContext.register(classes);
        rootContext.scan(config.getBasePackages());
        rootContext.refresh();
        this.logger.debug("Configuring Additional Spring Beans");
        ConfigurableListableBeanFactory beanFactory = rootContext.getBeanFactory();
        config.getDataSources().keySet().stream().filter(it -> !new ConfigAccessor().get().getDefaultDataSourceName().equals(it)).forEach(name -> {
            List<SpringDBConfig> dbConfig = this.getConfig(config, rootContext, beanFactory);
            dbConfig.forEach(spring -> spring.createSpringApp((String)name));
        });
        this.logger.debug("Finished Configuring Spring");
        return rootContext;
    }

    private List<SpringDBConfig> getConfig(Config config, AnnotationConfigWebApplicationContext rootContext, ConfigurableListableBeanFactory beanFactory) {
        List result = ReactiveSeq.fromStream((Stream)PluginLoader.INSTANCE.plugins.get().stream()).filter(module -> module.springDbConfigurer() != null).map(Plugin::springDbConfigurer).flatMap(StreamUtils::optionalToStream).toList();
        result.forEach(next -> {
            next.setBeanFactory(beanFactory);
            next.setRootContext(rootContext);
            next.setConfig(config);
        });
        return result;
    }
}

