/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.servers;

import com.aol.micro.server.auto.discovery.ServletConfiguration;
import com.aol.micro.server.servers.model.ServerData;
import com.aol.micro.server.servers.model.ServletData;
import java.beans.ConstructorProperties;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.pcollections.PStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletConfigurer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServerData serverData;
    private final PStack<ServletData> servletData;

    public void addServlets(ServletContext webappContext) {
        this.addExplicitlyDeclaredServlets(webappContext);
        this.addAutoDiscoveredServlets(webappContext);
    }

    private void handleServlet(ServletConfiguration servlet, ServletContext webappContext) {
        servlet.getServlet().visit(clazz -> {
            this.setInitParameters(webappContext.addServlet(this.getName(servlet), clazz), servlet).addMapping(servlet.getMapping());
            return 1;
        }, obj -> {
            ServletRegistration.Dynamic servletReg = webappContext.addServlet(servlet.getName(), obj);
            servletReg.addMapping(servlet.getMapping());
            return 2;
        });
    }

    private void addAutoDiscoveredServlets(ServletContext webappContext) {
        this.serverData.getRootContext().getBeansOfType(ServletConfiguration.class).values().forEach(servlet -> this.handleServlet((ServletConfiguration)servlet, webappContext));
    }

    private void addExplicitlyDeclaredServlets(ServletContext webappContext) {
        for (ServletData servletData : this.servletData) {
            ServletRegistration.Dynamic servletReg = webappContext.addServlet(servletData.getServletName(), servletData.getServlet());
            servletReg.addMapping(new String[]{servletData.getMapping()});
            this.logServlet(servletData);
        }
    }

    private void logServlet(ServletData servlet) {
        this.logger.info("Registering {} servlet on {}", (Object)servlet.getServlet().getClass().getName(), (Object)servlet.getMapping());
    }

    private void logServlet(ServletConfiguration servlet) {
        this.logger.info("Registering {} servlet on {}", (Object)servlet.getClass().getName(), (Object)servlet.getMapping()[0]);
    }

    private ServletRegistration.Dynamic setInitParameters(ServletRegistration.Dynamic addServlet, ServletConfiguration servlet) {
        addServlet.setInitParameters(servlet.getInitParameters());
        return addServlet;
    }

    private String getName(ServletConfiguration servlet) {
        if (servlet.getName() != null) {
            return servlet.getName();
        }
        return servlet.getClass().getName();
    }

    @ConstructorProperties(value={"serverData", "servletData"})
    public ServletConfigurer(ServerData serverData, PStack<ServletData> servletData) {
        this.serverData = serverData;
        this.servletData = servletData;
    }
}

