/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server;

import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.StreamUtils;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.util.ExceptionSoftener;
import com.aol.micro.server.GlobalState;
import com.aol.micro.server.IncorrectNumberOfServersConfiguredException;
import com.aol.micro.server.Plugin;
import com.aol.micro.server.PluginLoader;
import com.aol.micro.server.config.Config;
import com.aol.micro.server.config.MicroserverConfigurer;
import com.aol.micro.server.module.Module;
import com.aol.micro.server.servers.ApplicationRegister;
import com.aol.micro.server.servers.ServerApplication;
import com.aol.micro.server.servers.ServerApplicationFactory;
import com.aol.micro.server.servers.ServerRunner;
import com.aol.micro.server.spring.SpringContextFactory;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class MicroserverApp {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ListX<Module> modules;
    private final CompletableFuture end = new CompletableFuture();
    private final ApplicationContext springContext;

    public MicroserverApp(Module ... modules) {
        this.modules = ListX.of((Object[])modules);
        GlobalState.state.setModules(this.modules);
        this.initSpringProperties(modules[0]);
        Class c = this.extractClass();
        this.springContext = new SpringContextFactory(new MicroserverConfigurer().buildConfig(c), this.extractClass(), modules[0].getSpringConfigurationClasses()).createSpringContext();
    }

    public MicroserverApp(Class c, Module ... modules) {
        this.modules = ListX.of((Object[])modules);
        GlobalState.state.setModules(this.modules);
        this.initSpringProperties(modules[0]);
        this.springContext = new SpringContextFactory(new MicroserverConfigurer().buildConfig(c), c, modules[0].getSpringConfigurationClasses()).createSpringContext();
    }

    private void initSpringProperties(Module m) {
        System.setProperty("server.contextPath", "/" + m.getContext());
    }

    private Class extractClass() {
        try {
            return Class.forName(new Exception().getStackTrace()[2].getClassName());
        }
        catch (ClassNotFoundException e) {
            throw ExceptionSoftener.throwSoftenedException((Throwable)e);
        }
    }

    public void stop() {
        this.end.complete(true);
        Config.reset();
    }

    public void run() {
        this.start().forEach(thread -> this.join((Thread)thread));
    }

    public List<Thread> start() {
        ServerRunner runner;
        ListX apps = this.modules.map(module -> this.createServer((Module)module));
        try {
            runner = new ServerRunner((ApplicationRegister)this.springContext.getBean(ApplicationRegister.class), (List<ServerApplication>)apps, this.end);
        }
        catch (BeansException e) {
            runner = new ServerRunner((List<ServerApplication>)apps, this.end);
        }
        return runner.run();
    }

    private ServerApplication createServer(Module module) {
        List applications = ReactiveSeq.fromStream((Stream)PluginLoader.INSTANCE.plugins.get().stream()).filter(m -> m.serverApplicationFactory() != null).map(Plugin::serverApplicationFactory).flatMap(StreamUtils::optionalToStream).toList();
        if (applications.size() > 1) {
            this.logger.error("ERROR!  Multiple server application factories found : The solution is remove one these plugins from your classpath ", (Object)applications);
            System.err.println("ERROR!  Multiple server application factories found : The solution is remove one these plugins from your classpath " + applications);
            throw new IncorrectNumberOfServersConfiguredException("Multiple server application factories found : The solution is remove one these plugins from your classpath " + applications);
        }
        if (applications.size() == 0) {
            this.logger.error("ERROR!  No server application factories found. If you using micro-spring-boot don't call MicroserverApp.start() method. A possible solution is add one of micro-grizzly or micro-tomcat to the classpath.");
            System.err.println("ERROR!  No server application factories found. If you using micro-spring-boot don't call MicroserverApp.start() method. A possible solution is add one of micro-grizzly or micro-tomcat to the classpath.");
            throw new IncorrectNumberOfServersConfiguredException("No server application factories found. If you using micro-spring-boot don't call MicroserverApp.start() method. A possible solution is add one of micro-grizzly or micro-tomcat to the classpath. ");
        }
        ServerApplication app = ((ServerApplicationFactory)applications.get(0)).createApp(module, this.springContext);
        if (Config.instance().getSslProperties() != null) {
            return app.withSSLProperties(Config.instance().getSslProperties());
        }
        return app;
    }

    private void join(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ExceptionSoftener.throwSoftenedException((Throwable)e);
        }
    }

    public ApplicationContext getSpringContext() {
        return this.springContext;
    }
}

