/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.spring.properties;

import com.aol.micro.server.config.Config;
import com.aol.micro.server.config.ConfigAccessor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

@Configuration
public class PropertyFileConfig {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFileConfig.class);

    public PropertyFileConfig() {
    }

    public PropertyFileConfig(boolean set) {
        if (set) {
            new Config().set();
        }
    }

    @Bean
    public static PropertyPlaceholderConfigurer propertyPlaceholderConfigurer() throws IOException {
        PropertyPlaceholderConfigurer configurer = new PropertyPlaceholderConfigurer();
        Properties props = PropertyFileConfig.propertyFactory();
        configurer.setProperties(props);
        configurer.setSystemPropertiesMode(2);
        return configurer;
    }

    @Bean
    public static Properties propertyFactory() throws IOException {
        List<Resource> resources = PropertyFileConfig.loadPropertyResource();
        PropertiesFactoryBean factory = new PropertiesFactoryBean();
        factory.setLocations(resources.toArray(new Resource[resources.size()]));
        factory.afterPropertiesSet();
        Properties props = factory.getObject();
        props.putAll((Map<?, ?>)new ConfigAccessor().get().getProperties());
        return props;
    }

    private static List<Resource> loadPropertyResource() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        String applicationPropertyFileName = new ConfigAccessor().get().getPropertiesName();
        PropertyFileConfig.loadProperties(applicationPropertyFileName, "application").ifPresent(it -> resources.add((Resource)it));
        String serviceTypePropertyFileName = new ConfigAccessor().get().getServiceTypePropertiesName();
        PropertyFileConfig.loadProperties(serviceTypePropertyFileName, "service-type").ifPresent(it -> resources.add((Resource)it));
        String instancePropertyFileName = new ConfigAccessor().get().getInstancePropertiesName();
        PropertyFileConfig.loadProperties(instancePropertyFileName, "instance").ifPresent(it -> resources.add((Resource)it));
        return resources;
    }

    private static Optional<Resource> loadProperties(String applicationPropertyFileName, String type) {
        URL envResource;
        URL urlResource;
        Optional<Resource> resource = Optional.empty();
        if (new File("./" + applicationPropertyFileName).exists()) {
            resource = Optional.of(new FileSystemResource(new File("./" + applicationPropertyFileName)));
            logger.info("./" + applicationPropertyFileName + " added");
        }
        if ((urlResource = PropertyFileConfig.class.getClassLoader().getResource(applicationPropertyFileName)) != null) {
            resource = Optional.of(new UrlResource(urlResource));
            logger.info(applicationPropertyFileName + " added");
        }
        if (System.getProperty(type + ".env") != null && (envResource = PropertyFileConfig.class.getClassLoader().getResource(PropertyFileConfig.createEnvBasedPropertyFileName(applicationPropertyFileName))) != null) {
            resource = Optional.of(new UrlResource(envResource));
            logger.info(PropertyFileConfig.createEnvBasedPropertyFileName(applicationPropertyFileName) + " added");
        }
        if (System.getProperty(type + ".property.file") != null) {
            resource = Optional.of(new FileSystemResource(new File(System.getProperty(type + ".property.file"))));
            logger.info(System.getProperty("application.property.file") + " added");
        }
        return resource;
    }

    private static String createEnvBasedPropertyFileName(String applicationPropertyFileName) {
        return applicationPropertyFileName.substring(0, applicationPropertyFileName.lastIndexOf(".")) + "-" + System.getProperty("application.env") + ".properties";
    }
}

