/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.servers.model;

import com.aol.micro.server.servers.model.FilterData;
import com.aol.micro.server.servers.model.ServerData;
import com.aol.micro.server.servers.model.ServletData;
import com.aol.micro.server.utility.UsefulStaticMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestListener;
import org.pcollections.ConsPStack;
import org.pcollections.PStack;

public class AllData {
    private final ServerData serverData;
    private final PStack<FilterData> filterDataList;
    private final PStack<ServletData> servletDataList;
    private final PStack<ServletContextListener> servletContextListeners;
    private final PStack<ServletRequestListener> servletRequestListeners;

    public AllData(ServerData serverData, List<FilterData> filterDataList, List<ServletData> servletDataList, List<ServletContextListener> servletContextListeners, List<ServletRequestListener> servletRequestListeners) {
        this.servletContextListeners = ConsPStack.from((Collection)UsefulStaticMethods.either(servletContextListeners, new ArrayList()));
        this.servletRequestListeners = ConsPStack.from((Collection)UsefulStaticMethods.either(servletRequestListeners, new ArrayList()));
        this.filterDataList = ConsPStack.from((Collection)UsefulStaticMethods.either(filterDataList, new ArrayList()));
        this.servletDataList = ConsPStack.from((Collection)UsefulStaticMethods.either(servletDataList, new ArrayList()));
        this.serverData = serverData;
    }

    public static AllDataBuilder builder() {
        return new AllDataBuilder();
    }

    public ServerData getServerData() {
        return this.serverData;
    }

    public PStack<FilterData> getFilterDataList() {
        return this.filterDataList;
    }

    public PStack<ServletData> getServletDataList() {
        return this.servletDataList;
    }

    public PStack<ServletContextListener> getServletContextListeners() {
        return this.servletContextListeners;
    }

    public PStack<ServletRequestListener> getServletRequestListeners() {
        return this.servletRequestListeners;
    }

    public static class AllDataBuilder {
        private ServerData serverData;
        private PStack<FilterData> filterDataList;
        private PStack<ServletData> servletDataList;
        private PStack<ServletContextListener> servletContextListeners;
        private PStack<ServletRequestListener> servletRequestListeners;

        AllDataBuilder() {
        }

        public AllDataBuilder serverData(ServerData serverData) {
            this.serverData = serverData;
            return this;
        }

        public AllDataBuilder filterDataList(PStack<FilterData> filterDataList) {
            this.filterDataList = filterDataList;
            return this;
        }

        public AllDataBuilder servletDataList(PStack<ServletData> servletDataList) {
            this.servletDataList = servletDataList;
            return this;
        }

        public AllDataBuilder servletContextListeners(PStack<ServletContextListener> servletContextListeners) {
            this.servletContextListeners = servletContextListeners;
            return this;
        }

        public AllDataBuilder servletRequestListeners(PStack<ServletRequestListener> servletRequestListeners) {
            this.servletRequestListeners = servletRequestListeners;
            return this;
        }

        public AllData build() {
            return new AllData(this.serverData, (List<FilterData>)this.filterDataList, (List<ServletData>)this.servletDataList, (List<ServletContextListener>)this.servletContextListeners, (List<ServletRequestListener>)this.servletRequestListeners);
        }

        public String toString() {
            return "AllData.AllDataBuilder(serverData=" + this.serverData + ", filterDataList=" + this.filterDataList + ", servletDataList=" + this.servletDataList + ", servletContextListeners=" + this.servletContextListeners + ", servletRequestListeners=" + this.servletRequestListeners + ")";
        }
    }
}

