/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.servers;

import com.aol.micro.server.module.Module;
import com.aol.micro.server.servers.ApplicationRegister;
import com.aol.micro.server.servers.JaxRsServletConfigurer;
import com.aol.micro.server.servers.ServerApplication;
import com.aol.micro.server.servers.ServerThreadLocalVariables;
import com.aol.micro.server.servers.model.ServerData;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.pcollections.ConsPStack;
import org.pcollections.PStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRunner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PStack<ServerApplication> apps;
    private final Optional<ApplicationRegister> register;
    private final CompletableFuture end;

    public ServerRunner(ApplicationRegister register, List<ServerApplication> apps, CompletableFuture end) {
        this.apps = ConsPStack.from(apps);
        this.register = Optional.of(register);
        this.end = end;
    }

    public ServerRunner(List<ServerApplication> apps, CompletableFuture end) {
        this.apps = ConsPStack.from(apps);
        this.register = Optional.empty();
        this.end = end;
    }

    public List<Thread> run() {
        this.register.ifPresent(reg -> reg.register(this.apps.stream().map(app -> app.getServerData()).collect(Collectors.toList()).toArray(new ServerData[0])));
        HashMap mapFutures = new HashMap();
        this.apps.stream().forEach(app -> mapFutures.put(app, new CompletableFuture()));
        List<Thread> threads = this.apps.stream().map(app -> this.start((ServerApplication)app, app.getServerData().getModule(), (CompletableFuture)mapFutures.get(app))).collect(Collectors.toList());
        mapFutures.values().forEach(future -> this.get((CompletableFuture)future));
        this.logger.info("Started {} Rest applications ", (Object)this.apps.size());
        return threads;
    }

    private void get(CompletableFuture future) {
        try {
            future.get();
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Thread start(ServerApplication next, Module module, CompletableFuture start) {
        Thread t = new Thread(() -> {
            ServerThreadLocalVariables.getContext().set(module.getContext());
            next.run(start, new JaxRsServletConfigurer(), this.end);
        });
        t.setName(module.getContext());
        t.start();
        return t;
    }
}

