/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.module;

import com.aol.cyclops.data.collections.extensions.persistent.PStackX;
import com.aol.cyclops.util.ExceptionSoftener;
import com.aol.micro.server.auto.discovery.CommonRestResource;
import com.aol.micro.server.utility.UsefulStaticMethods;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestResourceTagBuilder {
    private static final Logger logger = LoggerFactory.getLogger(RestResourceTagBuilder.class);
    private static PStackX<Class> defaultTags = PStackX.of((Object[])new Class[]{CommonRestResource.class});

    public static PStackX<Class> restResourceTags(String ... classes) {
        return PStackX.fromCollection(UsefulStaticMethods.concat(Stream.of(classes).map(cl -> RestResourceTagBuilder.toClass(cl)).collect(Collectors.toList()), defaultTags));
    }

    public static PStackX<Class> restResourceTags(Class ... classes) {
        return PStackX.fromCollection(UsefulStaticMethods.concat(Stream.of(classes).collect(Collectors.toList()), defaultTags));
    }

    private static Class toClass(String cl) {
        try {
            return Class.forName(cl);
        }
        catch (ClassNotFoundException e) {
            logger.error("Class not found for {}", (Object)cl);
            ExceptionSoftener.throwSoftenedException((Throwable)e);
            return null;
        }
    }

    public static void setDefaultTags(PStackX<Class> defaultTags) {
        RestResourceTagBuilder.defaultTags = defaultTags;
    }
}

