/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.module;

import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.collections.extensions.persistent.PMapX;
import com.aol.cyclops.data.collections.extensions.persistent.PSetX;
import com.aol.cyclops.data.collections.extensions.persistent.PStackX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.util.stream.StreamUtils;
import com.aol.micro.server.Plugin;
import com.aol.micro.server.PluginLoader;
import com.aol.micro.server.auto.discovery.Rest;
import com.aol.micro.server.auto.discovery.RestResource;
import com.aol.micro.server.config.Classes;
import com.aol.micro.server.module.IncorrectJaxRsPluginsException;
import com.aol.micro.server.module.JaxRsProvider;
import com.aol.micro.server.module.WebServerProvider;
import com.aol.micro.server.servers.model.ServerData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestListener;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public interface Module {
    default public PMapX<String, Object> getServerProperties() {
        return PMapX.empty();
    }

    default public <T> Consumer<WebServerProvider<T>> getServerConfigManager() {
        return server -> {};
    }

    default public <T> Consumer<JaxRsProvider<T>> getResourceConfigManager() {
        return rc -> {};
    }

    default public PStackX<String> getPackages() {
        return PStackX.empty();
    }

    default public PMapX<String, String> getPropertyOverrides() {
        return PMapX.empty();
    }

    default public PSetX<Class> getSpringConfigurationClasses() {
        return PSetX.of((Object[])Classes.CORE_CLASSES.getClasses());
    }

    default public PStackX<Class> getRestResourceClasses() {
        return PStackX.of((Object[])new Class[]{RestResource.class});
    }

    default public PStackX<Class> getRestAnnotationClasses() {
        return PStackX.of((Object[])new Class[]{Rest.class});
    }

    default public PStackX<String> getDefaultJaxRsPackages() {
        return PluginLoader.INSTANCE.plugins.get().stream().filter(module -> module.servletContextListeners() != null).flatMapIterable(Plugin::jaxRsPackages).toPStackX();
    }

    default public PStackX<Class> getDefaultResources() {
        return PluginLoader.INSTANCE.plugins.get().stream().filter(module -> module.servletContextListeners() != null).flatMapIterable(Plugin::jaxRsResources).toPStackX();
    }

    default public PStackX<ServletContextListener> getListeners(ServerData data) {
        ArrayList<ContextLoaderListener> list = new ArrayList<ContextLoaderListener>();
        if (data.getRootContext() instanceof WebApplicationContext) {
            list.add(new ContextLoaderListener((WebApplicationContext)data.getRootContext()));
        }
        ListX<Plugin> modules = PluginLoader.INSTANCE.plugins.get();
        PStackX listeners = modules.stream().filter(module -> module.servletContextListeners() != null).flatMapIterable(Plugin::servletContextListeners).map(fn -> (ServletContextListener)fn.apply(data)).toPStackX();
        return listeners.plusAll(list);
    }

    default public PStackX<ServletRequestListener> getRequestListeners(ServerData data) {
        return PluginLoader.INSTANCE.plugins.get().stream().filter(module -> module.servletRequestListeners() != null).flatMapIterable(Plugin::servletRequestListeners).map(fn -> (ServletRequestListener)fn.apply(data)).toPStackX();
    }

    default public PMapX<String, Filter> getFilters(ServerData data) {
        HashMap map = new HashMap();
        ReactiveSeq.fromStream((Stream)PluginLoader.INSTANCE.plugins.get().stream()).filter(module -> module.filters() != null).map(module -> module.filters().apply(data)).forEach(pluginMap -> map.putAll(pluginMap));
        return PMapX.fromMap(map);
    }

    default public PMapX<String, Servlet> getServlets(ServerData data) {
        HashMap map = new HashMap();
        ReactiveSeq.fromStream((Stream)PluginLoader.INSTANCE.plugins.get().stream()).filter(module -> module.servlets() != null).map(module -> module.servlets().apply(data)).forEach(pluginMap -> map.putAll(pluginMap));
        return PMapX.fromMap(map);
    }

    default public String getJaxWsRsApplication() {
        List jaxRsApplications = ReactiveSeq.fromStream((Stream)PluginLoader.INSTANCE.plugins.get().stream()).filter(module -> module.jaxWsRsApplication() != null).map(Plugin::jaxWsRsApplication).flatMap(StreamUtils::optionalToStream).toList();
        if (jaxRsApplications.size() > 1) {
            throw new IncorrectJaxRsPluginsException("ERROR!  Multiple jax-rs application plugins found,  a possible solution is to remove micro-jackson or other jax-rs application provider from your classpath. " + jaxRsApplications);
        }
        if (jaxRsApplications.size() == 0) {
            throw new IncorrectJaxRsPluginsException("ERROR!  No jax-rs application plugins found, a possible solution is to add micro-jackson to your classpath. ");
        }
        return (String)jaxRsApplications.get(0);
    }

    default public String getProviders() {
        String additional = ReactiveSeq.fromStream((Stream)PluginLoader.INSTANCE.plugins.get().stream()).peek(System.out::println).filter(module -> module.providers() != null).flatMapIterable(Plugin::providers).join(",");
        if (StringUtils.isEmpty((Object)additional)) {
            return "com.aol.micro.server.rest.providers";
        }
        return "com.aol.micro.server.rest.providers," + additional;
    }

    public String getContext();
}

