/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.config;

import com.aol.cyclops.control.ReactiveSeq;
import com.aol.micro.server.PluginLoader;
import com.aol.micro.server.config.Config;
import com.aol.micro.server.config.Configurer;
import com.aol.micro.server.config.Microserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.pcollections.HashTreePMap;
import org.pcollections.HashTreePSet;
import org.pcollections.PMap;
import org.pcollections.PSet;

public class MicroserverConfigurer
implements Configurer {
    @Override
    public Config buildConfig(Class class1) {
        String[] basePackages;
        Microserver microserver = class1.getAnnotation(Microserver.class);
        if (microserver == null) {
            microserver = Microserver.Instance.class.getAnnotation(Microserver.class);
        }
        if ((basePackages = microserver.basePackages()).length == 0) {
            String[] basePackagesFromClass = new String[]{class1.getPackage().getName()};
            basePackages = basePackagesFromClass;
        }
        List<Class> classes = this.buildClasses(class1, microserver);
        Map<String, String> properties = this.buildProperties(microserver);
        return Config.instance().withBasePackages(basePackages).withEntityScan(microserver.entityScan()).withClasses((PSet<Class>)HashTreePSet.from(classes)).withPropertiesName(microserver.propertiesName()).withInstancePropertiesName(microserver.instancePropertiesName()).withServiceTypePropertiesName(microserver.serviceTypePropertiesName()).withAllowCircularReferences(microserver.allowCircularDependencies()).withProperties((PMap<String, String>)HashTreePMap.from(properties)).set();
    }

    private Map<String, String> buildProperties(Microserver microserver) {
        Map properties = ReactiveSeq.of((Object[])microserver.properties()).grouped(2).toMap(prop -> (String)prop.get(0), prop -> (String)prop.get(1));
        return properties;
    }

    private List<Class> buildClasses(Class class1, Microserver microserver) {
        List modules;
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(class1);
        if (microserver.classes() != null) {
            classes.addAll(Arrays.asList(microserver.classes()));
        }
        if ((modules = (List)PluginLoader.INSTANCE.plugins.get()).size() > 0) {
            classes.addAll(ReactiveSeq.fromStream(modules.stream()).flatMap(module -> module.springClasses().stream()).toList());
        }
        return classes;
    }
}

