/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.servers;

import com.aol.micro.server.auto.discovery.FilterConfiguration;
import com.aol.micro.server.servers.model.FilterData;
import com.aol.micro.server.servers.model.ServerData;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import org.pcollections.PStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterConfigurer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServerData serverData;
    private final PStack<FilterData> filterData;

    public void addFilters(ServletContext webappContext) {
        this.addExplicitlyDeclaredFilters(webappContext);
        this.addAutoDiscoveredFilters(webappContext);
    }

    private void addAutoDiscoveredFilters(ServletContext webappContext) {
        this.serverData.getRootContext().getBeansOfType(FilterConfiguration.class).values().stream().filter(f -> f.getMapping() != null).filter(f -> f.getMapping().length > 0).peek(this::logFilter).forEach(filter -> this.setInitParameters(webappContext.addFilter(this.getName((FilterConfiguration)filter), this.getClass((FilterConfiguration)filter)), (FilterConfiguration)filter).addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, filter.getMapping()));
    }

    private void addExplicitlyDeclaredFilters(ServletContext webappContext) {
        for (FilterData filterData : this.filterData) {
            FilterRegistration.Dynamic filterReg = webappContext.addFilter(filterData.getFilterName(), filterData.getFilter());
            filterReg.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{filterData.getMapping()});
            this.logFilter(filterData);
        }
    }

    private void logFilter(FilterData filter) {
        this.logger.info("Registering {} filter on {}", (Object)filter.getFilter().getClass().getName(), (Object)filter.getMapping());
    }

    private void logFilter(FilterConfiguration filter) {
        this.logger.info("Registering {} filter on {}", (Object)filter.getClass().getName(), (Object)filter.getMapping()[0]);
    }

    private Class<? extends Filter> getClass(FilterConfiguration filter) {
        if (filter.getFilter() != null) {
            return filter.getFilter();
        }
        return filter.getClass();
    }

    private FilterRegistration.Dynamic setInitParameters(FilterRegistration.Dynamic addFilter, FilterConfiguration filter) {
        addFilter.setInitParameters(filter.getInitParameters());
        return addFilter;
    }

    private String getName(FilterConfiguration filter) {
        if (filter.getName() != null) {
            return filter.getName();
        }
        return filter.getClass().getName();
    }

    @ConstructorProperties(value={"serverData", "filterData"})
    public FilterConfigurer(ServerData serverData, PStack<FilterData> filterData) {
        this.serverData = serverData;
        this.filterData = filterData;
    }
}

