/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.module;

import com.aol.cyclops.data.collections.extensions.persistent.PMapX;
import com.aol.cyclops.data.collections.extensions.persistent.PSetX;
import com.aol.cyclops.data.collections.extensions.persistent.PStackX;
import com.aol.micro.server.auto.discovery.CommonRestResource;
import com.aol.micro.server.module.JaxRsProvider;
import com.aol.micro.server.module.Module;
import com.aol.micro.server.module.WebServerProvider;
import com.aol.micro.server.servers.model.ServerData;
import com.aol.micro.server.utility.HashMapBuilder;
import com.aol.micro.server.utility.UsefulStaticMethods;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestListener;

public class ConfigurableModule
implements Module {
    private final List<Class> restResourceClasses;
    private final List<Class> restAnnotationClasses;
    private final List<Class> defaultResources;
    private final List<ServletContextListener> listeners;
    private final List<ServletRequestListener> requestListeners;
    private final Map<String, Filter> filters;
    private final Map<String, Servlet> servlets;
    private final String jaxWsRsApplication;
    private final String providers;
    private final String context;
    private final Set<Class> springConfigurationClasses;
    private final Map<String, String> propertyOverrides;
    private final List<String> defaultJaxRsPackages;
    private final Consumer<WebServerProvider<?>> serverConfigManager;
    private final Consumer<JaxRsProvider<?>> resourceConfigManager;
    private final Map<String, Object> serverProperties;
    final boolean resetAll;

    public <T> ConfigurableModule withResourceConfigManager(Consumer<JaxRsProvider<T>> resourceConfigManager) {
        return new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, resourceConfigManager, this.serverProperties, this.resetAll);
    }

    public <T> ConfigurableModule withServerConfigManager(Consumer<WebServerProvider<?>> serverConfigManager) {
        return new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
    }

    @Override
    public <T> Consumer<WebServerProvider<T>> getServerConfigManager() {
        if (this.serverConfigManager != null) {
            return this.serverConfigManager;
        }
        return Module.super.getServerConfigManager();
    }

    @Override
    public <T> Consumer<JaxRsProvider<T>> getResourceConfigManager() {
        if (this.resourceConfigManager != null) {
            return this.resourceConfigManager;
        }
        return Module.super.getResourceConfigManager();
    }

    @Override
    public PStackX<String> getDefaultJaxRsPackages() {
        if (this.defaultJaxRsPackages != null) {
            return PStackX.fromCollection(UsefulStaticMethods.concat(this.defaultJaxRsPackages, this.extract(() -> Module.super.getDefaultJaxRsPackages())));
        }
        return Module.super.getDefaultJaxRsPackages();
    }

    private <T> Collection<T> extract(Supplier<Collection<T>> s) {
        if (!this.resetAll) {
            return s.get();
        }
        return Arrays.asList(new Object[0]);
    }

    private <K, V> Map<K, V> extractMap(Supplier<Map<K, V>> s) {
        if (!this.resetAll) {
            return s.get();
        }
        return HashMapBuilder.of();
    }

    @Override
    public PStackX<Class> getRestResourceClasses() {
        if (this.restResourceClasses != null) {
            return PStackX.fromCollection(UsefulStaticMethods.concat(this.restResourceClasses, this.extract(() -> Collections.singletonList(CommonRestResource.class))));
        }
        return Module.super.getRestResourceClasses();
    }

    @Override
    public PStackX<Class> getRestAnnotationClasses() {
        if (this.restAnnotationClasses != null) {
            return PStackX.fromCollection(UsefulStaticMethods.concat(this.restAnnotationClasses, this.extract(() -> Module.super.getRestAnnotationClasses())));
        }
        return Module.super.getRestAnnotationClasses();
    }

    @Override
    public PStackX<Class> getDefaultResources() {
        if (this.defaultResources != null) {
            return PStackX.fromCollection(UsefulStaticMethods.concat(this.defaultResources, this.extract(() -> Module.super.getDefaultResources())));
        }
        return Module.super.getDefaultResources();
    }

    @Override
    public PStackX<ServletContextListener> getListeners(ServerData data) {
        if (this.listeners != null) {
            return PStackX.fromCollection(UsefulStaticMethods.concat(this.listeners, this.extract(() -> Module.super.getListeners(data))));
        }
        return Module.super.getListeners(data);
    }

    @Override
    public PStackX<ServletRequestListener> getRequestListeners(ServerData data) {
        if (this.requestListeners != null) {
            return PStackX.fromCollection(UsefulStaticMethods.concat(this.requestListeners, this.extract(() -> Module.super.getRequestListeners(data))));
        }
        return Module.super.getRequestListeners(data);
    }

    @Override
    public PMapX<String, Filter> getFilters(ServerData data) {
        if (this.filters != null) {
            return PMapX.fromMap(this.filters).plusAll(this.extractMap(() -> Module.super.getFilters(data)));
        }
        return Module.super.getFilters(data);
    }

    @Override
    public PMapX<String, Servlet> getServlets(ServerData data) {
        if (this.servlets != null) {
            return PMapX.fromMap(this.servlets).plusAll(this.extractMap(() -> Module.super.getServlets(data)));
        }
        return Module.super.getServlets(data);
    }

    @Override
    public String getJaxWsRsApplication() {
        if (this.jaxWsRsApplication != null) {
            return this.jaxWsRsApplication;
        }
        return Module.super.getJaxWsRsApplication();
    }

    @Override
    public String getProviders() {
        if (this.providers != null) {
            return this.providers;
        }
        return Module.super.getProviders();
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public PSetX<Class> getSpringConfigurationClasses() {
        if (this.springConfigurationClasses != null) {
            return PSetX.fromCollection(UsefulStaticMethods.concat(this.springConfigurationClasses, this.extract(() -> Module.super.getSpringConfigurationClasses())));
        }
        return Module.super.getSpringConfigurationClasses();
    }

    @Override
    public PMapX<String, Object> getServerProperties() {
        if (this.serverProperties != null) {
            return PMapX.fromMap(this.serverProperties).plusAll(this.extractMap(() -> Module.super.getServerProperties()));
        }
        return Module.super.getServerProperties();
    }

    public static ConfigurableModuleBuilder builder() {
        return new ConfigurableModuleBuilder();
    }

    @ConstructorProperties(value={"restResourceClasses", "restAnnotationClasses", "defaultResources", "listeners", "requestListeners", "filters", "servlets", "jaxWsRsApplication", "providers", "context", "springConfigurationClasses", "propertyOverrides", "defaultJaxRsPackages", "serverConfigManager", "resourceConfigManager", "serverProperties", "resetAll"})
    public ConfigurableModule(List<Class> restResourceClasses, List<Class> restAnnotationClasses, List<Class> defaultResources, List<ServletContextListener> listeners, List<ServletRequestListener> requestListeners, Map<String, Filter> filters, Map<String, Servlet> servlets, String jaxWsRsApplication, String providers, String context, Set<Class> springConfigurationClasses, Map<String, String> propertyOverrides, List<String> defaultJaxRsPackages, Consumer<WebServerProvider<?>> serverConfigManager, Consumer<JaxRsProvider<?>> resourceConfigManager, Map<String, Object> serverProperties, boolean resetAll) {
        this.restResourceClasses = restResourceClasses;
        this.restAnnotationClasses = restAnnotationClasses;
        this.defaultResources = defaultResources;
        this.listeners = listeners;
        this.requestListeners = requestListeners;
        this.filters = filters;
        this.servlets = servlets;
        this.jaxWsRsApplication = jaxWsRsApplication;
        this.providers = providers;
        this.context = context;
        this.springConfigurationClasses = springConfigurationClasses;
        this.propertyOverrides = propertyOverrides;
        this.defaultJaxRsPackages = defaultJaxRsPackages;
        this.serverConfigManager = serverConfigManager;
        this.resourceConfigManager = resourceConfigManager;
        this.serverProperties = serverProperties;
        this.resetAll = resetAll;
    }

    public ConfigurableModule withRestResourceClasses(List<Class> restResourceClasses) {
        return this.restResourceClasses == restResourceClasses ? this : new ConfigurableModule(restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
    }

    public ConfigurableModule withRestAnnotationClasses(List<Class> restAnnotationClasses) {
        return this.restAnnotationClasses == restAnnotationClasses ? this : new ConfigurableModule(this.restResourceClasses, restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
    }

    public ConfigurableModule withDefaultResources(List<Class> defaultResources) {
        return this.defaultResources == defaultResources ? this : new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, defaultResources, this.listeners, this.requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
    }

    public ConfigurableModule withListeners(List<ServletContextListener> listeners) {
        return this.listeners == listeners ? this : new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, listeners, this.requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
    }

    public ConfigurableModule withRequestListeners(List<ServletRequestListener> requestListeners) {
        return this.requestListeners == requestListeners ? this : new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
    }

    public ConfigurableModule withFilters(Map<String, Filter> filters) {
        return this.filters == filters ? this : new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, filters, this.servlets, this.jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
    }

    public ConfigurableModule withServlets(Map<String, Servlet> servlets) {
        return this.servlets == servlets ? this : new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, this.filters, servlets, this.jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
    }

    public ConfigurableModule withJaxWsRsApplication(String jaxWsRsApplication) {
        return this.jaxWsRsApplication == jaxWsRsApplication ? this : new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, this.filters, this.servlets, jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
    }

    public ConfigurableModule withProviders(String providers) {
        return this.providers == providers ? this : new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, providers, this.context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
    }

    public ConfigurableModule withContext(String context) {
        return this.context == context ? this : new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, this.providers, context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
    }

    public ConfigurableModule withSpringConfigurationClasses(Set<Class> springConfigurationClasses) {
        return this.springConfigurationClasses == springConfigurationClasses ? this : new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, this.providers, this.context, springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
    }

    public ConfigurableModule withPropertyOverrides(Map<String, String> propertyOverrides) {
        return this.propertyOverrides == propertyOverrides ? this : new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
    }

    public ConfigurableModule withDefaultJaxRsPackages(List<String> defaultJaxRsPackages) {
        return this.defaultJaxRsPackages == defaultJaxRsPackages ? this : new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, this.propertyOverrides, defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
    }

    public ConfigurableModule withServerProperties(Map<String, Object> serverProperties) {
        return this.serverProperties == serverProperties ? this : new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, serverProperties, this.resetAll);
    }

    public ConfigurableModule withResetAll(boolean resetAll) {
        return this.resetAll == resetAll ? this : new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, resetAll);
    }

    public static class ConfigurableModuleBuilder {
        private List<Class> restResourceClasses;
        private List<Class> restAnnotationClasses;
        private List<Class> defaultResources;
        private List<ServletContextListener> listeners;
        private List<ServletRequestListener> requestListeners;
        private Map<String, Filter> filters;
        private Map<String, Servlet> servlets;
        private String jaxWsRsApplication;
        private String providers;
        private String context;
        private Set<Class> springConfigurationClasses;
        private Map<String, String> propertyOverrides;
        private List<String> defaultJaxRsPackages;
        private Consumer<WebServerProvider<?>> serverConfigManager;
        private Consumer<JaxRsProvider<?>> resourceConfigManager;
        private Map<String, Object> serverProperties;
        private boolean resetAll;

        ConfigurableModuleBuilder() {
        }

        public ConfigurableModuleBuilder restResourceClasses(List<Class> restResourceClasses) {
            this.restResourceClasses = restResourceClasses;
            return this;
        }

        public ConfigurableModuleBuilder restAnnotationClasses(List<Class> restAnnotationClasses) {
            this.restAnnotationClasses = restAnnotationClasses;
            return this;
        }

        public ConfigurableModuleBuilder defaultResources(List<Class> defaultResources) {
            this.defaultResources = defaultResources;
            return this;
        }

        public ConfigurableModuleBuilder listeners(List<ServletContextListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public ConfigurableModuleBuilder requestListeners(List<ServletRequestListener> requestListeners) {
            this.requestListeners = requestListeners;
            return this;
        }

        public ConfigurableModuleBuilder filters(Map<String, Filter> filters) {
            this.filters = filters;
            return this;
        }

        public ConfigurableModuleBuilder servlets(Map<String, Servlet> servlets) {
            this.servlets = servlets;
            return this;
        }

        public ConfigurableModuleBuilder jaxWsRsApplication(String jaxWsRsApplication) {
            this.jaxWsRsApplication = jaxWsRsApplication;
            return this;
        }

        public ConfigurableModuleBuilder providers(String providers) {
            this.providers = providers;
            return this;
        }

        public ConfigurableModuleBuilder context(String context) {
            this.context = context;
            return this;
        }

        public ConfigurableModuleBuilder springConfigurationClasses(Set<Class> springConfigurationClasses) {
            this.springConfigurationClasses = springConfigurationClasses;
            return this;
        }

        public ConfigurableModuleBuilder propertyOverrides(Map<String, String> propertyOverrides) {
            this.propertyOverrides = propertyOverrides;
            return this;
        }

        public ConfigurableModuleBuilder defaultJaxRsPackages(List<String> defaultJaxRsPackages) {
            this.defaultJaxRsPackages = defaultJaxRsPackages;
            return this;
        }

        public ConfigurableModuleBuilder serverConfigManager(Consumer<WebServerProvider<?>> serverConfigManager) {
            this.serverConfigManager = serverConfigManager;
            return this;
        }

        public ConfigurableModuleBuilder resourceConfigManager(Consumer<JaxRsProvider<?>> resourceConfigManager) {
            this.resourceConfigManager = resourceConfigManager;
            return this;
        }

        public ConfigurableModuleBuilder serverProperties(Map<String, Object> serverProperties) {
            this.serverProperties = serverProperties;
            return this;
        }

        public ConfigurableModuleBuilder resetAll(boolean resetAll) {
            this.resetAll = resetAll;
            return this;
        }

        public ConfigurableModule build() {
            return new ConfigurableModule(this.restResourceClasses, this.restAnnotationClasses, this.defaultResources, this.listeners, this.requestListeners, this.filters, this.servlets, this.jaxWsRsApplication, this.providers, this.context, this.springConfigurationClasses, this.propertyOverrides, this.defaultJaxRsPackages, this.serverConfigManager, this.resourceConfigManager, this.serverProperties, this.resetAll);
        }

        public String toString() {
            return "ConfigurableModule.ConfigurableModuleBuilder(restResourceClasses=" + this.restResourceClasses + ", restAnnotationClasses=" + this.restAnnotationClasses + ", defaultResources=" + this.defaultResources + ", listeners=" + this.listeners + ", requestListeners=" + this.requestListeners + ", filters=" + this.filters + ", servlets=" + this.servlets + ", jaxWsRsApplication=" + this.jaxWsRsApplication + ", providers=" + this.providers + ", context=" + this.context + ", springConfigurationClasses=" + this.springConfigurationClasses + ", propertyOverrides=" + this.propertyOverrides + ", defaultJaxRsPackages=" + this.defaultJaxRsPackages + ", serverConfigManager=" + this.serverConfigManager + ", resourceConfigManager=" + this.resourceConfigManager + ", serverProperties=" + this.serverProperties + ", resetAll=" + this.resetAll + ")";
        }
    }
}

