/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.config;

import com.aol.micro.server.config.SSLProperties;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.pcollections.HashTreePMap;
import org.pcollections.HashTreePSet;
import org.pcollections.PMap;
import org.pcollections.PSet;

public class Config {
    private final String defaultDataSourceName;
    private final PSet<Class> classes;
    private final PMap<String, String> properties;
    private final String propertiesName;
    private final String instancePropertiesName;
    private final String serviceTypePropertiesName;
    private final PMap<String, List<String>> dataSources;
    private final SSLProperties sslProperties;
    private final boolean allowCircularReferences;
    private final String[] basePackages;
    private static volatile Config instance = null;

    public Config() {
        this.classes = HashTreePSet.empty();
        this.properties = HashTreePMap.empty();
        this.dataSources = HashTreePMap.empty();
        this.defaultDataSourceName = "db";
        this.propertiesName = "application.properties";
        this.instancePropertiesName = "instance.properties";
        this.serviceTypePropertiesName = "service-type.properties";
        this.sslProperties = null;
        this.allowCircularReferences = false;
        this.basePackages = new String[0];
    }

    public Config set() {
        instance = this;
        return this;
    }

    public static Config instance() {
        instance = new Config();
        return instance;
    }

    static Config get() {
        return instance;
    }

    public static void reset() {
        instance = null;
    }

    public Config withEntityScanDataSource(String dataSource, String ... packages) {
        HashMap<String, List<String>> newMap = new HashMap<String, List<String>>((Map<String, List<String>>)this.dataSources);
        newMap.put(dataSource, Arrays.asList(packages));
        return this.withDataSources((PMap<String, List<String>>)HashTreePMap.from(newMap));
    }

    public Config withEntityScan(String ... packages) {
        HashMap<String, List<String>> newMap = new HashMap<String, List<String>>((Map<String, List<String>>)this.dataSources);
        newMap.put(this.defaultDataSourceName, Arrays.asList(packages));
        return this.withDataSources((PMap<String, List<String>>)HashTreePMap.from(newMap));
    }

    public Config withClassesArray(Class ... classes) {
        HashSet<Class> org = new HashSet<Class>((Collection<Class>)this.getClasses());
        for (Class c : classes) {
            org.add(c);
        }
        return this.withClasses((PSet<Class>)HashTreePSet.from(org));
    }

    @ConstructorProperties(value={"defaultDataSourceName", "classes", "properties", "propertiesName", "instancePropertiesName", "serviceTypePropertiesName", "dataSources", "sslProperties", "allowCircularReferences", "basePackages"})
    public Config(String defaultDataSourceName, PSet<Class> classes, PMap<String, String> properties, String propertiesName, String instancePropertiesName, String serviceTypePropertiesName, PMap<String, List<String>> dataSources, SSLProperties sslProperties, boolean allowCircularReferences, String[] basePackages) {
        this.defaultDataSourceName = defaultDataSourceName;
        this.classes = classes;
        this.properties = properties;
        this.propertiesName = propertiesName;
        this.instancePropertiesName = instancePropertiesName;
        this.serviceTypePropertiesName = serviceTypePropertiesName;
        this.dataSources = dataSources;
        this.sslProperties = sslProperties;
        this.allowCircularReferences = allowCircularReferences;
        this.basePackages = basePackages;
    }

    public String getDefaultDataSourceName() {
        return this.defaultDataSourceName;
    }

    public PSet<Class> getClasses() {
        return this.classes;
    }

    public PMap<String, String> getProperties() {
        return this.properties;
    }

    public String getPropertiesName() {
        return this.propertiesName;
    }

    public String getInstancePropertiesName() {
        return this.instancePropertiesName;
    }

    public String getServiceTypePropertiesName() {
        return this.serviceTypePropertiesName;
    }

    public PMap<String, List<String>> getDataSources() {
        return this.dataSources;
    }

    public SSLProperties getSslProperties() {
        return this.sslProperties;
    }

    public boolean isAllowCircularReferences() {
        return this.allowCircularReferences;
    }

    public String[] getBasePackages() {
        return this.basePackages;
    }

    public Config withDefaultDataSourceName(String defaultDataSourceName) {
        return this.defaultDataSourceName == defaultDataSourceName ? this : new Config(defaultDataSourceName, this.classes, this.properties, this.propertiesName, this.instancePropertiesName, this.serviceTypePropertiesName, this.dataSources, this.sslProperties, this.allowCircularReferences, this.basePackages);
    }

    public Config withClasses(PSet<Class> classes) {
        return this.classes == classes ? this : new Config(this.defaultDataSourceName, classes, this.properties, this.propertiesName, this.instancePropertiesName, this.serviceTypePropertiesName, this.dataSources, this.sslProperties, this.allowCircularReferences, this.basePackages);
    }

    public Config withProperties(PMap<String, String> properties) {
        return this.properties == properties ? this : new Config(this.defaultDataSourceName, this.classes, properties, this.propertiesName, this.instancePropertiesName, this.serviceTypePropertiesName, this.dataSources, this.sslProperties, this.allowCircularReferences, this.basePackages);
    }

    public Config withPropertiesName(String propertiesName) {
        return this.propertiesName == propertiesName ? this : new Config(this.defaultDataSourceName, this.classes, this.properties, propertiesName, this.instancePropertiesName, this.serviceTypePropertiesName, this.dataSources, this.sslProperties, this.allowCircularReferences, this.basePackages);
    }

    public Config withInstancePropertiesName(String instancePropertiesName) {
        return this.instancePropertiesName == instancePropertiesName ? this : new Config(this.defaultDataSourceName, this.classes, this.properties, this.propertiesName, instancePropertiesName, this.serviceTypePropertiesName, this.dataSources, this.sslProperties, this.allowCircularReferences, this.basePackages);
    }

    public Config withServiceTypePropertiesName(String serviceTypePropertiesName) {
        return this.serviceTypePropertiesName == serviceTypePropertiesName ? this : new Config(this.defaultDataSourceName, this.classes, this.properties, this.propertiesName, this.instancePropertiesName, serviceTypePropertiesName, this.dataSources, this.sslProperties, this.allowCircularReferences, this.basePackages);
    }

    public Config withDataSources(PMap<String, List<String>> dataSources) {
        return this.dataSources == dataSources ? this : new Config(this.defaultDataSourceName, this.classes, this.properties, this.propertiesName, this.instancePropertiesName, this.serviceTypePropertiesName, dataSources, this.sslProperties, this.allowCircularReferences, this.basePackages);
    }

    public Config withSslProperties(SSLProperties sslProperties) {
        return this.sslProperties == sslProperties ? this : new Config(this.defaultDataSourceName, this.classes, this.properties, this.propertiesName, this.instancePropertiesName, this.serviceTypePropertiesName, this.dataSources, sslProperties, this.allowCircularReferences, this.basePackages);
    }

    public Config withAllowCircularReferences(boolean allowCircularReferences) {
        return this.allowCircularReferences == allowCircularReferences ? this : new Config(this.defaultDataSourceName, this.classes, this.properties, this.propertiesName, this.instancePropertiesName, this.serviceTypePropertiesName, this.dataSources, this.sslProperties, allowCircularReferences, this.basePackages);
    }

    public Config withBasePackages(String[] basePackages) {
        return this.basePackages == basePackages ? this : new Config(this.defaultDataSourceName, this.classes, this.properties, this.propertiesName, this.instancePropertiesName, this.serviceTypePropertiesName, this.dataSources, this.sslProperties, this.allowCircularReferences, basePackages);
    }
}

