/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.servers.model;

import com.aol.cyclops.lambda.tuple.PTuple2;
import com.aol.cyclops.lambda.tuple.PowerTuples;
import com.aol.micro.server.module.Module;
import com.aol.micro.server.servers.model.RestResourceMissingPathException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.Path;
import org.pcollections.ConsPStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ServerData {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int port;
    private final List<Object> resources;
    private final ApplicationContext rootContext;
    private final String baseUrlPattern;
    private final Module module;

    public ServerData(int port, List resources, ApplicationContext rootContext, String baseUrlPattern, Module module) {
        this.port = port;
        this.module = module;
        this.resources = ConsPStack.from((Collection)resources);
        this.rootContext = rootContext;
        this.baseUrlPattern = baseUrlPattern;
    }

    public Stream<PTuple2<String, String>> extractResources() {
        return this.resources.stream().peek(resource -> this.logMissingPath(resource)).map(resource -> PowerTuples.tuple((Object)resource.getClass().getName(), (Object)resource.getClass().getAnnotation(Path.class).value()));
    }

    private void logMissingPath(Object resource) {
        if (resource.getClass().getAnnotation(Path.class) == null) {
            this.logger.error("Missing path attribute for resource " + resource);
            throw new RestResourceMissingPathException("Missing path attribute for resource " + resource);
        }
    }

    public static ServerDataBuilder builder() {
        return new ServerDataBuilder();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getPort() {
        return this.port;
    }

    public List<Object> getResources() {
        return this.resources;
    }

    public ApplicationContext getRootContext() {
        return this.rootContext;
    }

    public String getBaseUrlPattern() {
        return this.baseUrlPattern;
    }

    public Module getModule() {
        return this.module;
    }

    public static class ServerDataBuilder {
        private int port;
        private List<Object> resources;
        private ApplicationContext rootContext;
        private String baseUrlPattern;
        private Module module;

        ServerDataBuilder() {
        }

        public ServerDataBuilder port(int port) {
            this.port = port;
            return this;
        }

        public ServerDataBuilder resources(List<Object> resources) {
            this.resources = resources;
            return this;
        }

        public ServerDataBuilder rootContext(ApplicationContext rootContext) {
            this.rootContext = rootContext;
            return this;
        }

        public ServerDataBuilder baseUrlPattern(String baseUrlPattern) {
            this.baseUrlPattern = baseUrlPattern;
            return this;
        }

        public ServerDataBuilder module(Module module) {
            this.module = module;
            return this;
        }

        public ServerData build() {
            return new ServerData(this.port, this.resources, this.rootContext, this.baseUrlPattern, this.module);
        }

        public String toString() {
            return "ServerData.ServerDataBuilder(port=" + this.port + ", resources=" + this.resources + ", rootContext=" + this.rootContext + ", baseUrlPattern=" + this.baseUrlPattern + ", module=" + this.module + ")";
        }
    }
}

