/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.servers;

import com.aol.micro.server.servers.model.ServerData;
import java.beans.ConstructorProperties;
import java.util.EventListener;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContextListenerConfigurer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServerData serverData;
    private final List<ServletContextListener> listenerData;
    private final List<ServletRequestListener> listenerRequestData;

    public void addListeners(ServletContext webappContext) {
        this.serverData.getRootContext().getBeansOfType(ServletContextListener.class).values().stream().peek(this::logListener).forEach(listener -> webappContext.addListener((EventListener)listener));
        this.listenerData.forEach(it -> webappContext.addListener((EventListener)it));
        this.serverData.getRootContext().getBeansOfType(ServletRequestListener.class).values().stream().peek(this::logListener).forEach(listener -> webappContext.addListener((EventListener)listener));
        this.listenerRequestData.forEach(it -> webappContext.addListener((EventListener)it));
    }

    private void logListener(ServletContextListener listener) {
        this.logger.info("Registering servlet context listener {}", (Object)listener.getClass().getName());
    }

    private void logListener(ServletRequestListener listener) {
        this.logger.info("Registering servlet request listener {}", (Object)listener.getClass().getName());
    }

    @ConstructorProperties(value={"serverData", "listenerData", "listenerRequestData"})
    public ServletContextListenerConfigurer(ServerData serverData, List<ServletContextListener> listenerData, List<ServletRequestListener> listenerRequestData) {
        this.serverData = serverData;
        this.listenerData = listenerData;
        this.listenerRequestData = listenerRequestData;
    }
}

