/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.spring;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.micro.server.ErrorCode;
import com.aol.micro.server.Plugin;
import com.aol.micro.server.PluginLoader;
import com.aol.micro.server.config.Config;
import com.aol.micro.server.config.Microserver;
import com.aol.micro.server.spring.SpringApplicationConfigurator;
import com.aol.micro.server.spring.SpringBuilder;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringContextFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PSet<Class> classes;
    private final Config config;
    private final SpringBuilder springBuilder;

    public SpringContextFactory(Config config, Class c, Set<Class> classes) {
        Set<Class<Object>> s = new HashSet<Class>(classes);
        s.addAll((Collection<Class>)config.getClasses());
        s.add(c);
        Microserver microserver = c.getAnnotation(Microserver.class);
        HashSet<Class> immutableS = s;
        s = Optional.ofNullable(microserver).flatMap(ms -> Optional.ofNullable(ms.blacklistedClasses())).map(bl -> {
            Set blacklistedClasses = Arrays.stream(bl).collect(Collectors.toSet());
            return immutableS.stream().filter(clazz -> !blacklistedClasses.contains(clazz)).collect(Collectors.toSet());
        }).orElse(immutableS);
        this.classes = HashTreePSet.from(s);
        this.config = config;
        this.springBuilder = SequenceM.fromStream(PluginLoader.INSTANCE.plugins.get().stream()).filter(m -> m.springBuilder() != null).map(Plugin::springBuilder).findFirst().orElse(new SpringApplicationConfigurator());
    }

    public ApplicationContext createSpringContext() {
        try {
            ConfigurableApplicationContext springContext = this.springBuilder.createSpringApp(this.config, (Class[])this.classes.toArray((Object[])new Class[0]));
            return springContext;
        }
        catch (Exception e) {
            this.logger.error(ErrorCode.STARTUP_FAILED_SPRING_INITIALISATION.toString(), (Object)e.getMessage());
            ExceptionSoftener.throwSoftenedException((Throwable)e);
            return null;
        }
    }

    @ConstructorProperties(value={"classes", "config", "springBuilder"})
    public SpringContextFactory(PSet<Class> classes, Config config, SpringBuilder springBuilder) {
        this.classes = classes;
        this.config = config;
        this.springBuilder = springBuilder;
    }

    public SpringContextFactory withSpringBuilder(SpringBuilder springBuilder) {
        return this.springBuilder == springBuilder ? this : new SpringContextFactory(this.classes, this.config, springBuilder);
    }
}

