/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.module;

import com.aol.cyclops.sequence.SequenceM;
import com.aol.micro.server.Plugin;
import com.aol.micro.server.PluginLoader;
import com.aol.micro.server.auto.discovery.Rest;
import com.aol.micro.server.auto.discovery.RestResource;
import com.aol.micro.server.config.Classes;
import com.aol.micro.server.module.IncorrectJaxRsPluginsException;
import com.aol.micro.server.module.JaxRsProvider;
import com.aol.micro.server.module.WebServerProvider;
import com.aol.micro.server.servers.model.ServerData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestListener;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public interface Module {
    default public Map<String, Object> getServerProperties() {
        return new HashMap<String, Object>();
    }

    default public <T> Consumer<WebServerProvider<T>> getServerConfigManager() {
        return server -> {};
    }

    default public <T> Consumer<JaxRsProvider<T>> getResourceConfigManager() {
        return rc -> {};
    }

    default public List<String> getPackages() {
        return Arrays.asList(new String[0]);
    }

    default public Map<String, String> getPropertyOverrides() {
        return new HashMap<String, String>();
    }

    default public Set<Class> getSpringConfigurationClasses() {
        return new HashSet<Class>(Arrays.asList(Classes.CORE_CLASSES.getClasses()));
    }

    default public List<Class> getRestResourceClasses() {
        return Arrays.asList(RestResource.class);
    }

    default public List<Class> getRestAnnotationClasses() {
        return Arrays.asList(Rest.class);
    }

    default public List<String> getDefaultJaxRsPackages() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(SequenceM.fromStream(PluginLoader.INSTANCE.plugins.get().stream()).filter(module -> module.servletContextListeners() != null).flatMapCollection(Plugin::jaxRsPackages).toList());
        return list;
    }

    default public List<Class> getDefaultResources() {
        ArrayList<Class> list = new ArrayList<Class>();
        list.addAll(SequenceM.fromStream(PluginLoader.INSTANCE.plugins.get().stream()).filter(module -> module.servletContextListeners() != null).flatMapCollection(Plugin::jaxRsResources).toList());
        return list;
    }

    default public List<ServletContextListener> getListeners(ServerData data) {
        ArrayList<ContextLoaderListener> list = new ArrayList<ContextLoaderListener>();
        if (data.getRootContext() instanceof WebApplicationContext) {
            list.add(new ContextLoaderListener((WebApplicationContext)data.getRootContext()));
        }
        List<Plugin> modules = PluginLoader.INSTANCE.plugins.get();
        list.addAll(SequenceM.fromStream(modules.stream()).filter(module -> module.servletContextListeners() != null).flatMapCollection(Plugin::servletContextListeners).map(fn -> (ServletContextListener)fn.apply(data)).toList());
        return Collections.unmodifiableList(new ArrayList(list));
    }

    default public List<ServletRequestListener> getRequestListeners(ServerData data) {
        ArrayList<ServletRequestListener> list = new ArrayList<ServletRequestListener>();
        list.addAll(SequenceM.fromStream(PluginLoader.INSTANCE.plugins.get().stream()).filter(module -> module.servletRequestListeners() != null).flatMapCollection(Plugin::servletRequestListeners).map(fn -> (ServletRequestListener)fn.apply(data)).toList());
        return list;
    }

    default public Map<String, Filter> getFilters(ServerData data) {
        HashMap<String, Filter> map = new HashMap<String, Filter>();
        SequenceM.fromStream(PluginLoader.INSTANCE.plugins.get().stream()).filter(module -> module.filters() != null).map(module -> module.filters().apply(data)).forEach(pluginMap -> map.putAll((Map<String, Filter>)pluginMap));
        return map;
    }

    default public Map<String, Servlet> getServlets(ServerData data) {
        HashMap<String, Servlet> map = new HashMap<String, Servlet>();
        SequenceM.fromStream(PluginLoader.INSTANCE.plugins.get().stream()).filter(module -> module.servlets() != null).map(module -> module.servlets().apply(data)).forEach(pluginMap -> map.putAll((Map<String, Servlet>)pluginMap));
        return map;
    }

    default public String getJaxWsRsApplication() {
        List jaxRsApplications = SequenceM.fromStream(PluginLoader.INSTANCE.plugins.get().stream()).filter(module -> module.jaxWsRsApplication() != null).flatMapOptional(Plugin::jaxWsRsApplication).toList();
        if (jaxRsApplications.size() > 1) {
            throw new IncorrectJaxRsPluginsException("ERROR!  Multiple jax-rs application plugins found " + jaxRsApplications);
        }
        if (jaxRsApplications.size() == 0) {
            throw new IncorrectJaxRsPluginsException("ERROR!  No jax-rs application plugins found ");
        }
        return (String)jaxRsApplications.get(0);
    }

    default public String getProviders() {
        String additional = SequenceM.fromStream(PluginLoader.INSTANCE.plugins.get().stream()).peek(System.out::println).filter(module -> module.providers() != null).flatMapCollection(Plugin::providers).join(",");
        if (StringUtils.isEmpty((Object)additional)) {
            return "com.aol.micro.server.rest.providers";
        }
        return "com.aol.micro.server.rest.providers," + additional;
    }

    public String getContext();
}

