/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.module;

import com.aol.cyclops.trycatch.Try;
import com.aol.micro.server.module.Module;
import com.aol.micro.server.module.ModuleBean;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.pcollections.HashTreePMap;

public class Environment {
    private volatile Map<String, ModuleBean> modulePort;
    private final Properties properties;
    private volatile int nextPort = 8080;

    public Environment(Properties propertyFactory, Collection<ModuleBean> modules) {
        this.modulePort = modules.stream().collect(Collectors.toMap(key -> key.getModule().getContext(), value -> value));
        this.properties = propertyFactory;
    }

    public Environment(Properties propertyFactory) {
        this.modulePort = HashTreePMap.empty();
        this.properties = propertyFactory;
    }

    public ModuleBean getModuleBean(Module module) {
        return this.modulePort.get(module.getContext());
    }

    public void assureModule(Module module) {
        if (!this.modulePort.containsKey(module.getContext())) {
            HashMap<String, ModuleBean> builder = new HashMap<String, ModuleBean>();
            builder.putAll(this.modulePort);
            builder.put(module.getContext(), ModuleBean.builder().host(this.getHost(module)).port(this.getPort(module)).build());
            this.modulePort = HashTreePMap.from(builder);
        }
    }

    private String getHost(Module module) {
        Try.CheckedSupplier s = () -> InetAddress.getLocalHost().getHostName();
        try {
            return Optional.ofNullable(this.properties.get(module.getContext() + ".host")).orElse(s.get()).toString();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private int getPort(Module module) {
        return Integer.valueOf(Optional.ofNullable(this.properties.get(module.getContext() + ".port")).orElse(this.nextPort++).toString());
    }
}

