/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.tuple;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ParamMatcher {
    ParamMatcher() {
    }

    public <T> T create(Class<T> to, int arity, List<Object> values, Throwable t) {
        List<Class> classes = Stream.of(values).map(v -> v == null ? null : v.getClass()).collect(Collectors.toList());
        List cons = Stream.of(to.getConstructors()).filter(c -> c.getParameterCount() == arity).collect(Collectors.toList());
        for (Constructor c2 : cons) {
            if (!this.match(c2, classes)) continue;
            try {
                return c2.newInstance(this.order(values, c2).toArray());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            }
        }
        ExceptionSoftener.throwSoftenedException((Throwable)t);
        return null;
    }

    private List<Object> order(List<Object> values, Constructor c) {
        Class<?>[] order = c.getParameterTypes();
        ArrayList<Object> result = new ArrayList<Object>();
        for (Class<?> next : order) {
            result.add(this.find(next, values));
        }
        return result;
    }

    private Object find(Class next, List<Object> values) {
        return values.stream().filter(v -> v != null).filter(v -> v.getClass().isAssignableFrom(next)).findFirst().orElse(null);
    }

    boolean match(Constructor c, List<Class> values) {
        return values.stream().filter(v -> v != null).map(v -> this.matchFor((Class)v, c)).allMatch(t -> t);
    }

    private boolean matchFor(Class v, Constructor c) {
        return Stream.of(c.getParameterTypes()).anyMatch(ct -> v.isAssignableFrom((Class<?>)ct));
    }
}

