/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.tuple;

import com.aol.cyclops.lambda.tuple.PTuple1;
import com.aol.cyclops.lambda.tuple.PTuple8;
import com.aol.cyclops.lambda.tuple.PowerTuples;
import com.aol.cyclops.lambda.tuple.TupleImpl;
import com.aol.cyclops.lambda.tuple.lazymap.LazyMap1PTuple8;
import com.aol.cyclops.lambda.tuple.lazymap.LazyMap2PTuple8;
import com.aol.cyclops.lambda.tuple.memo.Memo2;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

public interface PTuple2<T1, T2>
extends PTuple1<T1> {
    default public T2 v2() {
        if (this.arity() < 2) {
            throw new ClassCastException("Attempt to upscale to " + PTuple2.class.getCanonicalName() + " from com.aol.cyclops.lambda.tuple.Tuple" + this.arity());
        }
        return (T2)this.getCachedValues().get(1);
    }

    default public T2 _2() {
        return this.v2();
    }

    default public T2 getT2() {
        return this.v2();
    }

    default public <T> PTuple2<T, T2> map1(Function<T1, T> fn) {
        if (this.arity() != 2) {
            return (PTuple2)PTuple1.super.map1(fn);
        }
        return PowerTuples.tuple(fn.apply(this.v1()), this.v2());
    }

    default public <T> PTuple2<T, T2> lazyMap1(Function<T1, T> fn) {
        if (this.arity() != 2) {
            return (PTuple2)PTuple1.super.lazyMap1(fn);
        }
        return new LazyMap1PTuple8(fn, (PTuple8)this);
    }

    default public <T> PTuple2<T1, T> lazyMap2(Function<T2, T> fn) {
        return new LazyMap2PTuple8(fn, (PTuple8)this);
    }

    default public <T> PTuple2<T1, T> map2(Function<T2, T> fn) {
        return PTuple2.of(this.v1(), fn.apply(this.v2()));
    }

    default public PTuple1<T1> tuple1() {
        return (PTuple1)this.withArity(1);
    }

    default public <NT1, NT2> PTuple2<NT1, NT2> reorder(final Function<PTuple2<T1, T2>, NT1> v1S, final Function<PTuple2<T1, T2>, NT2> v2S) {
        final PTuple2 host = this;
        return new TupleImpl(Arrays.asList(new Object[0]), 2){

            @Override
            public NT1 v1() {
                return v1S.apply(host);
            }

            @Override
            public NT2 v2() {
                return v2S.apply(host);
            }

            @Override
            public List<Object> getCachedValues() {
                return Arrays.asList(this.v1(), this.v2());
            }

            @Override
            public Iterator iterator() {
                return this.getCachedValues().iterator();
            }
        };
    }

    default public PTuple2<T2, T1> swap2() {
        return PTuple2.of(this.v2(), this.v1());
    }

    default public <R> R apply2(Function<T1, Function<T2, R>> fn) {
        return fn.apply(this.v1()).apply(this.v2());
    }

    default public <R> R call(BiFunction<T1, T2, R> fn) {
        return fn.apply(this.v1(), this.v2());
    }

    default public <R> CompletableFuture<R> callAsync(BiFunction<T1, T2, R> fn) {
        return CompletableFuture.completedFuture(this).thenApplyAsync(i -> fn.apply(i.v1(), i.v2()));
    }

    default public <R> CompletableFuture<R> applyAsync2(Function<T1, Function<T2, R>> fn) {
        return CompletableFuture.completedFuture(this.v2()).thenApplyAsync(fn.apply(this.v1()));
    }

    default public <R> CompletableFuture<R> callAsync(BiFunction<T1, T2, R> fn, Executor e) {
        return CompletableFuture.completedFuture(this).thenApplyAsync(i -> fn.apply(i.v1(), i.v2()), e);
    }

    default public <R> CompletableFuture<R> applyAsync2(Function<T1, Function<T2, R>> fn, Executor e) {
        return CompletableFuture.completedFuture(this.v2()).thenApplyAsync(fn.apply(this.v1()), e);
    }

    @Override
    default public int arity() {
        return 2;
    }

    public static TwoNumbers asTwoNumbers(PTuple2<Number, Number> tuple) {
        return new TwoNumbers(tuple);
    }

    default public PTuple2<T1, T2> memo() {
        if (this.arity() != 2) {
            return (PTuple2)PTuple1.super.memo();
        }
        return new Memo2(this);
    }

    public static <T1, T2> PTuple2<T1, T2> ofTuple(Object tuple2) {
        return new TupleImpl(tuple2, 2);
    }

    public static <T1, T2> PTuple2<T1, T2> of(T1 t1, T2 t2) {
        return new TupleImpl(Arrays.asList(t1, t2), 2);
    }

    public static class TwoNumbers {
        private final PTuple2 t2;

        public IntStream asRange() {
            return IntStream.range(((Number)this.t2.v1()).intValue(), ((Number)this.t2.v1()).intValue());
        }

        public LongStream asLongRange() {
            return LongStream.range(((Number)this.t2.v1()).longValue(), ((Number)this.t2.v1()).longValue());
        }

        @ConstructorProperties(value={"t2"})
        public TwoNumbers(PTuple2 t2) {
            this.t2 = t2;
        }
    }
}

