/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.trycatch;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.monad.AnyM;
import com.aol.cyclops.trycatch.Success;
import com.aol.cyclops.trycatch.Try;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Failure<T, X extends Throwable>
implements Try<T, X> {
    private final X error;

    public <T extends Iterable<?>> T unapply() {
        return (T)Arrays.asList(this.error);
    }

    @Override
    public AnyM<T> anyM() {
        return this.anyMSuccess();
    }

    @Override
    public AnyM<X> anyMFailure() {
        return AnyM.ofMonad((Object)this);
    }

    @Override
    public AnyM<T> anyMSuccess() {
        return AnyM.fromOptional(Optional.empty());
    }

    public static <T, X extends Throwable> Failure<T, X> of(X error) {
        return new Failure<T, X>(error);
    }

    public static <T, X extends Throwable> AnyM<X> anyMOf(X error) {
        return new Failure<T, X>(error).anyMFailure();
    }

    @Override
    public T get() {
        ExceptionSoftener.throwSoftenedException(this.error);
        return null;
    }

    @Override
    public <R> Try<R, X> map(Function<T, R> fn) {
        return this;
    }

    @Override
    public <R> Try<R, X> flatMap(Function<T, Try<R, X>> fn) {
        return this;
    }

    @Override
    public Optional<T> filter(Predicate<T> p) {
        return Optional.empty();
    }

    @Override
    public Try<T, X> recoverWithFor(Class<? extends X> t, Function<X, Success<T, X>> fn) {
        if (t.isAssignableFrom(this.error.getClass())) {
            return this.recoverWith(fn);
        }
        return this;
    }

    @Override
    public Try<T, X> recoverFor(Class<? extends X> t, Function<X, T> fn) {
        if (t.isAssignableFrom(this.error.getClass())) {
            return this.recover(fn);
        }
        return this;
    }

    @Override
    public Success<T, X> recover(Function<X, T> fn) {
        return Success.of(fn.apply(this.error));
    }

    @Override
    public Success<T, X> recoverWith(Function<X, Success<T, X>> fn) {
        return fn.apply(this.error);
    }

    @Override
    public Try<T, X> flatten() {
        return this;
    }

    @Override
    public T orElse(T value) {
        return value;
    }

    @Override
    public T orElseGet(Supplier<T> value) {
        return value.get();
    }

    @Override
    public Optional<T> toOptional() {
        return Optional.empty();
    }

    @Override
    public Stream<T> stream() {
        return Stream.of(new Object[0]);
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public boolean isFailure() {
        return true;
    }

    @Override
    public void foreach(Consumer<T> consumer) {
    }

    @Override
    public Try<T, X> onFail(Consumer<X> consumer) {
        consumer.accept(this.error);
        return this;
    }

    @Override
    public Try<T, X> onFail(Class<? extends X> t, Consumer<X> consumer) {
        if (t.isAssignableFrom(this.error.getClass())) {
            consumer.accept(this.error);
        }
        return this;
    }

    @Override
    public void throwException() {
        ExceptionSoftener.throwSoftenedException(this.error);
    }

    @Override
    public Optional<X> toFailedOptional() {
        return Optional.of(this.error);
    }

    @Override
    public Stream<X> toFailedStream() {
        return Stream.of(this.error);
    }

    @Override
    public void foreachFailed(Consumer<X> consumer) {
        consumer.accept(this.error);
    }

    @ConstructorProperties(value={"error"})
    public Failure(X error) {
        this.error = error;
    }

    public String toString() {
        return "Failure(error=" + this.error + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Failure)) {
            return false;
        }
        Failure other = (Failure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        X this$error = this.error;
        X other$error = other.error;
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Failure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        X $error = this.error;
        result = result * 59 + ($error == null ? 0 : $error.hashCode());
        return result;
    }
}

