/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.operators;

import com.aol.cyclops.sequence.streamable.Streamable;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;

public final class MultiCollectOperator<T> {
    private final Stream<T> stream;

    public List collect(Streamable<Collector> collectors) {
        Supplier<Object> supplier = () -> collectors.stream().map(c -> c.supplier().get()).collect(Collectors.toList());
        BiConsumer<Object, Object> accumulator = (acc, next) -> Seq.seq(collectors.stream().iterator()).zip(Seq.seq((Iterable)((List)acc)), (a, b) -> new Tuple2(a, b)).forEach(t -> ((Collector)t.v1()).accumulator().accept(t.v2(), next));
        BinaryOperator combiner = (t1, t2) -> {
            Iterator t1It = ((Iterable)t1).iterator();
            Iterator t2It = ((Iterable)t2).iterator();
            return collectors.stream().map(c -> c.combiner().apply(t1It.next(), t2It.next())).collect(Collectors.toList());
        };
        Function<Object, Object> finisher = t1 -> {
            Iterator t1It = ((Iterable)t1).iterator();
            return collectors.stream().map(c -> c.finisher().apply(t1It.next())).collect(Collectors.toList());
        };
        Collector<Object, Object, Object> col = Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
        return (List)this.stream.collect(col);
    }

    @ConstructorProperties(value={"stream"})
    public MultiCollectOperator(Stream<T> stream) {
        this.stream = stream;
    }

    public Stream<T> getStream() {
        return this.stream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiCollectOperator)) {
            return false;
        }
        MultiCollectOperator other = (MultiCollectOperator)o;
        Stream<T> this$stream = this.getStream();
        Stream<T> other$stream = other.getStream();
        return !(this$stream == null ? other$stream != null : !this$stream.equals(other$stream));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Stream<T> $stream = this.getStream();
        result = result * 59 + ($stream == null ? 0 : $stream.hashCode());
        return result;
    }

    public String toString() {
        return "MultiCollectOperator(stream=" + this.getStream() + ")";
    }
}

