/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.operators;

import com.aol.cyclops.streams.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public final class LimitWhileTimeOperator<U> {
    private final Stream<U> stream;

    public Stream<U> limitWhile(long time, TimeUnit unit) {
        final Iterator it = this.stream.iterator();
        final long start = System.nanoTime();
        final long allowed = unit.toNanos(time);
        return StreamUtils.stream(new Iterator<U>(){
            U next;
            boolean stillGoing = true;

            @Override
            public boolean hasNext() {
                boolean bl = this.stillGoing = System.nanoTime() - start < allowed;
                if (!this.stillGoing) {
                    return false;
                }
                return it.hasNext();
            }

            @Override
            public U next() {
                if (!this.stillGoing) {
                    throw new NoSuchElementException();
                }
                Object val = it.next();
                this.stillGoing = System.nanoTime() - start < allowed;
                return val;
            }
        });
    }

    @ConstructorProperties(value={"stream"})
    public LimitWhileTimeOperator(Stream<U> stream) {
        this.stream = stream;
    }

    public Stream<U> getStream() {
        return this.stream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LimitWhileTimeOperator)) {
            return false;
        }
        LimitWhileTimeOperator other = (LimitWhileTimeOperator)o;
        Stream<U> this$stream = this.getStream();
        Stream<U> other$stream = other.getStream();
        return !(this$stream == null ? other$stream != null : !this$stream.equals(other$stream));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Stream<U> $stream = this.getStream();
        result = result * 59 + ($stream == null ? 0 : $stream.hashCode());
        return result;
    }

    public String toString() {
        return "LimitWhileTimeOperator(stream=" + this.getStream() + ")";
    }
}

