/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.operators;

import com.aol.cyclops.streams.StreamUtils;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.stream.Stream;

public class LimitLastOperator<T> {
    Stream<T> stream;
    ArrayDeque<T> buffer;
    int limit;

    public LimitLastOperator(Stream<T> stream, int limit) {
        this.buffer = new ArrayDeque(limit);
        this.stream = stream;
        this.limit = limit;
    }

    public Stream<T> limitLast() {
        final Iterator it = this.stream.iterator();
        return StreamUtils.stream(new Iterator<T>(){

            @Override
            public boolean hasNext() {
                while (it.hasNext()) {
                    LimitLastOperator.this.buffer.add(it.next());
                    if (LimitLastOperator.this.buffer.size() <= LimitLastOperator.this.limit) continue;
                    LimitLastOperator.this.buffer.pop();
                }
                return LimitLastOperator.this.buffer.size() > 0;
            }

            @Override
            public T next() {
                return LimitLastOperator.this.buffer.pop();
            }
        });
    }
}

