/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.future;

import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.sequence.future.FutureOperations;
import com.aol.cyclops.sequence.reactivestreams.ReactiveTask;
import com.aol.cyclops.streams.FutureStreamUtils;
import com.aol.cyclops.streams.future.DoubleOperatorsMixin;
import com.aol.cyclops.streams.future.IntOperatorsMixin;
import com.aol.cyclops.streams.future.LongOperatorsMixin;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;

public class FutureOperationsImpl<T>
implements DoubleOperatorsMixin<T>,
IntOperatorsMixin<T>,
LongOperatorsMixin<T>,
FutureOperations<T> {
    private final Executor exec;
    private final SequenceM<T> stream;

    @Override
    public CompletableFuture<List<T>> toList() {
        return CompletableFuture.supplyAsync(() -> this.stream.toList(), this.exec);
    }

    @Override
    public CompletableFuture<T> lastValue() {
        return CompletableFuture.supplyAsync(() -> {
            List<T> l = this.stream.toList();
            return l.get(l.size() - 1);
        }, this.exec);
    }

    @Override
    public CompletableFuture<T> single() {
        return CompletableFuture.supplyAsync(() -> {
            List<T> l = this.stream.toList();
            if (l.size() == 1) {
                return l.get(l.size() - 1);
            }
            throw new UnsupportedOperationException("single only works for Streams with a single value");
        }, this.exec);
    }

    @Override
    public CompletableFuture<Set<T>> toSet() {
        return CompletableFuture.supplyAsync(() -> this.stream.toSet(), this.exec);
    }

    @Override
    public <U extends Comparable<? super U>> CompletableFuture<Optional<T>> minBy(Function<? super T, ? extends U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.minBy(function));
    }

    @Override
    public <U extends Comparable<? super U>> CompletableFuture<Optional<T>> maxBy(Function<? super T, ? extends U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.maxBy(function));
    }

    @Override
    public <R, A> CompletableFuture<R> collect(Collector<? super T, A, R> collector) {
        return CompletableFuture.supplyAsync(() -> this.stream.collect(collector));
    }

    @Override
    public <C extends Collection<T>> CompletableFuture<C> toCollection(Supplier<C> collectionFactory) {
        return CompletableFuture.supplyAsync(() -> this.stream.toCollection(collectionFactory), this.exec);
    }

    @Override
    public <A> CompletableFuture<A[]> toArray(IntFunction<A[]> generator) {
        return CompletableFuture.supplyAsync(() -> this.stream.toArray(generator), this.exec);
    }

    @Override
    public CompletableFuture<Object[]> toArray() {
        return CompletableFuture.supplyAsync(() -> this.stream.toArray(), this.exec);
    }

    @Override
    public <K> CompletableFuture<Map<K, List<T>>> groupBy(Function<? super T, ? extends K> classifier) {
        return CompletableFuture.supplyAsync(() -> this.stream.groupBy(classifier), this.exec);
    }

    @Override
    public <K, A, D> CompletableFuture<Map<K, D>> groupBy(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return CompletableFuture.supplyAsync(() -> this.stream.groupBy(classifier, downstream), this.exec);
    }

    @Override
    public <K, D, A, M extends Map<K, D>> CompletableFuture<M> groupBy(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        return CompletableFuture.supplyAsync(() -> this.stream.groupBy(classifier, mapFactory, downstream), this.exec);
    }

    @Override
    public <U> CompletableFuture<U> foldLeft(U seed, BiFunction<U, ? super T, U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.foldLeft(seed, function), this.exec);
    }

    @Override
    public <U> CompletableFuture<U> foldRight(U seed, BiFunction<? super T, U, U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.foldRight(seed, function), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> min(Comparator<? super T> comparator) {
        return CompletableFuture.supplyAsync(() -> this.stream.min(comparator), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> max(Comparator<? super T> comparator) {
        return CompletableFuture.supplyAsync(() -> this.stream.max(comparator), this.exec);
    }

    @Override
    public <R> CompletableFuture<R> collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return CompletableFuture.supplyAsync(() -> this.stream.collect(supplier, accumulator, combiner), this.exec);
    }

    @Override
    public <U> CompletableFuture<U> reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return CompletableFuture.supplyAsync(() -> this.stream.reduce(identity, accumulator, combiner), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> reduce(BinaryOperator<T> accumulator) {
        return CompletableFuture.supplyAsync(() -> this.stream.reduce(accumulator));
    }

    @Override
    public CompletableFuture<T> reduce(T identity, BinaryOperator<T> accumulator) {
        return CompletableFuture.supplyAsync(() -> this.stream.reduce(identity, accumulator), this.exec);
    }

    @Override
    public CompletableFuture<Long> count() {
        return CompletableFuture.supplyAsync(() -> this.stream.count(), this.exec);
    }

    @Override
    public CompletableFuture<String> join(CharSequence sep) {
        return CompletableFuture.supplyAsync(() -> this.stream.join(sep), this.exec);
    }

    @Override
    public CompletableFuture<String> join() {
        return CompletableFuture.supplyAsync(() -> this.stream.join(), this.exec);
    }

    @Override
    public CompletableFuture<String> join(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return CompletableFuture.supplyAsync(() -> this.stream.join(delimiter, prefix, suffix), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> findAny() {
        return CompletableFuture.supplyAsync(() -> this.stream.findAny(), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> findFirst() {
        return CompletableFuture.supplyAsync(() -> this.stream.findFirst(), this.exec);
    }

    @Override
    public CompletableFuture<T> firstValue() {
        return CompletableFuture.supplyAsync(() -> this.stream.firstValue(), this.exec);
    }

    @Override
    public CompletableFuture<Boolean> allMatch(Predicate<? super T> predicate) {
        return CompletableFuture.supplyAsync(() -> this.stream.allMatch(predicate), this.exec);
    }

    @Override
    public CompletableFuture<Boolean> anyMatch(Predicate<? super T> predicate) {
        return CompletableFuture.supplyAsync(() -> this.stream.anyMatch(predicate), this.exec);
    }

    @Override
    public CompletableFuture<Boolean> noneMatch(Predicate<? super T> predicate) {
        return CompletableFuture.supplyAsync(() -> this.stream.noneMatch(predicate), this.exec);
    }

    @Override
    public void forEach(Consumer<T> c) {
        CompletableFuture.runAsync(() -> this.stream.forEach(c), this.exec);
    }

    @Override
    public <X extends Throwable> ReactiveTask forEachX(long numberOfElements, Consumer<? super T> consumer) {
        return new ReactiveTask(this.exec, FutureStreamUtils.forEachX(this.stream, numberOfElements, consumer).map2(r -> CompletableFuture.runAsync(r, this.exec)));
    }

    @Override
    public <X extends Throwable> ReactiveTask forEachXWithError(long numberOfElements, Consumer<? super T> consumer, Consumer<? super Throwable> consumerError) {
        return new ReactiveTask(this.exec, FutureStreamUtils.forEachXWithError(this.stream, numberOfElements, consumer, consumerError).map2(r -> CompletableFuture.runAsync(r, this.exec)));
    }

    @Override
    public <X extends Throwable> ReactiveTask forEachXEvents(long numberOfElements, Consumer<? super T> consumer, Consumer<? super Throwable> consumerError, Runnable onComplete) {
        return new ReactiveTask(this.exec, FutureStreamUtils.forEachXEvents(this.stream, numberOfElements, consumer, consumerError, onComplete).map2(r -> CompletableFuture.runAsync(r, this.exec)));
    }

    @Override
    public <X extends Throwable> ReactiveTask forEachWithError(Consumer<? super T> consumerElement, Consumer<? super Throwable> consumerError) {
        return new ReactiveTask(this.exec, FutureStreamUtils.forEachWithError(this.stream, consumerElement, consumerError).map2(r -> CompletableFuture.runAsync(r, this.exec)));
    }

    @Override
    public <X extends Throwable> ReactiveTask forEachEvent(Consumer<? super T> consumerElement, Consumer<? super Throwable> consumerError, Runnable onComplete) {
        return new ReactiveTask(this.exec, FutureStreamUtils.forEachEvent(this.stream, consumerElement, consumerError, onComplete).map2(r -> CompletableFuture.runAsync(r, this.exec)));
    }

    @Override
    public CompletableFuture<T> single(Predicate<T> predicate) {
        return CompletableFuture.supplyAsync(() -> this.stream.filter((Predicate)predicate).single(), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> singleOptional() {
        return CompletableFuture.supplyAsync(() -> this.stream.singleOptional(), this.exec);
    }

    @Override
    public CompletableFuture<Long> countDistinct() {
        return CompletableFuture.supplyAsync(() -> this.stream.countDistinct(), this.exec);
    }

    @Override
    public <U> CompletableFuture<Long> countDistinctBy(Function<? super T, ? extends U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.countDistinctBy(function), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> mode() {
        return CompletableFuture.supplyAsync(() -> this.stream.mode(), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> sum() {
        return CompletableFuture.supplyAsync(() -> this.stream.sum(), this.exec);
    }

    @Override
    public <U> CompletableFuture<Optional<U>> sum(Function<? super T, ? extends U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.sum(function), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> avg() {
        return CompletableFuture.supplyAsync(() -> this.stream.avg(), this.exec);
    }

    @Override
    public <U> CompletableFuture<Optional<U>> avg(Function<? super T, ? extends U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.avg(function), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> min() {
        return CompletableFuture.supplyAsync(() -> this.stream.min(), this.exec);
    }

    @Override
    public <U extends Comparable<? super U>> CompletableFuture<Optional<U>> min(Function<? super T, ? extends U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.min(function), this.exec);
    }

    @Override
    public <U> CompletableFuture<Optional<U>> min(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return CompletableFuture.supplyAsync(() -> this.stream.min(function, comparator), this.exec);
    }

    @Override
    public <U> CompletableFuture<Optional<T>> minBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return CompletableFuture.supplyAsync(() -> this.stream.minBy(function, comparator), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> max() {
        return CompletableFuture.supplyAsync(() -> this.stream.max(), this.exec);
    }

    @Override
    public <U extends Comparable<? super U>> CompletableFuture<Optional<U>> max(Function<? super T, ? extends U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.max(function), this.exec);
    }

    @Override
    public <U> CompletableFuture<Optional<U>> max(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return CompletableFuture.supplyAsync(() -> this.stream.max(function, comparator), this.exec);
    }

    @Override
    public <U> CompletableFuture<Optional<T>> maxBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return CompletableFuture.supplyAsync(() -> this.stream.maxBy(function, comparator), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> median() {
        return CompletableFuture.supplyAsync(() -> this.stream.median(), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> median(Comparator<? super T> comparator) {
        return CompletableFuture.supplyAsync(() -> this.stream.median(comparator), this.exec);
    }

    @Override
    public <U extends Comparable<? super U>> CompletableFuture<Optional<T>> medianBy(Function<? super T, ? extends U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.medianBy(function), this.exec);
    }

    @Override
    public <U> CompletableFuture<Optional<T>> medianBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return CompletableFuture.supplyAsync(() -> this.stream.medianBy(function, comparator), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> percentile(double percentile) {
        return CompletableFuture.supplyAsync(() -> this.stream.percentile(percentile), this.exec);
    }

    @Override
    public CompletableFuture<Optional<T>> percentile(double percentile, Comparator<? super T> comparator) {
        return CompletableFuture.supplyAsync(() -> this.stream.percentile(percentile, comparator), this.exec);
    }

    @Override
    public <U extends Comparable<? super U>> CompletableFuture<Optional<T>> percentileBy(double percentile, Function<? super T, ? extends U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.percentileBy(percentile, function), this.exec);
    }

    @Override
    public <U> CompletableFuture<Optional<T>> percentileBy(double percentile, Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return CompletableFuture.supplyAsync(() -> this.stream.percentileBy(percentile, function, comparator), this.exec);
    }

    @Override
    public <L extends List<T>> CompletableFuture<L> toList(Supplier<L> factory) {
        return CompletableFuture.supplyAsync(() -> this.stream.toList(factory), this.exec);
    }

    @Override
    public <S extends Set<T>> CompletableFuture<S> toSet(Supplier<S> factory) {
        return CompletableFuture.supplyAsync(() -> this.stream.toSet(factory), this.exec);
    }

    @Override
    public <K, V> CompletableFuture<Map<K, V>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return CompletableFuture.supplyAsync(() -> this.stream.toMap(keyMapper, valueMapper), this.exec);
    }

    @Override
    public CompletableFuture<Double> sumDouble(ToDoubleFunction<? super T> fn) {
        return DoubleOperatorsMixin.super.sumDouble(fn);
    }

    @Override
    public CompletableFuture<Long> sumLong(ToLongFunction<? super T> fn) {
        return LongOperatorsMixin.super.sumLong(fn);
    }

    @Override
    public CompletableFuture<OptionalLong> maxLong(ToLongFunction<? super T> fn) {
        return LongOperatorsMixin.super.maxLong(fn);
    }

    @Override
    public CompletableFuture<OptionalLong> minLong(ToLongFunction<? super T> fn) {
        return LongOperatorsMixin.super.minLong(fn);
    }

    @Override
    public CompletableFuture<OptionalDouble> averageLong(ToLongFunction<? super T> fn) {
        return LongOperatorsMixin.super.averageLong(fn);
    }

    @Override
    public CompletableFuture<LongSummaryStatistics> summaryStatisticsLong(ToLongFunction<? super T> fn) {
        return LongOperatorsMixin.super.summaryStatisticsLong(fn);
    }

    @Override
    public CompletableFuture<Integer> sumInt(ToIntFunction<? super T> fn) {
        return IntOperatorsMixin.super.sumInt(fn);
    }

    @Override
    public CompletableFuture<OptionalInt> maxInt(ToIntFunction<? super T> fn) {
        return IntOperatorsMixin.super.maxInt(fn);
    }

    @Override
    public CompletableFuture<OptionalInt> minInt(ToIntFunction<? super T> fn) {
        return IntOperatorsMixin.super.minInt(fn);
    }

    @Override
    public CompletableFuture<OptionalDouble> averageInt(ToIntFunction<? super T> fn) {
        return IntOperatorsMixin.super.averageInt(fn);
    }

    @Override
    public CompletableFuture<IntSummaryStatistics> summaryStatisticsInt(ToIntFunction<? super T> fn) {
        return IntOperatorsMixin.super.summaryStatisticsInt(fn);
    }

    @Override
    public CompletableFuture<OptionalDouble> maxDouble(ToDoubleFunction<? super T> fn) {
        return DoubleOperatorsMixin.super.maxDouble(fn);
    }

    @Override
    public CompletableFuture<OptionalDouble> minDouble(ToDoubleFunction<? super T> fn) {
        return DoubleOperatorsMixin.super.minDouble(fn);
    }

    @Override
    public CompletableFuture<OptionalDouble> averageDouble(ToDoubleFunction<? super T> fn) {
        return DoubleOperatorsMixin.super.averageDouble(fn);
    }

    @Override
    public CompletableFuture<DoubleSummaryStatistics> summaryStatisticsDouble(ToDoubleFunction<? super T> fn) {
        return DoubleOperatorsMixin.super.summaryStatisticsDouble(fn);
    }

    @ConstructorProperties(value={"exec", "stream"})
    public FutureOperationsImpl(Executor exec, SequenceM<T> stream) {
        this.exec = exec;
        this.stream = stream;
    }

    @Override
    public Executor getExec() {
        return this.exec;
    }

    @Override
    public SequenceM<T> getStream() {
        return this.stream;
    }
}

