/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.sequence.streamable;

import com.aol.cyclops.monad.AnyM;
import com.aol.cyclops.sequence.HotStream;
import com.aol.cyclops.sequence.Monoid;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.sequence.SequenceMCollectable;
import com.aol.cyclops.sequence.future.FutureOperations;
import com.aol.cyclops.sequence.streamable.AsStreamable;
import com.aol.cyclops.sequence.streamable.ToStream;
import java.io.BufferedReader;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.jooq.lambda.Collectable;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;

public interface Streamable<T>
extends ToStream<T>,
SequenceMCollectable<T> {
    @Override
    default public Collectable<T> collectable() {
        return Seq.seq(this.stream());
    }

    public static <T> Streamable<T> fromStream(Stream<T> stream) {
        return AsStreamable.fromStream(stream);
    }

    public static <T> Streamable<T> fromIterable(Iterable<T> iterable) {
        return AsStreamable.fromIterable(iterable);
    }

    public static <T> Streamable<T> of(final T ... values) {
        return new Streamable<T>(){

            @Override
            public Stream<T> stream() {
                return Stream.of(values);
            }

            @Override
            public Object getStreamable() {
                return values;
            }
        };
    }

    public static <T> Streamable<T> empty() {
        return Streamable.of(new Object[0]);
    }

    default public Streamable<T> tail() {
        return Streamable.fromStream(this.sequenceM().headAndTail().tail());
    }

    default public T head() {
        return this.sequenceM().headAndTail().head();
    }

    default public Streamable<T> appendAll(Streamable<T> t) {
        return Streamable.fromStream(this.sequenceM().appendStream(t.sequenceM()));
    }

    default public Streamable<T> remove(T t) {
        return Streamable.fromStream(this.sequenceM().remove((Object)t));
    }

    default public Streamable<T> prepend(T t) {
        return Streamable.fromStream(this.sequenceM().prepend(t));
    }

    default public Streamable<T> distinct() {
        return Streamable.fromStream(this.sequenceM().distinct());
    }

    default public <U> U foldLeft(U identity, BiFunction<U, ? super T, U> function) {
        return (U)this.sequenceM().foldLeft(identity, function);
    }

    default public <U> U foldRight(U seed, BiFunction<? super T, U, U> function) {
        return (U)this.sequenceM().foldRight(seed, function);
    }

    default public <R> Streamable<R> map(Function<? super T, ? extends R> fn) {
        return Streamable.fromStream(this.sequenceM().map((Function)fn));
    }

    default public Streamable<T> peek(Consumer<? super T> fn) {
        return Streamable.fromStream(this.sequenceM().peek((Consumer)fn));
    }

    default public Streamable<T> filter(Predicate<? super T> fn) {
        return Streamable.fromStream(this.sequenceM().filter((Predicate)fn));
    }

    default public <R> Streamable<R> flatMap(Function<? super T, Streamable<? extends R>> fn) {
        return Streamable.fromStream(this.sequenceM().flatMap((T i) -> ((Streamable)fn.apply(i)).sequenceM()));
    }

    @Override
    default public long count() {
        return this.sequenceM().count();
    }

    default public void forEachOrdered(Consumer<? super T> action) {
        this.sequenceM().forEachOrdered(action);
    }

    default public Object[] toArray() {
        return this.sequenceM().toArray();
    }

    default public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.sequenceM().toArray(generator);
    }

    @Override
    default public List<T> toList() {
        if (this.getStreamable() instanceof List) {
            return (List)this.getStreamable();
        }
        return this.sequenceM().toList();
    }

    default public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.sequenceM().collect(supplier, accumulator, combiner);
    }

    @Override
    default public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.sequenceM().collect(collector);
    }

    @Override
    default public <C extends Collection<T>> C toCollection(Supplier<C> collectionFactory) {
        return this.sequenceM().toCollection(collectionFactory);
    }

    default public Streamable<Streamable<T>> permutations() {
        if (this.isEmpty()) {
            return Streamable.empty();
        }
        Streamable<T> tail = this.tail();
        if (tail.isEmpty()) {
            return Streamable.of(this);
        }
        Streamable<T> zero = Streamable.empty();
        return this.distinct().foldLeft(zero, (U xs, ? super T x) -> {
            Function<Streamable, Streamable> prepend = l -> l.prepend((T)x);
            return xs.appendAll(this.remove(x).permutations().map(prepend));
        });
    }

    default public Streamable<T> subStream(int start, int end) {
        return Streamable.fromStream(this.sequenceM().subStream(start, end));
    }

    default public T elementAt(int index) {
        return (T)this.sequenceM().elementAt((long)((long)index)).v1;
    }

    default public int size() {
        return this.sequenceM().size();
    }

    default public Streamable<Streamable<T>> combinations(int size) {
        if (size == 0) {
            return Streamable.of(Streamable.empty());
        }
        return Streamable.fromStream(IntStream.range(0, this.size()).boxed().flatMap((? super T i) -> this.subStream(i + 1, this.size()).combinations(size - 1).map(t -> t.prepend(this.elementAt((int)i))).sequenceM()));
    }

    default public Streamable<Streamable<T>> combinations() {
        return Streamable.range(0, this.size() + 1).map(this::combinations).flatMap(s -> s);
    }

    default public <T1> Streamable<T1> flatten() {
        return Streamable.fromStream(this.sequenceM().flatten());
    }

    default public Optional<List<T>> toOptional() {
        return this.sequenceM().toOptional();
    }

    default public CompletableFuture<List<T>> toCompletableFuture() {
        return this.sequenceM().toCompletableFuture();
    }

    default public Streamable<T> cycle(int times) {
        return Streamable.fromStream(this.sequenceM().cycle(times));
    }

    default public Streamable<T> cycle() {
        return Streamable.fromStream(this.sequenceM().cycle());
    }

    default public Tuple2<Streamable<T>, Streamable<T>> duplicate() {
        return Tuple.tuple((Object)this, (Object)this);
    }

    default public Tuple3<Streamable<T>, Streamable<T>, Streamable<T>> triplicate() {
        return Tuple.tuple((Object)this, (Object)this, (Object)this);
    }

    default public Tuple4<Streamable<T>, Streamable<T>, Streamable<T>, Streamable<T>> quadruplicate() {
        return Tuple.tuple((Object)this, (Object)this, (Object)this, (Object)this);
    }

    default public Tuple2<Streamable<T>, Streamable<T>> splitAt(int where) {
        return this.sequenceM().splitAt(where).map1(s -> Streamable.fromStream(s)).map2(s -> Streamable.fromStream(s));
    }

    default public Tuple2<Optional<T>, Streamable<T>> splitAtHead() {
        return this.sequenceM().splitAtHead().map2(s -> Streamable.fromStream(s));
    }

    default public Tuple2<Streamable<T>, Streamable<T>> splitBy(Predicate<T> splitter) {
        return this.sequenceM().splitBy(splitter).map1(s -> Streamable.fromStream(s)).map2(s -> Streamable.fromStream(s));
    }

    default public Tuple2<Streamable<T>, Streamable<T>> partition(Predicate<T> splitter) {
        return this.sequenceM().partitionSequence(splitter).map1(s -> Streamable.fromStream(s)).map2(s -> Streamable.fromStream(s));
    }

    default public Streamable<T> cycle(Monoid<T> m, int times) {
        return Streamable.fromStream(this.sequenceM().cycle(m, times));
    }

    default public <R> Streamable<R> cycle(Class<R> monadC, int times) {
        return Streamable.fromStream(this.sequenceM().cycle(monadC, times));
    }

    default public Streamable<T> cycleWhile(Predicate<? super T> predicate) {
        return Streamable.fromStream(this.sequenceM().cycleWhile(predicate));
    }

    default public Streamable<T> cycleUntil(Predicate<? super T> predicate) {
        return Streamable.fromStream(this.sequenceM().cycleUntil(predicate));
    }

    default public <U> Streamable<Tuple2<T, U>> zip(Streamable<U> other) {
        return Streamable.fromStream(this.sequenceM().zip(other.sequenceM()));
    }

    default public <U, R> Streamable<R> zip(Streamable<U> other, BiFunction<T, U, R> zipper) {
        return Streamable.fromStream(this.sequenceM().zip(other.sequenceM(), zipper));
    }

    default public <S, U> Streamable<Tuple3<T, S, U>> zip3(Streamable<? extends S> second, Streamable<? extends U> third) {
        return Streamable.fromStream(this.sequenceM().zip3(second.sequenceM(), third.sequenceM()));
    }

    default public <T2, T3, T4> Streamable<Tuple4<T, T2, T3, T4>> zip4(Streamable<T2> second, Streamable<T3> third, Streamable<T4> fourth) {
        return Streamable.fromStream(this.sequenceM().zip4(second.sequenceM(), third.sequenceM(), fourth.sequenceM()));
    }

    default public Streamable<Tuple2<T, Long>> zipWithIndex() {
        return Streamable.fromStream(this.sequenceM().zipWithIndex());
    }

    default public <S, R> Streamable<R> zipStreamable(Streamable<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return Streamable.fromStream(this.sequenceM().zipSequence(second.sequenceM(), zipper));
    }

    default public <S, R> Streamable<R> zipAnyM(AnyM<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return Streamable.fromStream(this.sequenceM().zipAnyM(second, zipper));
    }

    default public <S, R> Streamable<R> zipStream(BaseStream<? extends S, ? extends BaseStream<? extends S, ?>> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return Streamable.fromStream(this.sequenceM().zipStream(second, zipper));
    }

    default public Streamable<List<T>> sliding(int windowSize) {
        return Streamable.fromStream(this.sequenceM().sliding(windowSize));
    }

    default public Streamable<List<T>> sliding(int windowSize, int increment) {
        return Streamable.fromStream(this.sequenceM().sliding(windowSize, increment));
    }

    default public Streamable<List<T>> grouped(int groupSize) {
        return Streamable.fromStream(this.sequenceM().grouped(groupSize));
    }

    default public <K> Map<K, List<T>> groupBy(Function<? super T, ? extends K> classifier) {
        return this.sequenceM().groupBy(classifier);
    }

    default public Streamable<T> scanLeft(Monoid<T> monoid) {
        return Streamable.fromStream(this.sequenceM().scanLeft(monoid));
    }

    default public <U> Streamable<U> scanLeft(U identity, BiFunction<U, ? super T, U> function) {
        return Streamable.fromStream(this.sequenceM().scanLeft((Object)identity, (BiFunction)function));
    }

    default public Streamable<T> scanRight(Monoid<T> monoid) {
        return Streamable.fromStream(this.sequenceM().scanRight(monoid));
    }

    default public <U> Streamable<U> scanRight(U identity, BiFunction<? super T, U, U> combiner) {
        return Streamable.fromStream(this.sequenceM().scanRight((Object)identity, (BiFunction)combiner));
    }

    default public Streamable<T> sorted() {
        return Streamable.fromStream(this.sequenceM().sorted());
    }

    default public Streamable<T> sorted(Comparator<? super T> c) {
        return Streamable.fromStream(this.sequenceM().sorted((Comparator)c));
    }

    default public Streamable<T> skip(long num) {
        return Streamable.fromStream(this.sequenceM().skip(num));
    }

    default public Streamable<T> skipWhile(Predicate<? super T> p) {
        return Streamable.fromStream(this.sequenceM().skipWhile((Predicate)p));
    }

    default public Streamable<T> skipUntil(Predicate<? super T> p) {
        return Streamable.fromStream(this.sequenceM().skipUntil((Predicate)p));
    }

    default public Streamable<T> limit(long num) {
        return Streamable.fromStream(this.sequenceM().limit(num));
    }

    default public Streamable<T> limitWhile(Predicate<? super T> p) {
        return Streamable.fromStream(this.sequenceM().limitWhile((Predicate)p));
    }

    default public Streamable<T> limitUntil(Predicate<? super T> p) {
        return Streamable.fromStream(this.sequenceM().limitUntil((Predicate)p));
    }

    @Override
    default public boolean allMatch(Predicate<? super T> c) {
        return this.sequenceM().allMatch(c);
    }

    @Override
    default public boolean anyMatch(Predicate<? super T> c) {
        return this.sequenceM().anyMatch(c);
    }

    default public boolean xMatch(int num, Predicate<? super T> c) {
        return this.sequenceM().xMatch(num, c);
    }

    @Override
    default public boolean noneMatch(Predicate<? super T> c) {
        return this.sequenceM().noneMatch(c);
    }

    default public String join() {
        return this.sequenceM().join();
    }

    default public String join(String sep) {
        return this.sequenceM().join(sep);
    }

    default public String join(String sep, String start, String end) {
        return this.sequenceM().join(sep, start, end);
    }

    @Override
    default public <C extends Comparable<? super C>> Optional<T> minBy(Function<? super T, ? extends C> f) {
        return this.sequenceM().minBy(f);
    }

    @Override
    default public Optional<T> min(Comparator<? super T> comparator) {
        return this.sequenceM().min(comparator);
    }

    @Override
    default public <C extends Comparable<? super C>> Optional<T> maxBy(Function<? super T, ? extends C> f) {
        return this.sequenceM().maxBy(f);
    }

    @Override
    default public Optional<T> max(Comparator<? super T> comparator) {
        return this.sequenceM().max(comparator);
    }

    default public Optional<T> findFirst() {
        return this.sequenceM().findFirst();
    }

    default public Optional<T> findAny() {
        return this.sequenceM().findAny();
    }

    default public <R> R mapReduce(Monoid<R> reducer) {
        return this.sequenceM().mapReduce(reducer);
    }

    default public <R> R mapReduce(Function<? super T, ? extends R> mapper, Monoid<R> reducer) {
        return this.sequenceM().mapReduce(mapper, reducer);
    }

    default public List collectStream(Stream<Collector> collectors) {
        return this.sequenceM().collectStream(collectors);
    }

    default public <R> List<R> collectIterable(Iterable<Collector> collectors) {
        return this.sequenceM().collectIterable(collectors);
    }

    default public T reduce(Monoid<T> reducer) {
        return this.sequenceM().reduce(reducer);
    }

    default public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.sequenceM().reduce(accumulator);
    }

    default public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.sequenceM().reduce(identity, accumulator);
    }

    default public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.sequenceM().reduce(identity, accumulator, combiner);
    }

    default public List<T> reduce(Stream<Monoid<T>> reducers) {
        return this.sequenceM().reduce(reducers);
    }

    default public List<T> reduce(Iterable<Monoid<T>> reducers) {
        return this.sequenceM().reduce(reducers);
    }

    default public T foldLeft(Monoid<T> reducer) {
        return this.sequenceM().foldLeft(reducer);
    }

    default public T foldLeft(T identity, BinaryOperator<T> accumulator) {
        return this.sequenceM().foldLeft(identity, accumulator);
    }

    default public <T> T foldLeftMapToType(Monoid<T> reducer) {
        return this.sequenceM().foldLeftMapToType(reducer);
    }

    default public T foldRight(Monoid<T> reducer) {
        return this.sequenceM().foldRight(reducer);
    }

    default public T foldRight(T identity, BinaryOperator<T> accumulator) {
        return this.sequenceM().foldRight(identity, accumulator);
    }

    default public <T> T foldRightMapToType(Monoid<T> reducer) {
        return this.sequenceM().foldRightMapToType(reducer);
    }

    @Override
    default public Set<T> toSet() {
        return this.sequenceM().toSet();
    }

    default public boolean startsWith(Iterable<T> iterable) {
        return this.sequenceM().startsWith(iterable);
    }

    default public boolean startsWith(Iterator<T> iterator) {
        return this.sequenceM().startsWith(iterator);
    }

    default public AnyM<T> anyM() {
        return AnyM.fromStreamable(this);
    }

    default public <R> Streamable<R> flatMapAnyM(Function<? super T, AnyM<? extends R>> fn) {
        return Streamable.fromStream(this.sequenceM().flatMapAnyM(fn));
    }

    default public <R> Streamable<R> flatMapCollection(Function<? super T, Collection<? extends R>> fn) {
        return Streamable.fromStream(this.sequenceM().flatMapCollection(fn));
    }

    default public <R> Streamable<R> flatMapStream(Function<? super T, BaseStream<? extends R, ?>> fn) {
        return Streamable.fromStream(this.sequenceM().flatMapStream(fn));
    }

    default public <R> Streamable<R> flatMapOptional(Function<? super T, Optional<? extends R>> fn) {
        return Streamable.fromStream(this.sequenceM().flatMapOptional(fn));
    }

    default public <R> Streamable<R> flatMapCompletableFuture(Function<? super T, CompletableFuture<? extends R>> fn) {
        return Streamable.fromStream(this.sequenceM().flatMapCompletableFuture(fn));
    }

    default public Streamable<Character> flatMapCharSequence(Function<? super T, CharSequence> fn) {
        return Streamable.fromStream(this.sequenceM().flatMapCharSequence(fn));
    }

    default public Streamable<String> flatMapFile(Function<? super T, File> fn) {
        return Streamable.fromStream(this.sequenceM().flatMapFile(fn));
    }

    default public Streamable<String> flatMapURL(Function<? super T, URL> fn) {
        return Streamable.fromStream(this.sequenceM().flatMapURL(fn));
    }

    default public Streamable<String> flatMapBufferedReader(Function<? super T, BufferedReader> fn) {
        return Streamable.fromStream(this.sequenceM().flatMapBufferedReader(fn));
    }

    default public Streamable<T> intersperse(T value) {
        return Streamable.fromStream(this.sequenceM().intersperse((Object)value));
    }

    default public <U> Streamable<U> ofType(Class<U> type) {
        return Streamable.fromStream(this.sequenceM().ofType((Class)type));
    }

    default public <U> Streamable<U> cast(Class<U> type) {
        return Streamable.fromStream(this.sequenceM().cast((Class)type));
    }

    default public Collection<T> toLazyCollection() {
        return this.sequenceM().toLazyCollection();
    }

    default public Collection<T> toConcurrentLazyCollection() {
        return this.sequenceM().toConcurrentLazyCollection();
    }

    default public Streamable<T> reverse() {
        return Streamable.fromStream(this.sequenceM().reverse());
    }

    default public Streamable<T> shuffle() {
        return Streamable.fromStream(this.sequenceM().shuffle());
    }

    default public Streamable<T> appendStreamable(Streamable<T> stream) {
        return Streamable.fromStream(this.sequenceM().appendStream(stream.sequenceM()));
    }

    default public Streamable<T> prependStreamable(Streamable<T> stream) {
        return Streamable.fromStream(this.sequenceM().prependStream(stream.sequenceM()));
    }

    default public Streamable<T> append(T ... values) {
        return Streamable.fromStream(this.sequenceM().append((Object[])values));
    }

    default public Streamable<T> prepend(T ... values) {
        return Streamable.fromStream(this.sequenceM().prepend((Object[])values));
    }

    default public Streamable<T> insertAt(int pos, T ... values) {
        return Streamable.fromStream(this.sequenceM().insertAt(pos, values));
    }

    default public Streamable<T> deleteBetween(int start, int end) {
        return Streamable.fromStream(this.sequenceM().deleteBetween(start, end));
    }

    default public Streamable<T> insertStreamableAt(int pos, Streamable<T> stream) {
        return Streamable.fromStream(this.sequenceM().insertStreamAt(pos, stream.sequenceM()));
    }

    default public FutureOperations<T> futureOperations(Executor exec) {
        return this.sequenceM().futureOperations(exec);
    }

    default public boolean endsWith(Iterable<T> iterable) {
        return this.sequenceM().endsWith(iterable);
    }

    default public boolean endsWith(Streamable<T> stream) {
        return this.sequenceM().endsWith(stream);
    }

    default public Streamable<T> skip(long time, TimeUnit unit) {
        return Streamable.fromStream(this.sequenceM().skip(time, unit));
    }

    default public Streamable<T> limit(long time, TimeUnit unit) {
        return Streamable.fromStream(this.sequenceM().limit(time, unit));
    }

    default public Streamable<T> skipLast(int num) {
        return Streamable.fromStream(this.sequenceM().skipLast(num));
    }

    default public Streamable<T> limitLast(int num) {
        return Streamable.fromStream(this.sequenceM().limitLast(num));
    }

    default public HotStream<T> hotStream(Executor e) {
        return this.sequenceM().hotStream(e);
    }

    default public T firstValue() {
        return this.sequenceM().firstValue();
    }

    default public T single() {
        return this.sequenceM().single();
    }

    default public Optional<T> get(long index) {
        return this.sequenceM().get(index);
    }

    default public Tuple2<T, Streamable<T>> elementAt(long index) {
        return this.sequenceM().elementAt(index).map2(s -> Streamable.fromStream(s));
    }

    default public Streamable<Tuple2<T, Long>> elapsed() {
        return Streamable.fromStream(this.sequenceM().elapsed());
    }

    default public Streamable<Tuple2<T, Long>> timestamp() {
        return Streamable.fromStream(this.sequenceM().timestamp());
    }

    public static <T> Streamable<T> reversedOf(T ... elements) {
        return Streamable.fromStream(SequenceM.reversedOf(elements));
    }

    public static <T> Streamable<T> reversedListOf(List<T> elements) {
        Objects.requireNonNull(elements);
        return Streamable.fromStream(SequenceM.reversedListOf(elements));
    }

    public static Streamable<Integer> range(int start, int end) {
        return Streamable.fromStream(SequenceM.range(start, end));
    }

    public static Streamable<Long> rangeLong(long start, long end) {
        return Streamable.fromStream(SequenceM.rangeLong(start, end));
    }

    public static Streamable<Integer> fromIntStream(IntStream stream) {
        Objects.requireNonNull(stream);
        return Streamable.fromStream(SequenceM.fromIntStream(stream));
    }

    public static Streamable<Long> fromLongStream(LongStream stream) {
        Objects.requireNonNull(stream);
        return Streamable.fromStream(SequenceM.fromLongStream(stream));
    }

    public static Streamable<Double> fromDoubleStream(DoubleStream stream) {
        Objects.requireNonNull(stream);
        return Streamable.fromStream(SequenceM.fromDoubleStream(stream));
    }

    public static <T> Streamable<T> fromList(List<T> list) {
        Objects.requireNonNull(list);
        return AsStreamable.fromIterable(list);
    }

    public static <T> Streamable<T> iterate(T seed, UnaryOperator<T> f) {
        Objects.requireNonNull(f);
        return Streamable.fromStream(SequenceM.iterate(seed, f));
    }

    public static <T> Streamable<T> generate(Supplier<T> s) {
        Objects.requireNonNull(s);
        return Streamable.fromStream(SequenceM.generate(s));
    }

    public static <T, U> Tuple2<Streamable<T>, Streamable<U>> unzip(Streamable<Tuple2<T, U>> sequence) {
        return SequenceM.unzip(sequence.sequenceM()).map1(s -> Streamable.fromStream(s)).map2(s -> Streamable.fromStream(s));
    }

    public static <T1, T2, T3> Tuple3<Streamable<T1>, Streamable<T2>, Streamable<T3>> unzip3(Streamable<Tuple3<T1, T2, T3>> sequence) {
        return SequenceM.unzip3(sequence.sequenceM()).map1(s -> Streamable.fromStream(s)).map2(s -> Streamable.fromStream(s)).map3(s -> Streamable.fromStream(s));
    }

    public static <T1, T2, T3, T4> Tuple4<Streamable<T1>, Streamable<T2>, Streamable<T3>, Streamable<T4>> unzip4(Streamable<Tuple4<T1, T2, T3, T4>> sequence) {
        return SequenceM.unzip4(sequence.sequenceM()).map1(s -> Streamable.fromStream(s)).map2(s -> Streamable.fromStream(s)).map3(s -> Streamable.fromStream(s)).map4(s -> Streamable.fromStream(s));
    }

    default public <U> Streamable<Tuple2<T, U>> crossJoin(Streamable<U> other) {
        return Streamable.fromStream(this.sequenceM().crossJoin(other.sequenceM()));
    }

    default public <U> Streamable<Tuple2<T, U>> innerJoin(Streamable<U> other, BiPredicate<T, U> predicate) {
        return Streamable.fromStream(this.sequenceM().innerJoin(other.sequenceM(), (BiPredicate)predicate));
    }

    default public <U> Streamable<Tuple2<T, U>> leftOuterJoin(Streamable<U> other, BiPredicate<T, U> predicate) {
        return Streamable.fromStream(this.sequenceM().leftOuterJoin(other.sequenceM(), (BiPredicate)predicate));
    }

    default public <U> Streamable<Tuple2<T, U>> rightOuterJoin(Streamable<U> other, BiPredicate<T, U> predicate) {
        return Streamable.fromStream(this.sequenceM().rightOuterJoin(other.sequenceM(), (BiPredicate)predicate));
    }

    default public Streamable<T> onEmptySwitch(Supplier<Streamable<T>> switchTo) {
        return Streamable.fromStream(this.sequenceM().onEmptySwitch(() -> ((Streamable)switchTo.get()).sequenceM()));
    }

    default public Streamable<T> onEmpty(T value) {
        return Streamable.fromStream(this.sequenceM().onEmpty((Object)value));
    }

    default public Streamable<T> onEmptyGet(Supplier<T> supplier) {
        return Streamable.fromStream(this.sequenceM().onEmptyGet((Supplier)supplier));
    }

    default public <X extends Throwable> Streamable<T> onEmptyThrow(Supplier<X> supplier) {
        return Streamable.fromStream(this.sequenceM().onEmptyThrow((Supplier)supplier));
    }

    default public Streamable<T> concat(Streamable<T> other) {
        return Streamable.fromStream(this.sequenceM().concat(other.sequenceM()));
    }

    default public Streamable<T> concat(T other) {
        return Streamable.fromStream(this.sequenceM().concat((Object)other));
    }

    default public Streamable<T> concat(T ... other) {
        return Streamable.fromStream(this.sequenceM().concat((Object[])other));
    }

    default public <U> Streamable<T> distinct(Function<? super T, ? extends U> keyExtractor) {
        return Streamable.fromStream(this.sequenceM().distinct((Function)keyExtractor));
    }

    default public Streamable<T> shuffle(Random random) {
        return Streamable.fromStream(this.sequenceM().shuffle(random));
    }

    default public Streamable<T> slice(long from, long to) {
        return Streamable.fromStream(this.sequenceM().slice(from, to));
    }

    default public <U extends Comparable<? super U>> Streamable<T> sorted(Function<? super T, ? extends U> function) {
        return Streamable.fromStream(this.sequenceM().sorted((Function)function));
    }

    default public Streamable<T> xPer(int x, long time, TimeUnit t) {
        return Streamable.fromStream(this.sequenceM().xPer(x, time, t));
    }

    default public Streamable<T> onePer(long time, TimeUnit t) {
        return Streamable.fromStream(this.sequenceM().onePer(time, t));
    }

    default public Streamable<T> debounce(long time, TimeUnit t) {
        return Streamable.fromStream(this.sequenceM().debounce(time, t));
    }

    default public Streamable<List<T>> batchBySizeAndTime(int size, long time, TimeUnit t) {
        return Streamable.fromStream(this.sequenceM().batchBySizeAndTime(size, time, t));
    }

    default public <C extends Collection<T>> Streamable<C> batchBySizeAndTime(int size, long time, TimeUnit unit, Supplier<C> factory) {
        return Streamable.fromStream(this.sequenceM().batchBySizeAndTime(size, time, unit, factory));
    }

    default public Streamable<List<T>> batchByTime(long time, TimeUnit t) {
        return Streamable.fromStream(this.sequenceM().batchByTime(time, t));
    }

    default public <C extends Collection<T>> Streamable<C> batchByTime(long time, TimeUnit unit, Supplier<C> factory) {
        return Streamable.fromStream(this.sequenceM().batchByTime(time, unit, factory));
    }

    default public Streamable<List<T>> batchBySize(int size) {
        return Streamable.fromStream(this.sequenceM().batchBySize(size));
    }

    default public <C extends Collection<T>> Streamable<C> batchBySize(int size, Supplier<C> supplier) {
        return Streamable.fromStream(this.sequenceM().batchBySize(size, supplier));
    }

    default public Streamable<T> fixedDelay(long l, TimeUnit unit) {
        return Streamable.fromStream(this.sequenceM().fixedDelay(l, unit));
    }

    default public Streamable<T> jitter(long maxJitterPeriodInNanos) {
        return Streamable.fromStream(this.sequenceM().jitter(maxJitterPeriodInNanos));
    }

    default public Streamable<Streamable<T>> windowBySizeAndTime(int maxSize, long maxTime, TimeUnit maxTimeUnit) {
        return Streamable.fromStream(this.sequenceM().windowBySizeAndTime(maxSize, maxTime, maxTimeUnit));
    }

    default public Streamable<Streamable<T>> windowWhile(Predicate<T> predicate) {
        return Streamable.fromStream(this.sequenceM().windowWhile(predicate));
    }

    default public Streamable<Streamable<T>> windowUntil(Predicate<T> predicate) {
        return Streamable.fromStream(this.sequenceM().windowUntil(predicate));
    }

    default public Streamable<Streamable<T>> windowStatefullyWhile(BiPredicate<Streamable<? super T>, ? super T> predicate) {
        return Streamable.fromStream(this.sequenceM().windowStatefullyWhile(predicate));
    }

    default public Streamable<Streamable<T>> windowByTime(long time, TimeUnit t) {
        return Streamable.fromStream(this.sequenceM().windowByTime(time, t));
    }

    default public Streamable<List<T>> batchUntil(Predicate<T> predicate) {
        return Streamable.fromStream(this.sequenceM().batchUntil(predicate));
    }

    default public Streamable<List<T>> batchWhile(Predicate<T> predicate) {
        return Streamable.fromStream(this.sequenceM().batchWhile(predicate));
    }

    default public <C extends Collection<T>> Streamable<C> batchWhile(Predicate<T> predicate, Supplier<C> factory) {
        return Streamable.fromStream(this.sequenceM().batchWhile(predicate, factory));
    }

    default public <C extends Collection<T>> Streamable<C> batchUntil(Predicate<T> predicate, Supplier<C> factory) {
        return Streamable.fromStream(this.sequenceM().batchUntil(predicate, factory));
    }

    default public Streamable<T> recover(Function<Throwable, T> fn) {
        return Streamable.fromStream(this.sequenceM().recover(fn));
    }

    default public <EX extends Throwable> Streamable<T> recover(Class<EX> exceptionClass, Function<EX, T> fn) {
        return Streamable.fromStream(this.sequenceM().recover(exceptionClass, fn));
    }

    default public <R> Streamable<R> retry(Function<T, R> fn) {
        return Streamable.fromStream(this.sequenceM().retry(fn));
    }

    default public boolean contains(T t) {
        return this.stream().anyMatch(c -> t.equals(c));
    }

    default public boolean parallelContains(T t) {
        return ((Stream)this.stream().parallel()).anyMatch(c -> t.equals(c));
    }
}

