/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.sequence;

import com.aol.cyclops.lambda.api.TupleWrapper;
import com.aol.cyclops.sequence.Monoid;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.pcollections.AmortizedPQueue;
import org.pcollections.ConsPStack;
import org.pcollections.HashTreePBag;
import org.pcollections.HashTreePMap;
import org.pcollections.HashTreePSet;
import org.pcollections.OrderedPSet;
import org.pcollections.PBag;
import org.pcollections.PMap;
import org.pcollections.POrderedSet;
import org.pcollections.PQueue;
import org.pcollections.PSet;
import org.pcollections.PStack;
import org.pcollections.PVector;
import org.pcollections.TreePVector;

public class Reducers {
    private static <T> PQueue<T> queueOf(T ... values) {
        AmortizedPQueue result = AmortizedPQueue.empty();
        for (T value : values) {
            result = result.plus(value);
        }
        return result;
    }

    private static <T> PQueue<T> queueSingleton(T value) {
        AmortizedPQueue result = AmortizedPQueue.empty();
        result = result.plus(value);
        return result;
    }

    public static <T> Monoid<PQueue<T>> toPQueue() {
        return Monoid.of(AmortizedPQueue.empty(), a -> b -> a.plusAll((Collection)b), x -> Reducers.queueSingleton(x));
    }

    public static <T> Monoid<POrderedSet<T>> toPOrderedSet() {
        return Monoid.of(OrderedPSet.empty(), a -> b -> a.plusAll((Collection)b), x -> OrderedPSet.singleton((Object)x));
    }

    public static <T> Monoid<PBag<T>> toPBag() {
        return Monoid.of(HashTreePBag.empty(), a -> b -> a.plusAll((Collection)b), x -> HashTreePBag.singleton((Object)x));
    }

    public static <T> Monoid<PSet<T>> toPSet() {
        return Monoid.of(HashTreePSet.empty(), a -> b -> a.plusAll((Collection)b), x -> HashTreePSet.singleton((Object)x));
    }

    public static <T> Monoid<PVector<T>> toPVector() {
        return Monoid.of(TreePVector.empty(), a -> b -> a.plusAll((Collection)b), x -> TreePVector.singleton((Object)x));
    }

    public static <T> Monoid<PStack<T>> toPStack() {
        return Monoid.of(ConsPStack.empty(), a -> b -> a.plusAll(a.size(), (Collection)b), x -> ConsPStack.singleton((Object)x));
    }

    public static <T> Monoid<PStack<T>> toPStackReversed() {
        return Monoid.of(ConsPStack.empty(), a -> b -> a.plusAll((Collection)b), x -> ConsPStack.singleton((Object)x));
    }

    public static <K, V> Monoid<PMap<K, V>> toPMap() {
        return Monoid.of(HashTreePMap.empty(), a -> b -> a.plusAll((Map)b), in -> {
            List w = ((TupleWrapper)() -> in).values();
            return HashTreePMap.singleton(w.get(0), w.get(1));
        });
    }

    public static Monoid<String> toString(String joiner) {
        return Monoid.of("", (a, b) -> a + joiner + b);
    }

    public static Monoid<Integer> toTotalInt() {
        return Monoid.of(0, a -> b -> a + b, x -> Integer.valueOf("" + x));
    }

    public static Monoid<Integer> toCountInt() {
        return Monoid.of(0, a -> b -> a + 1, x -> 1);
    }

    public static Monoid<Double> toTotalDouble() {
        return Monoid.of(Double.valueOf(0.0), (a, b) -> a + b);
    }

    public static Monoid<Double> toCountDouble() {
        return Monoid.of(0.0, a -> b -> a + 1.0, x -> Double.valueOf("" + x));
    }
}

