/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.sequence;

import com.aol.cyclops.functions.caching.Memoize;
import com.aol.cyclops.sequence.SequenceM;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;

public class HeadAndTail<T> {
    private final Supplier<T> head;
    private final Supplier<SequenceM<T>> tail;
    private final Supplier<Boolean> isHead;

    public HeadAndTail(Iterator<T> it) {
        this.isHead = Memoize.memoizeSupplier(() -> it.hasNext());
        this.head = Memoize.memoizeSupplier(() -> {
            if (this.isHead.get().booleanValue()) {
                return it.next();
            }
            throw new NoSuchElementException();
        });
        this.tail = Memoize.memoizeSupplier(() -> {
            if (!this.isHead.get().booleanValue()) {
                return SequenceM.empty();
            }
            this.head.get();
            return SequenceM.fromIterator(it);
        });
    }

    @Deprecated
    public HeadAndTail(T head, SequenceM<T> tailStream) {
        this.isHead = () -> true;
        this.head = () -> head;
        this.tail = () -> tailStream;
    }

    public boolean isHeadPresent() {
        return this.isHead.get();
    }

    public T head() {
        return this.head.get();
    }

    public Optional<T> headOptional() {
        return this.isHeadPresent() ? Optional.empty() : Optional.of(this.head());
    }

    public SequenceM<T> headStream() {
        return this.isHeadPresent() ? SequenceM.empty() : SequenceM.of(new Supplier[]{this.head}).map(Supplier::get);
    }

    public SequenceM<T> tail() {
        return this.tail.get();
    }

    @ConstructorProperties(value={"head", "tail", "isHead"})
    public HeadAndTail(Supplier<T> head, Supplier<SequenceM<T>> tail, Supplier<Boolean> isHead) {
        this.head = head;
        this.tail = tail;
        this.isHead = isHead;
    }
}

