/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.sequence.Monoid;
import com.aol.cyclops.sequence.SequenceM;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Stream;

public interface Foldable<T> {
    public SequenceM<T> stream();

    default public <R> R mapReduce(Monoid<R> reducer) {
        return this.stream().mapReduce(reducer);
    }

    default public <R> R mapReduce(Function<? super T, ? extends R> mapper, Monoid<R> reducer) {
        return this.stream().mapReduce(mapper, reducer);
    }

    default public T reduce(Monoid<T> reducer) {
        return this.stream().reduce(reducer);
    }

    default public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.stream().reduce(accumulator);
    }

    default public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.stream().reduce(identity, accumulator);
    }

    default public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.stream().reduce(identity, accumulator, combiner);
    }

    default public List<T> reduce(Stream<? extends Monoid<T>> reducers) {
        return this.stream().reduce(reducers);
    }

    default public List<T> reduce(Iterable<Monoid<T>> reducers) {
        return this.stream().reduce(reducers);
    }

    default public T foldLeft(Monoid<T> reducer) {
        return this.stream().foldLeft(reducer);
    }

    default public T foldLeft(T identity, BinaryOperator<T> accumulator) {
        return this.stream().foldLeft(identity, accumulator);
    }

    default public <T> T foldLeftMapToType(Monoid<T> reducer) {
        return this.stream().foldLeftMapToType(reducer);
    }

    default public T foldRight(Monoid<T> reducer) {
        return this.stream().foldRight(reducer);
    }

    default public T foldRight(T identity, BinaryOperator<T> accumulator) {
        return this.stream().foldRight(identity, accumulator);
    }

    default public <T> T foldRightMapToType(Monoid<T> reducer) {
        return this.stream().foldRightMapToType(reducer);
    }
}

