/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.comprehensions;

import com.aol.cyclops.comprehensions.BaseComprehensionData;
import com.aol.cyclops.comprehensions.ExecutionState;
import com.aol.cyclops.comprehensions.Initialisable;
import com.aol.cyclops.comprehensions.Proxier;
import com.aol.cyclops.comprehensions.Varsonly;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class ComprehensionData<T, R, V extends Initialisable> {
    private final BaseComprehensionData data;
    private final V vars;
    private final Proxier proxier = new Proxier();

    ComprehensionData(ExecutionState state, Optional<Class<V>> varsClass) {
        this.data = new BaseComprehensionData(state);
        this.vars = new Varsonly();
        this.vars.init(this.data);
    }

    ComprehensionData(V vars, ExecutionState state) {
        this.data = new BaseComprehensionData(state);
        this.vars = vars;
        this.vars.init(this.data);
    }

    public ComprehensionData<T, R, V> filter(Supplier<Boolean> s) {
        this.data.guardInternal(s);
        return this;
    }

    ComprehensionData<T, R, V> filterFunction(Function<V, Boolean> s) {
        this.data.guardInternal(() -> (Boolean)s.apply(this.vars));
        return this;
    }

    public <R> R yield(Supplier s) {
        return this.data.yieldInternal(s);
    }

    <R> R yieldFunction(Function<V, ?> s) {
        return this.data.yieldInternal(() -> s.apply(this.vars));
    }

    public <T> T $(String name) {
        return this.data.$Internal(name);
    }

    public <T> ComprehensionData<T, R, V> $(String name, Object f) {
        this.data.$Internal(name, f);
        return this;
    }

    public <T> ComprehensionData<T, R, V> $(String name, Supplier f) {
        this.data.$Internal(name, f);
        return this;
    }

    public V getVars() {
        return this.vars;
    }
}

