/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.future;

import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.sequence.future.FutureOperations;
import com.aol.cyclops.sequence.reactivestreams.ReactiveTask;
import com.aol.cyclops.streams.FutureStreamUtils;
import com.aol.cyclops.streams.future.DoubleOperatorsMixin;
import com.aol.cyclops.streams.future.IntOperatorsMixin;
import com.aol.cyclops.streams.future.LongOperatorsMixin;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class FutureOperationsImpl<T>
implements FutureOperations<T>,
DoubleOperatorsMixin<T>,
IntOperatorsMixin<T>,
LongOperatorsMixin<T> {
    private final Executor exec;
    private final SequenceM<T> stream;

    public CompletableFuture<List<T>> toList() {
        return CompletableFuture.supplyAsync(() -> this.stream.toList(), this.exec);
    }

    public CompletableFuture<T> lastValue() {
        return CompletableFuture.supplyAsync(() -> {
            List l = this.stream.toList();
            return l.get(l.size() - 1);
        }, this.exec);
    }

    public CompletableFuture<T> single() {
        return CompletableFuture.supplyAsync(() -> {
            List l = this.stream.toList();
            if (l.size() == 1) {
                return l.get(l.size() - 1);
            }
            throw new UnsupportedOperationException("single only works for Streams with a single value");
        }, this.exec);
    }

    public CompletableFuture<Set<T>> toSet() {
        return CompletableFuture.supplyAsync(() -> this.stream.toSet(), this.exec);
    }

    public <U extends Comparable<U>> CompletableFuture<Optional<T>> minBy(Function<T, U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.minBy(function));
    }

    public <U extends Comparable<U>> CompletableFuture<Optional<T>> maxBy(Function<T, U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.maxBy(function));
    }

    public <R, A> CompletableFuture<R> collect(Collector<? super T, A, R> collector) {
        return CompletableFuture.supplyAsync(() -> this.stream.collect(collector));
    }

    public <C extends Collection<T>> CompletableFuture<C> toCollection(Supplier<C> collectionFactory) {
        return CompletableFuture.supplyAsync(() -> this.stream.toCollection(collectionFactory), this.exec);
    }

    public <A> CompletableFuture<A[]> toArray(IntFunction<A[]> generator) {
        return CompletableFuture.supplyAsync(() -> this.stream.toArray(generator), this.exec);
    }

    public CompletableFuture<Object[]> toArray() {
        return CompletableFuture.supplyAsync(() -> this.stream.toArray(), this.exec);
    }

    public <K> CompletableFuture<Map<K, List<T>>> groupBy(Function<? super T, ? extends K> classifier) {
        return CompletableFuture.supplyAsync(() -> this.stream.groupBy(classifier), this.exec);
    }

    public <K, A, D> CompletableFuture<Map<K, D>> groupBy(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return CompletableFuture.supplyAsync(() -> this.stream.groupBy(classifier, downstream), this.exec);
    }

    public <K, D, A, M extends Map<K, D>> CompletableFuture<M> groupBy(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        return CompletableFuture.supplyAsync(() -> this.stream.groupBy(classifier, mapFactory, downstream), this.exec);
    }

    public <U> CompletableFuture<U> foldLeft(U seed, BiFunction<U, ? super T, U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.foldLeft(seed, function), this.exec);
    }

    public <U> CompletableFuture<U> foldRight(U seed, BiFunction<? super T, U, U> function) {
        return CompletableFuture.supplyAsync(() -> this.stream.foldRight(seed, function), this.exec);
    }

    public CompletableFuture<Optional<T>> min(Comparator<? super T> comparator) {
        return CompletableFuture.supplyAsync(() -> this.stream.min(comparator), this.exec);
    }

    public CompletableFuture<Optional<T>> max(Comparator<? super T> comparator) {
        return CompletableFuture.supplyAsync(() -> this.stream.max(comparator), this.exec);
    }

    public <R> CompletableFuture<R> collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return CompletableFuture.supplyAsync(() -> this.stream.collect(supplier, accumulator, combiner), this.exec);
    }

    public <U> CompletableFuture<U> reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return CompletableFuture.supplyAsync(() -> this.stream.reduce(identity, accumulator, combiner), this.exec);
    }

    public CompletableFuture<Optional<T>> reduce(BinaryOperator<T> accumulator) {
        return CompletableFuture.supplyAsync(() -> this.stream.reduce(accumulator));
    }

    public CompletableFuture<T> reduce(T identity, BinaryOperator<T> accumulator) {
        return CompletableFuture.supplyAsync(() -> this.stream.reduce(identity, accumulator), this.exec);
    }

    public CompletableFuture<Long> count() {
        return CompletableFuture.supplyAsync(() -> this.stream.count(), this.exec);
    }

    public CompletableFuture<String> join(CharSequence sep) {
        return CompletableFuture.supplyAsync(() -> this.stream.join(sep), this.exec);
    }

    public CompletableFuture<String> join() {
        return CompletableFuture.supplyAsync(() -> this.stream.join(), this.exec);
    }

    public CompletableFuture<String> join(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return CompletableFuture.supplyAsync(() -> this.stream.join(delimiter, prefix, suffix), this.exec);
    }

    public CompletableFuture<Optional<T>> findAny() {
        return CompletableFuture.supplyAsync(() -> this.stream.findAny(), this.exec);
    }

    public CompletableFuture<Optional<T>> findFirst() {
        return CompletableFuture.supplyAsync(() -> this.stream.findFirst(), this.exec);
    }

    public CompletableFuture<T> firstValue() {
        return CompletableFuture.supplyAsync(() -> this.stream.firstValue(), this.exec);
    }

    public CompletableFuture<Boolean> allMatch(Predicate<? super T> predicate) {
        return CompletableFuture.supplyAsync(() -> this.stream.allMatch(predicate), this.exec);
    }

    public CompletableFuture<Boolean> anyMatch(Predicate<? super T> predicate) {
        return CompletableFuture.supplyAsync(() -> this.stream.anyMatch(predicate), this.exec);
    }

    public CompletableFuture<Boolean> noneMatch(Predicate<? super T> predicate) {
        return CompletableFuture.supplyAsync(() -> this.stream.noneMatch(predicate), this.exec);
    }

    public void forEach(Consumer<T> c) {
        CompletableFuture.runAsync(() -> this.stream.forEach(c), this.exec);
    }

    public <X extends Throwable> ReactiveTask forEachX(long numberOfElements, Consumer<? super T> consumer) {
        return new ReactiveTask(this.exec, FutureStreamUtils.forEachX(this.stream, numberOfElements, consumer).map2(r -> CompletableFuture.runAsync(r, this.exec)));
    }

    public <X extends Throwable> ReactiveTask forEachXWithError(long numberOfElements, Consumer<? super T> consumer, Consumer<? super Throwable> consumerError) {
        return new ReactiveTask(this.exec, FutureStreamUtils.forEachXWithError(this.stream, numberOfElements, consumer, consumerError).map2(r -> CompletableFuture.runAsync(r, this.exec)));
    }

    public <X extends Throwable> ReactiveTask forEachXEvents(long numberOfElements, Consumer<? super T> consumer, Consumer<? super Throwable> consumerError, Runnable onComplete) {
        return new ReactiveTask(this.exec, FutureStreamUtils.forEachXEvents(this.stream, numberOfElements, consumer, consumerError, onComplete).map2(r -> CompletableFuture.runAsync(r, this.exec)));
    }

    public <X extends Throwable> ReactiveTask forEachWithError(Consumer<? super T> consumerElement, Consumer<? super Throwable> consumerError) {
        return new ReactiveTask(this.exec, FutureStreamUtils.forEachWithError(this.stream, consumerElement, consumerError).map2(r -> CompletableFuture.runAsync(r, this.exec)));
    }

    public <X extends Throwable> ReactiveTask forEachEvent(Consumer<? super T> consumerElement, Consumer<? super Throwable> consumerError, Runnable onComplete) {
        return new ReactiveTask(this.exec, FutureStreamUtils.forEachEvent(this.stream, consumerElement, consumerError, onComplete).map2(r -> CompletableFuture.runAsync(r, this.exec)));
    }

    public CompletableFuture<T> single(Predicate<T> predicate) {
        return CompletableFuture.supplyAsync(() -> this.stream.filter(predicate).single(), this.exec);
    }

    public CompletableFuture<Optional<T>> singleOptional() {
        return CompletableFuture.supplyAsync(() -> this.stream.singleOptional(), this.exec);
    }

    @ConstructorProperties(value={"exec", "stream"})
    public FutureOperationsImpl(Executor exec, SequenceM<T> stream) {
        this.exec = exec;
        this.stream = stream;
    }

    @Override
    public Executor getExec() {
        return this.exec;
    }

    @Override
    public SequenceM<T> getStream() {
        return this.stream;
    }
}

