/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.scheduling.util.cron.CronExpression;
import com.aol.cyclops.sequence.HotStream;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.streams.StreamUtils;
import com.aol.cyclops.streams.spliterators.ClosingSpliterator;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import uk.co.real_logic.agrona.concurrent.OneToOneConcurrentArrayQueue;

public class HotStreamImpl<T>
implements HotStream<T> {
    private final Stream<T> stream;
    private final AtomicReferenceArray<Queue<T>> connections = new AtomicReferenceArray(10);
    private final AtomicBoolean open = new AtomicBoolean(true);
    private volatile int connected = 0;

    public HotStreamImpl(Stream<T> stream) {
        this.stream = stream;
    }

    public HotStream<T> schedule(String cron, ScheduledExecutorService ex) {
        Iterator it = this.stream.iterator();
        return this.scheduleInternal(it, cron, ex);
    }

    private HotStream<T> scheduleInternal(Iterator<T> it, String cron, ScheduledExecutorService ex) {
        Date now = new Date();
        Date d = ((CronExpression)ExceptionSoftener.softenSupplier(() -> new CronExpression(cron)).get()).getNextInvalidTimeAfter(now);
        long delay = d.getTime() - now.getTime();
        ex.schedule(() -> {
            Iterator iterator2 = it;
            synchronized (iterator2) {
                if (it.hasNext()) {
                    try {
                        Object next = it.next();
                        int local = this.connected;
                        for (int i = 0; i < local; ++i) {
                            this.connections.get(i).offer(next);
                        }
                    }
                    finally {
                        this.scheduleInternal(it, cron, ex);
                    }
                } else {
                    this.open.set(false);
                }
            }
        }, delay, TimeUnit.MILLISECONDS);
        return this;
    }

    public HotStream<T> scheduleFixedDelay(long delay, ScheduledExecutorService ex) {
        Iterator it = this.stream.iterator();
        ex.scheduleWithFixedDelay(() -> {
            Iterator iterator2 = it;
            synchronized (iterator2) {
                if (it.hasNext()) {
                    Object next = it.next();
                    int local = this.connected;
                    for (int i = 0; i < local; ++i) {
                        this.connections.get(i).offer(next);
                    }
                } else {
                    this.open.set(false);
                }
            }
        }, delay, delay, TimeUnit.MILLISECONDS);
        return this;
    }

    public HotStream<T> scheduleFixedRate(long rate, ScheduledExecutorService ex) {
        Iterator it = this.stream.iterator();
        ex.scheduleAtFixedRate(() -> {
            Iterator iterator2 = it;
            synchronized (iterator2) {
                if (it.hasNext()) {
                    Object next = it.next();
                    int local = this.connected;
                    for (int i = 0; i < local; ++i) {
                        this.connections.get(i).offer(next);
                    }
                } else {
                    this.open.set(false);
                }
            }
        }, 0L, rate, TimeUnit.MILLISECONDS);
        return this;
    }

    public HotStream<T> init(Executor exec) {
        CompletableFuture.runAsync(() -> {
            this.stream.forEach(a -> {
                int local = this.connected;
                for (int i = 0; i < local; ++i) {
                    this.connections.get(i).offer(a);
                }
            });
            this.open.set(false);
        }, exec);
        return this;
    }

    public SequenceM<T> connect() {
        return this.connect((Queue<T>)new OneToOneConcurrentArrayQueue(256));
    }

    public SequenceM<T> connect(Queue<T> queue) {
        this.connections.getAndSet(this.connected, queue);
        ++this.connected;
        return StreamUtils.sequenceM(StreamSupport.stream(new ClosingSpliterator(Long.MAX_VALUE, queue, this.open), false), Optional.empty());
    }

    public <R extends Stream<T>> R connectTo(Queue<T> queue, Function<SequenceM<T>, R> to) {
        return (R)((Stream)to.apply(this.connect(queue)));
    }
}

