/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.operators;

import com.aol.cyclops.streams.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public final class DebounceOperator<T> {
    private final Stream<T> stream;

    public Stream<T> debounce(long time, TimeUnit t) {
        final Iterator it = this.stream.iterator();
        final long timeNanos = t.toNanos(time);
        return StreamUtils.stream(new Iterator<T>(){
            volatile long last = 0L;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                long elapsedNanos = 1L;
                Object nextValue = null;
                while (elapsedNanos > 0L && it.hasNext()) {
                    nextValue = it.next();
                    if (this.last == 0L) {
                        this.last = System.nanoTime();
                    }
                    elapsedNanos = timeNanos - (System.nanoTime() - this.last);
                }
                this.last = System.nanoTime();
                return nextValue;
            }
        });
    }

    @ConstructorProperties(value={"stream"})
    public DebounceOperator(Stream<T> stream) {
        this.stream = stream;
    }

    public Stream<T> getStream() {
        return this.stream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebounceOperator)) {
            return false;
        }
        DebounceOperator other = (DebounceOperator)o;
        Stream<T> this$stream = this.getStream();
        Stream<T> other$stream = other.getStream();
        return !(this$stream == null ? other$stream != null : !this$stream.equals(other$stream));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Stream<T> $stream = this.getStream();
        result = result * 59 + ($stream == null ? 0 : $stream.hashCode());
        return result;
    }

    public String toString() {
        return "DebounceOperator(stream=" + this.getStream() + ")";
    }
}

