/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.operators;

import com.aol.cyclops.streams.StreamUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class BatchWhileOperator<T, C extends Collection<T>> {
    private static final Object UNSET = new Object();
    private final Stream<T> stream;
    private final Supplier<C> factory;

    public BatchWhileOperator(Stream<T> stream) {
        this.stream = stream;
        this.factory = () -> new ArrayList();
    }

    public BatchWhileOperator(Stream<T> stream, Supplier<C> factory) {
        this.stream = stream;
        this.factory = factory;
    }

    public Stream<C> batchWhile(final Predicate<T> predicate) {
        final Iterator it = this.stream.iterator();
        return StreamUtils.stream(new Iterator<C>(){
            T value = BatchWhileOperator.access$000();

            @Override
            public boolean hasNext() {
                return this.value != UNSET || it.hasNext();
            }

            @Override
            public C next() {
                Collection list = (Collection)BatchWhileOperator.this.factory.get();
                if (this.value != UNSET) {
                    list.add(this.value);
                }
                while (it.hasNext()) {
                    Object value = it.next();
                    list.add(value);
                    if (!predicate.test(value)) {
                        value = UNSET;
                        break;
                    }
                    Object object = UNSET;
                }
                return list;
            }
        }).filter(l -> l.size() > 0);
    }

    public Stream<T> getStream() {
        return this.stream;
    }

    public Supplier<C> getFactory() {
        return this.factory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchWhileOperator)) {
            return false;
        }
        BatchWhileOperator other = (BatchWhileOperator)o;
        Stream<T> this$stream = this.getStream();
        Stream<T> other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        Supplier<C> this$factory = this.getFactory();
        Supplier<C> other$factory = other.getFactory();
        return !(this$factory == null ? other$factory != null : !this$factory.equals(other$factory));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Stream<T> $stream = this.getStream();
        result = result * 59 + ($stream == null ? 0 : $stream.hashCode());
        Supplier<C> $factory = this.getFactory();
        result = result * 59 + ($factory == null ? 0 : $factory.hashCode());
        return result;
    }

    public String toString() {
        return "BatchWhileOperator(stream=" + this.getStream() + ", factory=" + this.getFactory() + ")";
    }
}

