/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.future;

import com.aol.cyclops.sequence.future.IntOperators;
import com.aol.cyclops.streams.HasExec;
import com.aol.cyclops.streams.HasStream;
import java.util.IntSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;

public interface IntOperatorsMixin<T>
extends IntOperators<T>,
HasStream<T>,
HasExec {
    default public CompletableFuture<Integer> sumInt(ToIntFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).sum(), this.getExec());
    }

    default public CompletableFuture<OptionalInt> maxInt(ToIntFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).max(), this.getExec());
    }

    default public CompletableFuture<OptionalInt> minInt(ToIntFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).min(), this.getExec());
    }

    default public CompletableFuture<OptionalDouble> averageInt(ToIntFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).average(), this.getExec());
    }

    default public CompletableFuture<IntSummaryStatistics> summaryStatisticsInt(ToIntFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).summaryStatistics(), this.getExec());
    }
}

