/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams;

import com.aol.cyclops.closures.mutable.Mutable;
import com.aol.cyclops.internal.AsGenericMonad;
import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.monad.AnyM;
import com.aol.cyclops.sequence.HeadAndTail;
import com.aol.cyclops.sequence.HotStream;
import com.aol.cyclops.sequence.Monoid;
import com.aol.cyclops.sequence.ReversedIterator;
import com.aol.cyclops.sequence.SeqUtils;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.sequence.SequenceMImpl;
import com.aol.cyclops.sequence.future.FutureOperations;
import com.aol.cyclops.sequence.spliterators.ReversableSpliterator;
import com.aol.cyclops.sequence.streamable.AsStreamable;
import com.aol.cyclops.sequence.streamable.Streamable;
import com.aol.cyclops.streams.HotStreamImpl;
import com.aol.cyclops.streams.future.FutureOperationsImpl;
import com.aol.cyclops.streams.operators.BatchBySizeOperator;
import com.aol.cyclops.streams.operators.BatchByTimeAndSizeOperator;
import com.aol.cyclops.streams.operators.BatchByTimeOperator;
import com.aol.cyclops.streams.operators.BatchWhileOperator;
import com.aol.cyclops.streams.operators.DebounceOperator;
import com.aol.cyclops.streams.operators.LimitLastOperator;
import com.aol.cyclops.streams.operators.LimitWhileOperator;
import com.aol.cyclops.streams.operators.LimitWhileTimeOperator;
import com.aol.cyclops.streams.operators.MultiCollectOperator;
import com.aol.cyclops.streams.operators.MultiReduceOperator;
import com.aol.cyclops.streams.operators.OnePerOperator;
import com.aol.cyclops.streams.operators.RecoverOperator;
import com.aol.cyclops.streams.operators.SkipLastOperator;
import com.aol.cyclops.streams.operators.SkipWhileOperator;
import com.aol.cyclops.streams.operators.SkipWhileTimeOperator;
import com.aol.cyclops.streams.operators.WindowByTimeAndSizeOperator;
import com.aol.cyclops.streams.operators.WindowStatefullyWhileOperator;
import com.aol.cyclops.streams.operators.WindowWhileOperator;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.pcollections.ConsPStack;
import org.pcollections.PStack;

public final class StreamUtils {
    private static final Object UNSET = new Object();

    public static final <T> Optional<List<T>> streamToOptional(Stream<T> stream) {
        List collected = stream.collect(Collectors.toList());
        if (collected.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(collected);
    }

    public static final <T> Stream<T> optionalToStream(Optional<T> optional) {
        if (optional.isPresent()) {
            return Stream.of(optional.get());
        }
        return Stream.of(new Object[0]);
    }

    public static final <T> CompletableFuture<List<T>> streamToCompletableFuture(Stream<T> stream) {
        return CompletableFuture.completedFuture(stream.collect(Collectors.toList()));
    }

    public static final <T> Stream<T> completableFutureToStream(CompletableFuture<T> future) {
        return Stream.of(future.join());
    }

    public static final <T> Tuple2<Stream<T>, Stream<T>> splitAt(Stream<T> stream, int where) {
        Tuple2<Stream<T>, Stream<T>> Tuple22 = StreamUtils.duplicate(stream);
        return new Tuple2(((Stream)Tuple22.v1).limit(where), ((Stream)Tuple22.v2).skip(where));
    }

    public static final <T> Tuple2<Stream<T>, Stream<T>> splitBy(Stream<T> stream, Predicate<T> splitter) {
        Tuple2<Stream<T>, Stream<T>> Tuple22 = StreamUtils.duplicate(stream);
        return new Tuple2(StreamUtils.limitWhile((Stream)Tuple22.v1, splitter), StreamUtils.skipWhile((Stream)Tuple22.v2, splitter));
    }

    public static final <T> Tuple2<Stream<T>, Stream<T>> partition(Stream<T> stream, Predicate<T> splitter) {
        Tuple2<Stream<T>, Stream<T>> Tuple22 = StreamUtils.duplicate(stream);
        return new Tuple2(((Stream)Tuple22.v1).filter(splitter), ((Stream)Tuple22.v2).filter(splitter.negate()));
    }

    public static final <T> Tuple2<Stream<T>, Stream<T>> duplicate(Stream<T> stream) {
        Tuple2 Tuple22 = StreamUtils.toBufferingDuplicator(stream.iterator());
        return new Tuple2(StreamUtils.stream((Iterator)Tuple22.v1()), StreamUtils.stream((Iterator)Tuple22.v2()));
    }

    private static final <T> Tuple2<Stream<T>, Stream<T>> duplicatePos(Stream<T> stream, int pos) {
        Tuple2 Tuple22 = StreamUtils.toBufferingDuplicator(stream.iterator(), pos);
        return new Tuple2(StreamUtils.stream((Iterator)Tuple22.v1()), StreamUtils.stream((Iterator)Tuple22.v2()));
    }

    public static final <T> Tuple3<Stream<T>, Stream<T>, Stream<T>> triplicate(Stream<T> stream) {
        Stream<Stream> its = StreamUtils.toBufferingCopier(stream.iterator(), 3).stream().map(it -> StreamUtils.stream(it));
        Iterator it2 = its.iterator();
        return new Tuple3(it2.next(), it2.next(), it2.next());
    }

    public static final <T> Tuple4<Stream<T>, Stream<T>, Stream<T>, Stream<T>> quadruplicate(Stream<T> stream) {
        Stream<Stream> its = StreamUtils.toBufferingCopier(stream.iterator(), 4).stream().map(it -> StreamUtils.stream(it));
        Iterator it2 = its.iterator();
        return new Tuple4(it2.next(), it2.next(), it2.next(), it2.next());
    }

    public static final <T> Stream<T> appendStream(Stream<T> stream1, Stream<T> append) {
        return Stream.concat(stream1, append);
    }

    public static final <T> Stream<T> prependStream(Stream<T> stream1, Stream<T> prepend) {
        return Stream.concat(prepend, stream1);
    }

    public static final <T> Stream<T> append(Stream<T> stream, T ... values) {
        return StreamUtils.appendStream(stream, Stream.of(values));
    }

    public static final <T> Stream<T> prepend(Stream<T> stream, T ... values) {
        return StreamUtils.appendStream(Stream.of(values), stream);
    }

    public static final <T> Stream<T> insertAt(Stream<T> stream, int pos, T ... values) {
        Tuple2<Stream<T>, Stream<T>> Tuple22 = StreamUtils.duplicatePos(stream, pos);
        return StreamUtils.appendStream(StreamUtils.append(((Stream)Tuple22.v1).limit(pos), values), ((Stream)Tuple22.v2).skip(pos));
    }

    public static final <T> Stream<T> deleteBetween(Stream<T> stream, int start, int end) {
        Tuple2<Stream<T>, Stream<T>> Tuple22 = StreamUtils.duplicatePos(stream, start);
        return StreamUtils.appendStream(((Stream)Tuple22.v1).limit(start), ((Stream)Tuple22.v2).skip(end));
    }

    public static final <T> Stream<T> insertStreamAt(Stream<T> stream1, int pos, Stream<T> insert) {
        Tuple2<Stream<T>, Stream<T>> Tuple22 = StreamUtils.duplicatePos(stream1, pos);
        return StreamUtils.appendStream(StreamUtils.appendStream(((Stream)Tuple22.v1).limit(pos), insert), ((Stream)Tuple22.v2).skip(pos));
    }

    public static final <T> Stream<T> cycle(Stream<T> stream, Monoid<T> m, int times) {
        return StreamUtils.cycle(times, AsStreamable.fromObject((Object)m.reduce(stream)));
    }

    public static final <T> HeadAndTail<T> headAndTail(Stream<T> stream) {
        Iterator it = stream.iterator();
        return new HeadAndTail(it.next(), StreamUtils.sequenceM(StreamUtils.stream(it), Optional.empty()));
    }

    public static final <T> Optional<HeadAndTail<T>> headAndTailOptional(Stream<T> stream) {
        Iterator it = stream.iterator();
        if (!it.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(new HeadAndTail(it.next(), StreamUtils.sequenceM(StreamUtils.stream(it), Optional.empty())));
    }

    public static <U> Stream<U> skipUntil(Stream<U> stream, Predicate<? super U> predicate) {
        return StreamUtils.skipWhile(stream, predicate.negate());
    }

    public static <U> Stream<U> skipLast(Stream<U> stream, int num) {
        return new SkipLastOperator<U>(stream, num).skipLast();
    }

    public static <U> Stream<U> limitLast(Stream<U> stream, int num) {
        return new LimitLastOperator<U>(stream, num).limitLast();
    }

    public static <T> Stream<T> recover(Stream<T> stream, Function<Throwable, T> fn) {
        return new RecoverOperator<T>(stream, Throwable.class).recover(fn);
    }

    public static <T, EX extends Throwable> Stream<T> recover(Stream<T> stream, Class<EX> type, Function<EX, T> fn) {
        return new RecoverOperator<T>(stream, type).recover(fn);
    }

    public static <U> Stream<U> skipWhile(Stream<U> stream, Predicate<? super U> predicate) {
        return new SkipWhileOperator<U>(stream).skipWhile(predicate);
    }

    public static <U> Stream<U> limit(Stream<U> stream, long time, TimeUnit unit) {
        return new LimitWhileTimeOperator<U>(stream).limitWhile(time, unit);
    }

    public static <U> Stream<U> skip(Stream<U> stream, long time, TimeUnit unit) {
        return new SkipWhileTimeOperator<U>(stream).skipWhile(time, unit);
    }

    public static <U> Stream<U> limitWhile(Stream<U> stream, Predicate<? super U> predicate) {
        return new LimitWhileOperator<U>(stream).limitWhile(predicate);
    }

    public static <U> Stream<U> limitUntil(Stream<U> stream, Predicate<? super U> predicate) {
        return StreamUtils.limitWhile(stream, predicate.negate());
    }

    public static <U> Stream<U> reverse(Stream<U> stream) {
        return StreamUtils.reversedStream(stream.collect(Collectors.toList()));
    }

    public static <U> Stream<U> reversedStream(List<U> list) {
        return new ReversedIterator(list).stream();
    }

    public static <U> Stream<U> cycle(Stream<U> s) {
        return StreamUtils.cycle(AsStreamable.fromStream(s));
    }

    public static <U> Stream<U> cycle(Streamable<U> s) {
        return Stream.iterate(s.stream(), s1 -> s.stream()).flatMap(Function.identity());
    }

    public static <U> Stream<U> cycle(int times, Streamable<U> s) {
        return Stream.iterate(s.stream(), s1 -> s.stream()).limit(times).flatMap(Function.identity());
    }

    public static <U> Stream<U> stream(Iterable<U> it) {
        return StreamSupport.stream(it.spliterator(), false);
    }

    public static <U> Stream<U> stream(Spliterator<U> it) {
        return StreamSupport.stream(it, false);
    }

    public static <U> Stream<U> stream(Iterator<U> it) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }

    public static <U> Stream<U> concat(Object o, Stream<U> stream) {
        Stream<Object> first = null;
        first = o instanceof Stream ? (Stream<U>)o : (o instanceof Iterable ? StreamUtils.stream((Iterable)o) : (o instanceof Streamable ? ((Streamable)o).stream() : Stream.of(o)));
        return Stream.concat(first, stream);
    }

    public static final <K, V> Stream<Map.Entry<K, V>> stream(Map<K, V> it) {
        return it.entrySet().stream();
    }

    public static final <T> FutureOperations<T> futureOperations(Stream<T> stream, Executor exec) {
        return new FutureOperationsImpl<T>(exec, StreamUtils.sequenceM(stream, Optional.empty()));
    }

    public static final <T> T firstValue(Stream<T> stream) {
        return stream.findAny().get();
    }

    public static <R> List<R> reduce(Stream<R> stream, Iterable<Monoid<R>> reducers) {
        return new MultiReduceOperator<R>(stream).reduce(reducers);
    }

    public static <R> List<R> reduce(Stream<R> stream, Stream<Monoid<R>> reducers) {
        return StreamUtils.reduce(stream, reducers.collect(Collectors.toList()));
    }

    public static <T, A, R> List<R> collect(Stream<T> stream, Stream<Collector> collectors) {
        return StreamUtils.collect(stream, (Streamable<Collector>)AsStreamable.fromStream(collectors));
    }

    public static <T, A, R> List<R> collect(Stream<T> stream, Iterable<Collector> collectors) {
        return StreamUtils.collect(stream, (Streamable<Collector>)AsStreamable.fromIterable(collectors));
    }

    public static <T> List collect(Stream<T> stream, Streamable<Collector> collectors) {
        return new MultiCollectOperator<T>(stream).collect(collectors);
    }

    public static final <T> Stream<T> cycleWhile(Stream<T> stream, Predicate<? super T> predicate) {
        return StreamUtils.limitWhile(StreamUtils.cycle(stream), predicate);
    }

    public static final <T> Stream<T> cycleUntil(Stream<T> stream, Predicate<? super T> predicate) {
        return StreamUtils.limitUntil(StreamUtils.cycle(stream), predicate);
    }

    public static final <T, S, R> Stream<R> zipSequence(Stream<T> stream, Stream<? extends S> second, final BiFunction<? super T, ? super S, ? extends R> zipper) {
        final Iterator left = stream.iterator();
        final Iterator right = second.iterator();
        return StreamUtils.stream(new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return left.hasNext() && right.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(left.next(), right.next());
            }
        });
    }

    public static final <T, S, R> Stream<R> zipAnyM(Stream<T> stream, AnyM<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return StreamUtils.zipSequence(stream, second.toSequence(), zipper);
    }

    public static final <T, S, R> Stream<R> zipStream(Stream<T> stream, BaseStream<? extends S, ? extends BaseStream<? extends S, ?>> second, final BiFunction<? super T, ? super S, ? extends R> zipper) {
        final Iterator left = stream.iterator();
        final Iterator<? extends S> right = second.iterator();
        return StreamUtils.stream(new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return left.hasNext() && right.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(left.next(), right.next());
            }
        });
    }

    public static final <T> Stream<List<T>> sliding(Stream<T> stream, final int windowSize, final int increment) {
        final Iterator it = stream.iterator();
        final Mutable list = Mutable.of((Object)ConsPStack.empty());
        return StreamUtils.stream(new Iterator<List<T>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public List<T> next() {
                int i;
                for (i = 0; i < increment && ((PStack)list.get()).size() > 0; ++i) {
                    list.mutate(var -> var.minus(0));
                }
                i = 0;
                while (((PStack)list.get()).size() < windowSize && it.hasNext()) {
                    if (it.hasNext()) {
                        list.mutate(var -> var.plus(Math.max(0, var.size()), it.next()));
                    }
                    ++i;
                }
                return (List)list.get();
            }
        });
    }

    public static final <T> Stream<Streamable<T>> window(Stream<T> stream, final int windowSize, final int increment) {
        final Iterator it = stream.iterator();
        final Mutable list = Mutable.of((Object)ConsPStack.empty());
        return StreamUtils.stream(new Iterator<Streamable<T>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Streamable<T> next() {
                int i;
                for (i = 0; i < increment && ((PStack)list.get()).size() > 0; ++i) {
                    list.mutate(var -> var.minus(0));
                }
                i = 0;
                while (((PStack)list.get()).size() < windowSize && it.hasNext()) {
                    if (it.hasNext()) {
                        list.mutate(var -> var.plus(Math.max(0, var.size()), it.next()));
                    }
                    ++i;
                }
                return Streamable.fromIterable((Iterable)((Iterable)list.get()));
            }
        });
    }

    public static final <T> Stream<List<T>> sliding(Stream<T> stream, int windowSize) {
        return StreamUtils.sliding(stream, windowSize, 1);
    }

    public static final <T> Stream<List<T>> batchBySize(Stream<T> stream, int groupSize) {
        return new BatchBySizeOperator(stream).batchBySize(groupSize);
    }

    public static final <T, C extends Collection<T>> Stream<C> batchBySize(Stream<T> stream, int groupSize, Supplier<C> factory) {
        return new BatchBySizeOperator<T, C>(stream, factory).batchBySize(groupSize);
    }

    public static final <T> Streamable<T> shuffle(Stream<T> stream) {
        List list = stream.collect(Collectors.toList());
        Collections.shuffle(list);
        return Streamable.fromIterable(list);
    }

    public static final <T> Streamable<T> toLazyStreamable(Stream<T> stream) {
        return AsStreamable.fromStream(stream);
    }

    public static final <T> Streamable<T> toConcurrentLazyStreamable(Stream<T> stream) {
        return AsStreamable.synchronizedFromStream(stream);
    }

    public static final <U, T> Stream<U> scanRight(Stream<T> stream, U identity, BiFunction<? super T, U, U> combiner) {
        return Seq.seq(stream).scanRight(identity, combiner);
    }

    public static final <T> Stream<T> scanLeft(Stream<T> stream, final Monoid<T> monoid) {
        final Iterator it = stream.iterator();
        return StreamUtils.stream(new Iterator<T>(){
            boolean init = false;
            T next = monoid.zero();

            @Override
            public boolean hasNext() {
                if (!this.init) {
                    return true;
                }
                return it.hasNext();
            }

            @Override
            public T next() {
                if (!this.init) {
                    this.init = true;
                    return monoid.zero();
                }
                this.next = monoid.combiner().apply(this.next, it.next());
                return this.next;
            }
        });
    }

    public static <T> boolean xMatch(Stream<T> stream, int num, Predicate<? super T> c) {
        return stream.filter(t -> c.test(t)).collect(Collectors.counting()) == (long)num;
    }

    public static final <T> boolean noneMatch(Stream<T> stream, Predicate<? super T> c) {
        return stream.allMatch(c.negate());
    }

    public static final <T> String join(Stream<T> stream) {
        return stream.map(t -> t.toString()).collect(Collectors.joining());
    }

    public static final <T> String join(Stream<T> stream, String sep) {
        return stream.map(t -> t.toString()).collect(Collectors.joining(sep));
    }

    public static final <T> String join(Stream<T> stream, String sep, String start, String end) {
        return stream.map(t -> t.toString()).collect(Collectors.joining(sep, start, end));
    }

    public static final <T, C extends Comparable<C>> Optional<T> minBy(Stream<T> stream, Function<T, C> f) {
        Optional<Tuple2> o = stream.map(in -> new Tuple2(f.apply(in), in)).min(Comparator.comparing(n -> (Comparable)n.v1(), Comparator.naturalOrder()));
        return o.map(p -> p.v2());
    }

    public static final <T> Optional<T> min(Stream<T> stream, Comparator<? super T> comparator) {
        return stream.collect(Collectors.minBy(comparator));
    }

    public static final <T, C extends Comparable<? super C>> Optional<T> maxBy(Stream<T> stream, Function<T, C> f) {
        Optional<Tuple2> o = stream.map(in -> new Tuple2(f.apply(in), in)).max(Comparator.comparing(n -> (Comparable)n.v1(), Comparator.naturalOrder()));
        return o.map(p -> p.v2());
    }

    public static final <T> Optional<T> max(Stream<T> stream, Comparator<? super T> comparator) {
        return stream.collect(Collectors.maxBy(comparator));
    }

    public static final <T, R> R mapReduce(Stream<T> stream, Monoid<R> reducer) {
        return (R)reducer.mapReduce(stream);
    }

    public static final <T, R> R mapReduce(Stream<T> stream, Function<? super T, ? extends R> mapper, Monoid<R> reducer) {
        return (R)reducer.reduce(stream.map(mapper));
    }

    public static final <T> T foldLeft(Stream<T> stream, Monoid<T> reducer) {
        return (T)reducer.reduce(stream);
    }

    public static final <T> T foldLeftMapToType(Stream<T> stream, Monoid<T> reducer) {
        return (T)reducer.mapReduce(stream);
    }

    public static final <T> T foldRight(Stream<T> stream, Monoid<T> reducer) {
        return (T)reducer.reduce(StreamUtils.reverse(stream));
    }

    public static final <T> T foldRightMapToType(Stream<T> stream, Monoid<T> reducer) {
        return (T)reducer.mapReduce(StreamUtils.reverse(stream));
    }

    public static final <T> Streamable<T> toStreamable(Stream<T> stream) {
        return AsStreamable.fromStream(stream);
    }

    public static final <T> Set<T> toSet(Stream<T> stream) {
        return stream.collect(Collectors.toSet());
    }

    public static final <T> List<T> toList(Stream<T> stream) {
        return stream.collect(Collectors.toList());
    }

    public static final <T> boolean startsWith(Stream<T> stream, Iterable<T> iterable) {
        return StreamUtils.startsWith(stream, iterable.iterator());
    }

    public static final <T> boolean endsWith(Stream<T> stream, Iterable<T> iterable) {
        Iterator<T> it = iterable.iterator();
        ArrayList compare1 = new ArrayList();
        while (it.hasNext()) {
            compare1.add(it.next());
        }
        LinkedList list = new LinkedList();
        stream.forEach(v -> {
            list.add(v);
            if (list.size() > compare1.size()) {
                list.remove();
            }
        });
        return StreamUtils.startsWith(list.stream(), compare1.iterator());
    }

    public static final <T> boolean startsWith(Stream<T> stream, Iterator<T> iterator) {
        Iterator it = stream.iterator();
        while (iterator.hasNext()) {
            if (!it.hasNext()) {
                return false;
            }
            if (Objects.equals(it.next(), iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static final <T> SequenceM<T> sequenceM(Stream<T> stream, Optional<ReversableSpliterator> rev) {
        if (stream instanceof SequenceM) {
            return (SequenceM)stream;
        }
        if (rev.isPresent()) {
            return new SequenceMImpl<T>(stream, rev.get());
        }
        return new SequenceMImpl<T>(stream);
    }

    public static <T> Stream<T> intersperse(Stream<T> stream, T value) {
        return stream.flatMap(t -> Stream.of(value, t)).skip(1L);
    }

    public static <T, U> Stream<U> ofType(Stream<T> stream, Class<U> type) {
        return stream.filter(type::isInstance).map(t -> t);
    }

    public static <T, U> Stream<U> cast(Stream<T> stream, Class<U> type) {
        return stream.map(type::cast);
    }

    public static final <T, R> Stream<R> flatMapSequenceM(Stream<T> stream, Function<? super T, SequenceM<? extends R>> fn) {
        return stream.flatMap(fn);
    }

    public static final <T, R> Stream<R> flatMapAnyM(Stream<T> stream, Function<? super T, AnyM<? extends R>> fn) {
        return AsGenericMonad.asMonad(stream).bind(in -> ((AnyM)fn.apply(in)).unwrap()).sequence();
    }

    public static final <T, R> Stream<R> flatMapCollection(Stream<T> stream, Function<? super T, Collection<? extends R>> fn) {
        return stream.flatMap(fn.andThen(c -> c.stream()));
    }

    public static final <T, R> Stream<R> flatMapStream(Stream<T> stream, Function<? super T, BaseStream<? extends R, ?>> fn) {
        return stream.flatMap(fn.andThen(bs -> {
            if (bs instanceof Stream) {
                return (Stream)bs;
            }
            return StreamUtils.stream(bs.iterator());
        }));
    }

    public static final <T, R> Stream<R> flatMapOptional(Stream<T> stream, Function<? super T, Optional<? extends R>> fn) {
        return stream.flatMap(in -> StreamUtils.optionalToStream((Optional)fn.apply(in)));
    }

    public static final <T, R> SequenceM<R> flatten(Stream<T> stream) {
        return AsGenericMonad.asMonad(stream).flatten().sequence();
    }

    public static final <T, R> Stream<R> flatMapCompletableFuture(Stream<T> stream, Function<? super T, CompletableFuture<? extends R>> fn) {
        return stream.flatMap(in -> StreamUtils.completableFutureToStream((CompletableFuture)fn.apply(in)));
    }

    public static final <T> Stream<Character> flatMapCharSequence(Stream<T> stream, Function<? super T, CharSequence> fn) {
        return AsGenericMonad.asMonad(stream).liftAndBind(fn).sequence();
    }

    public static final <T> Stream<String> flatMapFile(Stream<T> stream, Function<? super T, File> fn) {
        return AsGenericMonad.asMonad(stream).liftAndBind(fn).sequence();
    }

    public static final <T> Stream<String> flatMapURL(Stream<T> stream, Function<? super T, URL> fn) {
        return AsGenericMonad.asMonad(stream).liftAndBind(fn).sequence();
    }

    public static final <T> Stream<String> flatMapBufferedReader(Stream<T> stream, Function<? super T, BufferedReader> fn) {
        return AsGenericMonad.asMonad(stream).liftAndBind(fn).sequence();
    }

    public static final <A> Tuple2<Iterator<A>, Iterator<A>> toBufferingDuplicator(Iterator<A> iterator) {
        return StreamUtils.toBufferingDuplicator(iterator, Long.MAX_VALUE);
    }

    public static final <A> Tuple2<Iterator<A>, Iterator<A>> toBufferingDuplicator(Iterator<A> iterator, long pos) {
        LinkedList bufferTo = new LinkedList();
        LinkedList bufferFrom = new LinkedList();
        return new Tuple2(new DuplicatingIterator(bufferTo, bufferFrom, iterator, Long.MAX_VALUE, 0L), new DuplicatingIterator(bufferFrom, bufferTo, iterator, pos, 0L));
    }

    public static final <A> List<Iterator<A>> toBufferingCopier(Iterator<A> iterator, int copies) {
        ArrayList<Iterator<A>> result = new ArrayList<Iterator<A>>();
        LinkedList leaderboard = new LinkedList();
        LinkedList buffer = new LinkedList();
        for (int i = 0; i < copies; ++i) {
            result.add(new CopyingIterator<A>(iterator, leaderboard, buffer, copies));
        }
        return result;
    }

    public static final <A> Collection<A> toLazyCollection(Stream<A> stream) {
        return SeqUtils.toLazyCollection(stream.iterator());
    }

    public static final <A> Collection<A> toLazyCollection(Iterator<A> iterator) {
        return SeqUtils.toLazyCollection(iterator);
    }

    public static final <A> Collection<A> toConcurrentLazyCollection(Stream<A> stream) {
        return SeqUtils.toConcurrentLazyCollection(stream.iterator());
    }

    public static final <A> Collection<A> toConcurrentLazyCollection(Iterator<A> iterator) {
        return SeqUtils.toConcurrentLazyCollection(iterator);
    }

    public static final <T> Stream<Streamable<T>> windowByTime(Stream<T> stream, long time, TimeUnit t) {
        final Iterator it = stream.iterator();
        final long toRun = t.toNanos(time);
        return StreamUtils.stream(new Iterator<Streamable<T>>(){
            long start = System.nanoTime();

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Streamable<T> next() {
                ArrayList list = new ArrayList();
                while (System.nanoTime() - this.start < toRun && it.hasNext()) {
                    list.add(it.next());
                }
                if (list.size() == 0 && it.hasNext()) {
                    list.add(it.next());
                }
                this.start = System.nanoTime();
                return Streamable.fromIterable(list);
            }
        });
    }

    public static final <T> Stream<List<T>> batchByTime(Stream<T> stream, long time, TimeUnit t) {
        return new BatchByTimeOperator(stream).batchByTime(time, t);
    }

    public static final <T, C extends Collection<T>> Stream<C> batchByTime(Stream<T> stream, long time, TimeUnit t, Supplier<C> factory) {
        return new BatchByTimeOperator<T, C>(stream, factory).batchByTime(time, t);
    }

    public static final <T> Stream<Streamable<T>> windowStatefullyWhile(Stream<T> stream, BiPredicate<Streamable<T>, T> predicate) {
        return new WindowStatefullyWhileOperator<T>(stream).windowStatefullyWhile(predicate);
    }

    public static final <T> Stream<Streamable<T>> windowWhile(Stream<T> stream, Predicate<T> predicate) {
        return new WindowWhileOperator<T>(stream).windowWhile(predicate);
    }

    public static final <T> Stream<List<T>> batchWhile(Stream<T> stream, Predicate<T> predicate) {
        return new BatchWhileOperator(stream).batchWhile(predicate);
    }

    public static final <T, C extends Collection<T>> Stream<C> batchWhile(Stream<T> stream, Predicate<T> predicate, Supplier<C> factory) {
        return new BatchWhileOperator<T, C>(stream, factory).batchWhile(predicate);
    }

    public static final <T> Stream<List<T>> batchUntil(Stream<T> stream, Predicate<T> predicate) {
        return StreamUtils.batchWhile(stream, predicate.negate());
    }

    public static final <T> Stream<List<T>> batchBySizeAndTime(Stream<T> stream, int size, long time, TimeUnit t) {
        return new BatchByTimeAndSizeOperator(stream).batchBySizeAndTime(size, time, t);
    }

    public static final <T, C extends Collection<T>> Stream<C> batchBySizeAndTime(Stream<T> stream, int size, long time, TimeUnit t, Supplier<C> factory) {
        return new BatchByTimeAndSizeOperator<T, C>(stream, factory).batchBySizeAndTime(size, time, t);
    }

    public static final <T> Stream<Streamable<T>> windowBySizeAndTime(Stream<T> stream, int size, long time, TimeUnit t) {
        return new WindowByTimeAndSizeOperator<T>(stream).windowBySizeAndTime(size, time, t);
    }

    public static final <T> Stream<T> debounce(Stream<T> stream, long time, TimeUnit t) {
        return new DebounceOperator<T>(stream).debounce(time, t);
    }

    public static final <T> Stream<T> onePer(Stream<T> stream, long time, TimeUnit t) {
        return new OnePerOperator<T>(stream).onePer(time, t);
    }

    public static final <T> Stream<T> jitter(Stream<T> stream, final long jitterInNanos) {
        final Iterator it = stream.iterator();
        final Random r = new Random();
        return StreamUtils.stream(new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                Object nextValue = it.next();
                try {
                    long elapsedNanos = (long)((double)jitterInNanos * r.nextDouble());
                    long millis = elapsedNanos / 1000000L;
                    int nanos = (int)(elapsedNanos - millis * 1000000L);
                    Thread.sleep(Math.max(0L, millis), Math.max(0, nanos));
                }
                catch (InterruptedException e) {
                    ExceptionSoftener.throwSoftenedException((Throwable)e);
                    return null;
                }
                return nextValue;
            }
        });
    }

    public static final <T> Stream<T> fixedDelay(Stream<T> stream, final long time, final TimeUnit unit) {
        final Iterator it = stream.iterator();
        return StreamUtils.stream(new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                Object nextValue = it.next();
                try {
                    long elapsedNanos = unit.toNanos(time);
                    long millis = elapsedNanos / 1000000L;
                    int nanos = (int)(elapsedNanos - millis * 1000000L);
                    Thread.sleep(Math.max(0L, millis), Math.max(0, nanos));
                }
                catch (InterruptedException e) {
                    ExceptionSoftener.throwSoftenedException((Throwable)e);
                    return null;
                }
                return nextValue;
            }
        });
    }

    public static final <T> Stream<T> xPer(Stream<T> stream, final int x, long time, TimeUnit t) {
        final Iterator it = stream.iterator();
        final long next = t.toNanos(time);
        return StreamUtils.stream(new Iterator<T>(){
            volatile long last = -1L;
            volatile int count = 0;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                Object nextValue = it.next();
                if (this.count++ < x) {
                    return nextValue;
                }
                this.count = 0;
                LockSupport.parkNanos(next - System.nanoTime() - this.last);
                this.last = System.nanoTime();
                return nextValue;
            }
        });
    }

    public static final <T> HotStream<T> hotStream(Stream<T> stream, Executor exec) {
        return new HotStreamImpl<T>(stream).init(exec);
    }

    private StreamUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class CopyingIterator<T>
    implements Iterator<T> {
        LinkedList<T> buffer;
        Iterator<T> it;
        List<CopyingIterator<T>> leaderboard = new LinkedList<CopyingIterator<T>>();
        boolean added = false;
        int total = 0;
        int counter = 0;

        @Override
        public boolean hasNext() {
            if (this.isLeader()) {
                return this.it.hasNext();
            }
            if (this.isLast()) {
                return this.buffer.size() > 0 || this.it.hasNext();
            }
            if (this.it.hasNext()) {
                return true;
            }
            return this.counter < this.buffer.size();
        }

        private boolean isLeader() {
            return this.leaderboard.size() == 0 || this == this.leaderboard.get(0);
        }

        private boolean isLast() {
            return this.leaderboard.size() == this.total && this == this.leaderboard.get(this.leaderboard.size() - 1);
        }

        @Override
        public T next() {
            if (!this.added) {
                this.leaderboard.add(this);
                this.added = true;
            }
            if (this.isLeader()) {
                return this.handleLeader();
            }
            if (this.isLast()) {
                if (this.buffer.size() > 0) {
                    return this.buffer.poll();
                }
                return this.it.next();
            }
            if (this.counter < this.buffer.size()) {
                return this.buffer.get(this.counter++);
            }
            return this.handleLeader();
        }

        private T handleLeader() {
            T next = this.it.next();
            this.buffer.offer(next);
            return next;
        }

        public CopyingIterator(Iterator<T> it, List<CopyingIterator<T>> leaderboard, LinkedList<T> buffer, int total) {
            this.it = it;
            this.leaderboard = leaderboard;
            this.buffer = buffer;
            this.total = total;
        }
    }

    static class DuplicatingIterator<T>
    implements Iterator<T> {
        LinkedList<T> bufferTo;
        LinkedList<T> bufferFrom;
        Iterator<T> it;
        long otherLimit = Long.MAX_VALUE;
        long counter = 0L;

        @Override
        public boolean hasNext() {
            return this.bufferFrom.size() > 0 || this.it.hasNext();
        }

        @Override
        public T next() {
            try {
                if (this.bufferFrom.size() > 0) {
                    T t = this.bufferFrom.remove(0);
                    return t;
                }
                T next = this.it.next();
                if (this.counter < this.otherLimit) {
                    this.bufferTo.add(next);
                }
                T t = next;
                return t;
            }
            finally {
                ++this.counter;
            }
        }

        @ConstructorProperties(value={"bufferTo", "bufferFrom", "it", "otherLimit", "counter"})
        public DuplicatingIterator(LinkedList<T> bufferTo, LinkedList<T> bufferFrom, Iterator<T> it, long otherLimit, long counter) {
            this.bufferTo = bufferTo;
            this.bufferFrom = bufferFrom;
            this.it = it;
            this.otherLimit = otherLimit;
            this.counter = counter;
        }
    }
}

