/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.sequence.streamable;

import com.aol.cyclops.invokedynamic.InvokeDynamic;
import com.aol.cyclops.objects.AsDecomposable;
import com.aol.cyclops.sequence.ReversedIterator;
import com.aol.cyclops.sequence.SeqUtils;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.sequence.streamable.AsStreamable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Streamable<T>
extends Iterable<T> {
    @Override
    default public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    default public Object getStreamable() {
        return this;
    }

    default public SequenceM<T> reveresedSequenceM() {
        return SequenceM.fromStream(this.reveresedStream());
    }

    default public SequenceM<T> sequenceM() {
        return SequenceM.fromStream(this.stream());
    }

    default public Stream<T> reveresedStream() {
        Object streamable = this.getStreamable();
        if (streamable instanceof List) {
            return StreamSupport.stream(new ReversedIterator((List)streamable).spliterator(), false);
        }
        if (streamable instanceof Object[]) {
            List<Object> arrayList = Arrays.asList((Object[])streamable);
            return StreamSupport.stream(new ReversedIterator<Object>(arrayList).spliterator(), false);
        }
        return SeqUtils.reverse(this.stream());
    }

    default public Stream<T> stream() {
        Object streamable = this.getStreamable();
        if (streamable instanceof Stream) {
            return (Stream)streamable;
        }
        if (streamable instanceof Iterable) {
            return StreamSupport.stream(((Iterable)streamable).spliterator(), false);
        }
        return new InvokeDynamic().stream(streamable).orElseGet(() -> StreamSupport.stream(AsDecomposable.asDecomposable(streamable).unapply().spliterator(), false));
    }

    public static <T> Streamable<T> fromStream(Stream<T> stream) {
        return AsStreamable.fromStream(stream);
    }

    public static <T> Streamable<T> fromIterable(Iterable<T> iterable) {
        return AsStreamable.fromIterable(iterable);
    }

    public static <T> Streamable<T> of(final T ... values) {
        return new Streamable<T>(){

            @Override
            public Stream<T> stream() {
                return Stream.of(values);
            }

            @Override
            public Object getStreamable() {
                return values;
            }
        };
    }

    public static <T> Streamable<T> empty() {
        return Streamable.of(new Object[0]);
    }
}

