/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.sequence.streamable;

import com.aol.cyclops.sequence.SeqUtils;
import com.aol.cyclops.sequence.streamable.Streamable;
import com.aol.cyclops.sequence.streamable.StreamableImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

public class AsStreamable {
    public static <T> Streamable<T> fromObject(Object toCoerce) {
        return new StreamableImpl<Object>(AsStreamable.collectStream(toCoerce));
    }

    public static <T> Streamable<T> fromStream(Stream<T> toCoerce) {
        return new StreamableImpl<Stream<T>>(AsStreamable.collectStream(toCoerce));
    }

    public static <T> Streamable<T> fromIterable(Iterable<T> toCoerce) {
        return new StreamableImpl<Iterable<T>>(AsStreamable.collectStream(toCoerce));
    }

    public static <T> Streamable<T> synchronizedFromStream(Stream<T> toCoerce) {
        return new StreamableImpl<Stream<T>>(AsStreamable.collectStreamConcurrent(toCoerce));
    }

    public static <T> Streamable<T> synchronizedFromIterable(Iterable<T> toCoerce) {
        return new StreamableImpl<Iterable<T>>(AsStreamable.collectStreamConcurrent(toCoerce));
    }

    private static <T> T collectStreamConcurrent(T object) {
        if (object instanceof Stream) {
            final Collection c = SeqUtils.toConcurrentLazyCollection((Stream)object);
            return (T)new Iterable(){

                public Iterator iterator() {
                    return c.iterator();
                }
            };
        }
        return object;
    }

    private static <T> T collectStream(T object) {
        if (object instanceof Stream) {
            final Collection c = SeqUtils.toLazyCollection((Stream)object);
            return (T)new Iterable(){

                public Iterator iterator() {
                    return c.iterator();
                }
            };
        }
        return object;
    }
}

