/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.sequence;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.monad.AnyM;
import com.aol.cyclops.sequence.HeadAndTail;
import com.aol.cyclops.sequence.HotStream;
import com.aol.cyclops.sequence.Monoid;
import com.aol.cyclops.sequence.SequenceMFactory;
import com.aol.cyclops.sequence.Unwrapable;
import com.aol.cyclops.sequence.future.FutureOperations;
import com.aol.cyclops.sequence.reactivestreams.CyclopsSubscriber;
import com.aol.cyclops.sequence.reactivestreams.ReactiveStreamsLoader;
import com.aol.cyclops.sequence.spliterators.ReversableSpliterator;
import com.aol.cyclops.sequence.spliterators.ReversingArraySpliterator;
import com.aol.cyclops.sequence.spliterators.ReversingListSpliterator;
import com.aol.cyclops.sequence.spliterators.ReversingRangeSpliterator;
import com.aol.cyclops.sequence.streamable.Streamable;
import java.io.BufferedReader;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.reactivestreams.Publisher;

public interface SequenceM<T>
extends Unwrapable,
Stream<T>,
Seq<T>,
Iterable<T>,
Publisher<T> {
    @Override
    public <R> R unwrap();

    public <T1> SequenceM<T1> flatten();

    public Optional<List<T>> toOptional();

    public CompletableFuture<List<T>> toCompletableFuture();

    public SequenceM<T> cycle(int var1);

    public SequenceM<T> cycle();

    public Tuple2<SequenceM<T>, SequenceM<T>> duplicateSequence();

    public Tuple3<SequenceM<T>, SequenceM<T>, SequenceM<T>> triplicate();

    public Tuple4<SequenceM<T>, SequenceM<T>, SequenceM<T>, SequenceM<T>> quadruplicate();

    public Tuple2<Optional<T>, SequenceM<T>> splitSequenceAtHead();

    public Tuple2<SequenceM<T>, SequenceM<T>> splitAt(int var1);

    public Tuple2<SequenceM<T>, SequenceM<T>> splitBy(Predicate<T> var1);

    public Tuple2<SequenceM<T>, SequenceM<T>> partitionSequence(Predicate<T> var1);

    public SequenceM<T> cycle(Monoid<T> var1, int var2);

    public <R> SequenceM<R> cycle(Class<R> var1, int var2);

    public SequenceM<T> cycleWhile(Predicate<? super T> var1);

    public SequenceM<T> cycleUntil(Predicate<? super T> var1);

    public <U> SequenceM<Tuple2<T, U>> zipStream(Stream<U> var1);

    default public <U> SequenceM<Tuple2<T, U>> zip(Seq<U> other) {
        return SequenceM.fromStream(super.zip(other));
    }

    public <S, U> SequenceM<Tuple3<T, S, U>> zip3(Stream<? extends S> var1, Stream<? extends U> var2);

    public <T2, T3, T4> SequenceM<Tuple4<T, T2, T3, T4>> zip4(Stream<T2> var1, Stream<T3> var2, Stream<T4> var3);

    default public SequenceM<Tuple2<T, Long>> zipWithIndex() {
        return SequenceM.fromStream(super.zipWithIndex());
    }

    public <S, R> SequenceM<R> zipSequence(SequenceM<? extends S> var1, BiFunction<? super T, ? super S, ? extends R> var2);

    public <S, R> SequenceM<R> zipAnyM(AnyM<? extends S> var1, BiFunction<? super T, ? super S, ? extends R> var2);

    public <S, R> SequenceM<R> zipStream(BaseStream<? extends S, ? extends BaseStream<? extends S, ?>> var1, BiFunction<? super T, ? super S, ? extends R> var2);

    public SequenceM<List<T>> sliding(int var1);

    public SequenceM<List<T>> sliding(int var1, int var2);

    public SequenceM<List<T>> grouped(int var1);

    default public <K> Map<K, List<T>> groupBy(Function<? super T, ? extends K> classifier) {
        return super.groupBy(classifier);
    }

    @Override
    public SequenceM<T> distinct();

    public SequenceM<T> scanLeft(Monoid<T> var1);

    public <U> SequenceM<U> scanLeft(U var1, BiFunction<U, ? super T, U> var2);

    public SequenceM<T> scanRight(Monoid<T> var1);

    public <U> SequenceM<U> scanRight(U var1, BiFunction<? super T, U, U> var2);

    @Override
    public SequenceM<T> sorted();

    @Override
    public SequenceM<T> sorted(Comparator<? super T> var1);

    @Override
    public SequenceM<T> skip(long var1);

    public SequenceM<T> skipWhile(Predicate<? super T> var1);

    public SequenceM<T> skipUntil(Predicate<? super T> var1);

    @Override
    public SequenceM<T> limit(long var1);

    public SequenceM<T> limitWhile(Predicate<? super T> var1);

    public SequenceM<T> limitUntil(Predicate<? super T> var1);

    @Override
    public SequenceM<T> parallel();

    @Override
    public boolean allMatch(Predicate<? super T> var1);

    @Override
    public boolean anyMatch(Predicate<? super T> var1);

    public boolean xMatch(int var1, Predicate<? super T> var2);

    @Override
    public boolean noneMatch(Predicate<? super T> var1);

    public String join();

    public String join(String var1);

    public String join(String var1, String var2, String var3);

    public <C extends Comparable<C>> Optional<T> minBy(Function<T, C> var1);

    @Override
    public Optional<T> min(Comparator<? super T> var1);

    public <C extends Comparable<C>> Optional<T> maxBy(Function<T, C> var1);

    @Override
    public Optional<T> max(Comparator<? super T> var1);

    public HeadAndTail<T> headAndTail();

    public Optional<HeadAndTail<T>> headAndTailOptional();

    @Override
    public Optional<T> findFirst();

    @Override
    public Optional<T> findAny();

    public <R> R mapReduce(Monoid<R> var1);

    public <R> R mapReduce(Function<? super T, ? extends R> var1, Monoid<R> var2);

    public List collectStream(Stream<Collector> var1);

    public <R> List<R> collectIterable(Iterable<Collector> var1);

    public T reduce(Monoid<T> var1);

    @Override
    public Optional<T> reduce(BinaryOperator<T> var1);

    @Override
    public T reduce(T var1, BinaryOperator<T> var2);

    @Override
    public <U> U reduce(U var1, BiFunction<U, ? super T, U> var2, BinaryOperator<U> var3);

    @Override
    public List<T> reduce(Stream<Monoid<T>> var1);

    @Override
    public List<T> reduce(Iterable<Monoid<T>> var1);

    public T foldLeft(Monoid<T> var1);

    public T foldLeft(T var1, BinaryOperator<T> var2);

    public <T> T foldLeftMapToType(Monoid<T> var1);

    public T foldRight(Monoid<T> var1);

    public T foldRight(T var1, BinaryOperator<T> var2);

    public <T> T foldRightMapToType(Monoid<T> var1);

    public Streamable<T> toStreamable();

    public Set<T> toSet();

    @Override
    public List<T> toList();

    public <C extends Collection<T>> C toCollection(Supplier<C> var1);

    public <T> Stream<T> toStream();

    public Stream<T> stream();

    public boolean startsWith(Iterable<T> var1);

    public boolean startsWith(Iterator<T> var1);

    public AnyM<T> anyM();

    @Override
    public <R> SequenceM<R> map(Function<? super T, ? extends R> var1);

    @Override
    public SequenceM<T> peek(Consumer<? super T> var1);

    @Override
    public <R> SequenceM<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    public <R> SequenceM<R> flatMapAnyM(Function<? super T, AnyM<? extends R>> var1);

    public <R> SequenceM<R> flatMapCollection(Function<? super T, Collection<? extends R>> var1);

    public <R> SequenceM<R> flatMapStream(Function<? super T, BaseStream<? extends R, ?>> var1);

    public <R> SequenceM<R> flatMapOptional(Function<? super T, Optional<? extends R>> var1);

    public <R> SequenceM<R> flatMapCompletableFuture(Function<? super T, CompletableFuture<? extends R>> var1);

    public SequenceM<Character> flatMapCharSequence(Function<? super T, CharSequence> var1);

    public SequenceM<String> flatMapFile(Function<? super T, File> var1);

    public SequenceM<String> flatMapURL(Function<? super T, URL> var1);

    public SequenceM<String> flatMapBufferedReader(Function<? super T, BufferedReader> var1);

    @Override
    public SequenceM<T> filter(Predicate<? super T> var1);

    @Override
    public SequenceM<T> sequential();

    @Override
    public SequenceM<T> unordered();

    public SequenceM<T> intersperse(T var1);

    public <U> SequenceM<U> ofType(Class<U> var1);

    public <U> SequenceM<U> cast(Class<U> var1);

    public Collection<T> toLazyCollection();

    public Collection<T> toConcurrentLazyCollection();

    public Streamable<T> toConcurrentLazyStreamable();

    public SequenceM<T> reverse();

    @Override
    public SequenceM<T> onClose(Runnable var1);

    public SequenceM<T> shuffle();

    public SequenceM<T> appendStream(Stream<T> var1);

    public SequenceM<T> prependStream(Stream<T> var1);

    public SequenceM<T> append(T ... var1);

    public SequenceM<T> prepend(T ... var1);

    public SequenceM<T> insertAt(int var1, T ... var2);

    public SequenceM<T> deleteBetween(int var1, int var2);

    public SequenceM<T> insertStreamAt(int var1, Stream<T> var2);

    public FutureOperations<T> futureOperations(Executor var1);

    public boolean endsWith(Iterable<T> var1);

    public boolean endsWith(Stream<T> var1);

    public SequenceM<T> skip(long var1, TimeUnit var3);

    public SequenceM<T> limit(long var1, TimeUnit var3);

    public SequenceM<T> skipLast(int var1);

    public SequenceM<T> limitLast(int var1);

    public HotStream<T> hotStream(Executor var1);

    public T firstValue();

    default public T single() {
        Iterator it = this.iterator();
        if (it.hasNext()) {
            Object result = it.next();
            if (!it.hasNext()) {
                return result;
            }
        }
        throw new UnsupportedOperationException("single only works for Streams with a single value");
    }

    default public Optional<T> elementAt(long index) {
        return this.zipWithIndex().filter((T t) -> (Long)t.v2 == index).findFirst().map((? super T t) -> t.v1());
    }

    default public Tuple2<T, SequenceM<T>> get(long index) {
        Tuple2<SequenceM<T>, SequenceM<T>> tuple = this.duplicateSequence();
        return tuple.map1(s -> s.zipWithIndex().filter((T t) -> (Long)t.v2 == index).findFirst().map((? super T t) -> t.v1()).get());
    }

    default public SequenceM<Tuple2<T, Long>> elapsed() {
        AtomicLong last = new AtomicLong(System.currentTimeMillis());
        return this.zip(SequenceM.generate(() -> {
            long now = System.currentTimeMillis();
            long result = now - last.get();
            last.set(now);
            return result;
        }));
    }

    default public SequenceM<Tuple2<T, Long>> timestamp() {
        return this.zip(SequenceM.generate(() -> System.currentTimeMillis()));
    }

    public static <T> CyclopsSubscriber<T> subscriber() {
        return ReactiveStreamsLoader.subscriber.get().subscribe();
    }

    public static <T> SequenceM<T> of(T ... elements) {
        ReversingArraySpliterator array = new ReversingArraySpliterator(elements, false, 0);
        return SequenceMFactory.instance.sequenceM(StreamSupport.stream(array, false), array);
    }

    public static <T> SequenceM<T> reversedOf(T ... elements) {
        ReversableSpliterator array = new ReversingArraySpliterator(elements, false, 0).invert();
        return SequenceMFactory.instance.sequenceM(StreamSupport.stream(array, false), array);
    }

    public static <T> SequenceM<T> reversedListOf(List<T> elements) {
        Objects.requireNonNull(elements);
        ReversableSpliterator list = new ReversingListSpliterator<T>(elements, false).invert();
        return SequenceMFactory.instance.sequenceM(StreamSupport.stream(list, false), list);
    }

    public static SequenceM<Integer> range(int start, int end) {
        ReversingRangeSpliterator range = new ReversingRangeSpliterator(start, end, false);
        return SequenceMFactory.instance.sequenceM(StreamSupport.stream(range, false), range);
    }

    public static <T> SequenceM<T> fromStream(Stream<T> stream) {
        Objects.requireNonNull(stream);
        if (stream instanceof SequenceM) {
            return (SequenceM)stream;
        }
        return SequenceMFactory.instance.sequenceM(stream, null);
    }

    public static SequenceM<Integer> fromIntStream(IntStream stream) {
        Objects.requireNonNull(stream);
        return SequenceMFactory.instance.sequenceM(Seq.seq((IntStream)stream), (ReversableSpliterator)null);
    }

    public static SequenceM<Long> fromLongStream(LongStream stream) {
        Objects.requireNonNull(stream);
        return SequenceMFactory.instance.sequenceM(Seq.seq((LongStream)stream), (ReversableSpliterator)null);
    }

    public static SequenceM<Double> fromDoubleStream(DoubleStream stream) {
        Objects.requireNonNull(stream);
        return SequenceMFactory.instance.sequenceM(Seq.seq((DoubleStream)stream), (ReversableSpliterator)null);
    }

    public static <T> SequenceM<T> fromList(List<T> list) {
        Objects.requireNonNull(list);
        ReversingListSpliterator<T> array = new ReversingListSpliterator<T>(list, false);
        return SequenceMFactory.instance.sequenceM(StreamSupport.stream(array, false), array);
    }

    public static <T> SequenceM<T> fromIterable(Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        return SequenceMFactory.instance.sequenceM(StreamSupport.stream(iterable.spliterator(), false), null);
    }

    public static <T> SequenceM<T> iterate(T seed, UnaryOperator<T> f) {
        return SequenceMFactory.instance.sequenceM(Stream.iterate(seed, f), null);
    }

    public static <T> SequenceM<T> generate(Supplier<T> s) {
        return SequenceMFactory.instance.sequenceM(Stream.generate(s), null);
    }

    public static <T, U> Tuple2<SequenceM<T>, SequenceM<U>> unzip(SequenceM<Tuple2<T, U>> sequence) {
        Tuple2<SequenceM<Tuple2<T, U>>, SequenceM<Tuple2<T, U>>> tuple2 = sequence.duplicateSequence();
        return new Tuple2((Object)((SequenceM)tuple2.v1).map(Tuple2::v1), (Object)((SequenceM)tuple2.v2).map(Tuple2::v2));
    }

    public static <T1, T2, T3> Tuple3<SequenceM<T1>, SequenceM<T2>, SequenceM<T3>> unzip3(SequenceM<Tuple3<T1, T2, T3>> sequence) {
        Tuple3<SequenceM<Tuple3<T1, T2, T3>>, SequenceM<Tuple3<T1, T2, T3>>, SequenceM<Tuple3<T1, T2, T3>>> tuple3 = sequence.triplicate();
        return new Tuple3((Object)((SequenceM)tuple3.v1).map(Tuple3::v1), (Object)((SequenceM)tuple3.v2).map(Tuple3::v2), (Object)((SequenceM)tuple3.v3).map(Tuple3::v3));
    }

    public static <T1, T2, T3, T4> Tuple4<SequenceM<T1>, SequenceM<T2>, SequenceM<T3>, SequenceM<T4>> unzip4(SequenceM<Tuple4<T1, T2, T3, T4>> sequence) {
        Tuple4<SequenceM<Tuple4<T1, T2, T3, T4>>, SequenceM<Tuple4<T1, T2, T3, T4>>, SequenceM<Tuple4<T1, T2, T3, T4>>, SequenceM<Tuple4<T1, T2, T3, T4>>> quad = sequence.quadruplicate();
        return new Tuple4((Object)((SequenceM)quad.v1).map(Tuple4::v1), (Object)((SequenceM)quad.v2).map(Tuple4::v2), (Object)((SequenceM)quad.v3).map(Tuple4::v3), (Object)((SequenceM)quad.v4).map(Tuple4::v4));
    }

    public <U> SequenceM<Tuple2<T, U>> crossJoin(Stream<U> var1);

    default public <U> SequenceM<Tuple2<T, U>> innerJoin(Stream<U> other, BiPredicate<T, U> predicate) {
        Streamable s = Streamable.fromIterable(SequenceM.fromStream(other).toLazyCollection());
        return this.flatMap((T t) -> s.stream().filter((? super T u) -> predicate.test(t, u)).map((? super T u) -> Tuple.tuple((Object)t, (Object)u)));
    }

    default public <U> SequenceM<Tuple2<T, U>> leftOuterJoin(Stream<U> other, BiPredicate<T, U> predicate) {
        Streamable s = Streamable.fromIterable(SequenceM.fromStream(other).toLazyCollection());
        return this.flatMap((T t) -> Seq.seq(s.stream()).filter(u -> predicate.test(t, u)).onEmpty(null).map(u -> Tuple.tuple((Object)t, (Object)u)));
    }

    public <U> SequenceM<Tuple2<T, U>> rightOuterJoin(Stream<U> var1, BiPredicate<T, U> var2);

    default public SequenceM<T> onEmptySwitch(Supplier<Stream<T>> switchTo) {
        AtomicBoolean called = new AtomicBoolean(false);
        return SequenceM.fromStream(this.onEmptyGet(() -> {
            called.set(true);
            return switchTo.get();
        }).flatMap((T s) -> {
            if (called.get()) {
                return (Stream)s;
            }
            return Stream.of(s);
        }));
    }

    public SequenceM<T> onEmpty(T var1);

    public SequenceM<T> onEmptyGet(Supplier<T> var1);

    default public <X extends Throwable> SequenceM<T> onEmptyThrow(Supplier<X> supplier) {
        return SequenceM.fromStream(super.onEmptyThrow(supplier));
    }

    public SequenceM<T> concat(Stream<T> var1);

    public SequenceM<T> concat(T var1);

    public SequenceM<T> concat(T ... var1);

    public <U> SequenceM<T> distinct(Function<? super T, ? extends U> var1);

    public <U, R> SequenceM<R> zip(Seq<U> var1, BiFunction<T, U, R> var2);

    public SequenceM<T> shuffle(Random var1);

    public SequenceM<T> slice(long var1, long var3);

    public <U extends Comparable<? super U>> SequenceM<T> sorted(Function<? super T, ? extends U> var1);

    public SequenceM<T> xPer(int var1, long var2, TimeUnit var4);

    public SequenceM<T> onePer(long var1, TimeUnit var3);

    public SequenceM<T> debounce(long var1, TimeUnit var3);

    public SequenceM<List<T>> batchBySizeAndTime(int var1, long var2, TimeUnit var4);

    public <C extends Collection<T>> SequenceM<C> batchBySizeAndTime(int var1, long var2, TimeUnit var4, Supplier<C> var5);

    public SequenceM<List<T>> batchByTime(long var1, TimeUnit var3);

    public <C extends Collection<T>> SequenceM<C> batchByTime(long var1, TimeUnit var3, Supplier<C> var4);

    public SequenceM<List<T>> batchBySize(int var1);

    public <C extends Collection<T>> SequenceM<C> batchBySize(int var1, Supplier<C> var2);

    public SequenceM<T> fixedDelay(long var1, TimeUnit var3);

    public SequenceM<T> jitter(long var1);

    public SequenceM<Streamable<T>> windowBySizeAndTime(int var1, long var2, TimeUnit var4);

    public SequenceM<Streamable<T>> windowWhile(Predicate<T> var1);

    public SequenceM<Streamable<T>> windowUntil(Predicate<T> var1);

    public SequenceM<Streamable<T>> windowStatefullyWhile(BiPredicate<Streamable<T>, T> var1);

    public SequenceM<Streamable<T>> windowByTime(long var1, TimeUnit var3);

    public SequenceM<List<T>> batchUntil(Predicate<T> var1);

    public SequenceM<List<T>> batchWhile(Predicate<T> var1);

    public <C extends Collection<T>> SequenceM<C> batchWhile(Predicate<T> var1, Supplier<C> var2);

    public <C extends Collection<T>> SequenceM<C> batchUntil(Predicate<T> var1, Supplier<C> var2);

    public SequenceM<T> recover(Function<Throwable, T> var1);

    public <EX extends Throwable> SequenceM<T> recover(Class<EX> var1, Function<EX, T> var2);

    default public <R> SequenceM<R> retry(Function<T, R> fn) {
        Function<Object, Object> retry = t -> {
            int count = 7;
            int sleep = 2000;
            Throwable exception = null;
            while (count-- > 0) {
                try {
                    return fn.apply(t);
                }
                catch (Throwable e) {
                    exception = e;
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e2) {
                        ExceptionSoftener.throwSoftenedException((Throwable)e2);
                        return null;
                    }
                    sleep *= 2;
                }
            }
            ExceptionSoftener.throwSoftenedException(exception);
            return null;
        };
        return this.map(retry);
    }
}

