/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.sequence;

import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Stream;

public interface Monoid<T> {
    public T zero();

    public BiFunction<T, T, T> combiner();

    default public BinaryOperator<T> reducer() {
        return (a, b) -> this.combiner().apply(a, b);
    }

    default public Stream<T> mapToType(Stream stream) {
        return stream;
    }

    default public T mapReduce(Stream toReduce) {
        return this.reduce(this.mapToType(toReduce));
    }

    default public T reduce(Stream<T> toReduce) {
        return toReduce.reduce(this.zero(), this.reducer());
    }

    public static <T> Monoid<T> of(final T zero, final Function<T, Function<T, T>> combiner, final Function<?, T> mapToType) {
        return new Monoid<T>(){

            @Override
            public T zero() {
                return zero;
            }

            @Override
            public BiFunction<T, T, T> combiner() {
                return (a, b) -> ((Function)combiner.apply(a)).apply(b);
            }

            @Override
            public Stream<T> mapToType(Stream stream) {
                return stream.map(mapToType);
            }
        };
    }

    public static <T> Monoid<T> of(final T zero, final Function<T, Function<T, T>> combiner) {
        return new Monoid<T>(){

            @Override
            public T zero() {
                return zero;
            }

            @Override
            public BiFunction<T, T, T> combiner() {
                return (a, b) -> ((Function)combiner.apply(a)).apply(b);
            }
        };
    }

    public static <T> Monoid<T> of(final T zero, final BiFunction<T, T, T> combiner) {
        return new Monoid<T>(){

            @Override
            public T zero() {
                return zero;
            }

            @Override
            public BiFunction<T, T, T> combiner() {
                return combiner;
            }
        };
    }
}

