/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.monad;

import com.aol.cyclops.monad.AnyMFactory;
import com.aol.cyclops.sequence.Monoid;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.sequence.Unwrapable;
import com.aol.cyclops.sequence.streamable.Streamable;
import java.io.BufferedReader;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public interface AnyM<T>
extends Unwrapable {
    public static AnyM<Integer> fromRange(int start, int end) {
        return AnyM.fromStream(SequenceM.range(start, end));
    }

    public static <T> AnyM<T> fromStreamable(Streamable<T> streamable) {
        Objects.requireNonNull(streamable);
        return AnyMFactory.instance.monad(streamable);
    }

    public static <T> AnyM<T> fromList(List<T> list) {
        Objects.requireNonNull(list);
        return AnyMFactory.instance.monad(list);
    }

    public static <T> AnyM<T> fromSet(Set<T> set) {
        Objects.requireNonNull(set);
        return AnyMFactory.instance.monad(set);
    }

    public static <T> AnyM<T> fromArray(T ... streamData) {
        return AnyMFactory.instance.monad(Stream.of(streamData));
    }

    public static <T> AnyM<T> fromStream(Stream<T> stream) {
        Objects.requireNonNull(stream);
        return AnyMFactory.instance.monad(stream);
    }

    public static AnyM<Integer> fromIntStream(IntStream stream) {
        Objects.requireNonNull(stream);
        return AnyMFactory.instance.monad(stream);
    }

    public static AnyM<Double> fromDoubleStream(DoubleStream stream) {
        Objects.requireNonNull(stream);
        return AnyMFactory.instance.monad(stream);
    }

    public static AnyM<Long> fromLongStream(LongStream stream) {
        Objects.requireNonNull(stream);
        return AnyMFactory.instance.monad(stream);
    }

    public static <T> AnyM<T> fromOptional(Optional<T> optional) {
        Objects.requireNonNull(optional);
        return AnyMFactory.instance.monad(optional);
    }

    public static AnyM<Double> fromOptional(OptionalDouble optional) {
        Objects.requireNonNull(optional);
        return AnyMFactory.instance.of(optional);
    }

    public static AnyM<Long> fromOptional(OptionalLong optional) {
        Objects.requireNonNull(optional);
        return AnyMFactory.instance.of(optional);
    }

    public static AnyM<Integer> fromOptional(OptionalInt optional) {
        Objects.requireNonNull(optional);
        return AnyMFactory.instance.of(optional);
    }

    public static <T> AnyM<T> fromCompletableFuture(CompletableFuture<T> future) {
        Objects.requireNonNull(future);
        return AnyMFactory.instance.monad(future);
    }

    public static <T> AnyM<T> fromCollection(Collection<T> collection) {
        Objects.requireNonNull(collection);
        return AnyMFactory.instance.of(collection);
    }

    public static <T> AnyM<T> fromIterable(Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        return AnyMFactory.instance.of(iterable);
    }

    public static AnyM<String> fromFile(File file) {
        Objects.requireNonNull(file);
        return AnyMFactory.instance.of(file);
    }

    public static AnyM<String> fromURL(URL url) {
        Objects.requireNonNull(url);
        return AnyMFactory.instance.of(url);
    }

    public static <T> AnyM<T> ofConvertable(Object monad) {
        Objects.requireNonNull(monad);
        return AnyMFactory.instance.of(monad);
    }

    public static <T> AnyM<T> ofMonad(Object monad) {
        Objects.requireNonNull(monad);
        return AnyMFactory.instance.monad(monad);
    }

    public static <T> AnyM<T> ofNullable(Object monad) {
        return AnyMFactory.instance.monad(Optional.ofNullable(monad));
    }

    @Override
    public <R> R unwrap();

    public <X> X monad();

    public AnyM<T> filter(Predicate<? super T> var1);

    public <R> AnyM<R> map(Function<? super T, ? extends R> var1);

    public AnyM<T> peek(Consumer<? super T> var1);

    public <R> AnyM<R> bind(Function<? super T, ?> var1);

    public <R> AnyM<R> liftAndBind(Function<? super T, ?> var1);

    public AnyM<Character> flatMapCharSequence(Function<? super T, CharSequence> var1);

    public AnyM<String> flatMapFile(Function<? super T, File> var1);

    public AnyM<String> flatMapURL(Function<? super T, URL> var1);

    public AnyM<String> flatMapBufferedReader(Function<? super T, BufferedReader> var1);

    public <T1> AnyM<T1> flatten();

    public AnyM<T> aggregate(AnyM<T> var1);

    public <R> AnyM<List<R>> aggregateUntyped(AnyM<?> var1);

    public <R> AnyM<R> flatMap(Function<? super T, AnyM<? extends R>> var1);

    public <R> AnyM<R> flatMapStream(Function<? super T, BaseStream<? extends R, ?>> var1);

    public <R> AnyM<R> flatMapStreamable(Function<? super T, Streamable<R>> var1);

    public <R> AnyM<R> flatMapCollection(Function<? super T, Collection<? extends R>> var1);

    public <R> AnyM<R> flatMapOptional(Function<? super T, Optional<? extends R>> var1);

    public <R> AnyM<R> flatMapCompletableFuture(Function<? super T, CompletableFuture<? extends R>> var1);

    public <R> AnyM<R> flatMapSequenceM(Function<? super T, SequenceM<? extends R>> var1);

    public <NT> SequenceM<NT> toSequence(Function<T, Stream<NT>> var1);

    public <T> SequenceM<T> toSequence();

    public SequenceM<T> asSequence();

    public <R> AnyM<R> applyM(AnyM<Function<? super T, ? extends R>> var1);

    public AnyM<AnyM<T>> simpleFilter(AnyM<Predicate<? super T>> var1);

    public AnyM<Stream<T>> simpleFilter(Stream<Predicate<? super T>> var1);

    public AnyM<Stream<T>> simpleFilter(Streamable<Predicate<? super T>> var1);

    public AnyM<Optional<T>> simpleFilter(Optional<Predicate<? super T>> var1);

    public AnyM<CompletableFuture<T>> simpleFilter(CompletableFuture<Predicate<? super T>> var1);

    public <T> AnyM<T> unit(T var1);

    public <T> AnyM<T> empty();

    public AnyM<List<T>> replicateM(int var1);

    public AnyM<T> reduceMOptional(Monoid<Optional<T>> var1);

    public AnyM<T> reduceMStream(Monoid<Stream<T>> var1);

    public AnyM<T> reduceMStreamable(Monoid<Streamable<T>> var1);

    public AnyM<T> reduceMCompletableFuture(Monoid<CompletableFuture<T>> var1);

    public AnyM<T> reduceM(Monoid<AnyM<T>> var1);

    public String toString();

    default public Optional<List<T>> toOptional() {
        return this.toSequence().toOptional();
    }

    default public CompletableFuture<List<T>> toCompletableFuture() {
        return this.toSequence().toCompletableFuture();
    }

    public List<T> toList();

    public Set<T> toSet();

    public <R, A> R collect(Collector<? super T, A, R> var1);
}

