/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher;

import com.aol.cyclops.matcher.Case;
import com.aol.cyclops.matcher.Two;
import com.aol.cyclops.objects.Decomposable;
import com.aol.cyclops.sequence.SequenceM;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.pcollections.ConsPStack;
import org.pcollections.PStack;

public class Cases<T, R, X extends Function<T, R>>
implements Function<T, Optional<R>> {
    private final PStack<Case<T, R, X>> cases;
    private final boolean sequential;

    Cases() {
        this.cases = ConsPStack.empty();
        this.sequential = true;
    }

    public PStack<Case<T, R, X>> get() {
        return this.cases;
    }

    public static <T, R, X extends Function<T, R>> Cases<T, R, X> ofPStack(PStack<Case<T, R, X>> cases) {
        return new Cases<T, R, X>(cases, true);
    }

    public static <T, R, X extends Function<T, R>> Cases<T, R, X> ofList(List<Case<T, R, X>> cases) {
        return new Cases<T, R, X>((PStack)cases.stream().map(ConsPStack::singleton).reduce(ConsPStack.empty(), (acc, next) -> acc.plus(acc.size(), next.get(0))), true);
    }

    public static <T, R, X extends Function<T, R>> Cases<T, R, X> of(Case<T, R, X> ... cazes) {
        return Cases.ofPStack((PStack)Stream.of(cazes).map(ConsPStack::singleton).reduce(ConsPStack.empty(), (acc, next) -> acc.plus(acc.size(), next.get(0))));
    }

    public static <T, R, X extends Function<T, R>> Cases<T, R, X> zip(Stream<Predicate<T>> predicates, Stream<X> functions) {
        return Cases.ofPStack((PStack)SequenceM.fromIterator(predicates.iterator()).zip((Seq)SequenceM.fromIterator(functions.iterator()), (T a, U b) -> Two.tuple(a, b)).map(Case::of).map(ConsPStack::singleton).reduce((Object)ConsPStack.empty(), (acc, next) -> acc.plus(acc.size(), next.get(0))));
    }

    public Two<Stream<Predicate<T>>, Stream<X>> unzip() {
        return Two.tuple(this.cases.stream().map((? super T c) -> c.getPredicate()), this.cases.stream().map((? super T c) -> c.getAction()));
    }

    public void forEach(Consumer<Case<T, R, X>> consumer) {
        this.cases.stream().forEach(consumer);
    }

    public Cases<T, R, X> sequential() {
        return this.withSequential(true);
    }

    public Cases<T, R, X> parallel() {
        return this.withSequential(false);
    }

    public Cases<T, R, X> merge(Cases<T, R, X> patterns) {
        return this.withCases(this.cases.plusAll(this.size(), patterns.cases));
    }

    public Cases<T, R, X> filter(Predicate<Case<T, R, X>> predicate) {
        return this.withCases((PStack)this.cases.stream().filter((? super T data) -> predicate.test((Case)data)).map(ConsPStack::singleton).reduce(ConsPStack.empty(), (acc, next) -> acc.plus(acc.size(), next.get(0))));
    }

    public Cases<T, R, X> filterPredicate(Predicate<Predicate<T>> predicate) {
        return this.withCases((PStack)this.cases.stream().filter((? super T data) -> predicate.test(data.getPredicate())).map(ConsPStack::singleton).reduce(ConsPStack.empty(), (acc, next) -> acc.plus(acc.size(), next.get(0))));
    }

    public Cases<T, R, X> filterFunction(Predicate<Function<T, R>> predicate) {
        return this.withCases((PStack)this.cases.stream().filter((? super T data) -> predicate.test((Function)data.getAction())).map(ConsPStack::singleton).reduce(ConsPStack.empty(), (acc, next) -> acc.plus(acc.size(), next.get(0))));
    }

    public Cases<T, R, X> mapPredicate(Function<Predicate<T>, Predicate<T>> predicateMapper) {
        return this.map(caseData -> Case.of((Predicate)predicateMapper.apply(caseData.getPredicate()), caseData.getAction()));
    }

    public <R1> Cases<T, R, X> mapFunction(Function<Function<T, R>, Function<T, R1>> actionMapper) {
        return this.map(caseData -> Case.of(caseData.getPredicate(), (Function)actionMapper.apply((Function)caseData.getAction())));
    }

    public <T1, R1, X1 extends Function<T1, R1>> Cases<T, R, X> map(Function<Case<T, R, X>, Case<T1, R1, X1>> mapper) {
        return this.withCases((PStack)this.cases.stream().map(mapper).map(ConsPStack::singleton).reduce(ConsPStack.empty(), (acc, next) -> acc.plus(acc.size(), next.get(0))));
    }

    public <T1, R1, X1 extends Function<T1, R1>> Cases<T, R, X> flatMap(Function<Case<T, R, X>, Cases<T1, R1, X1>> mapper) {
        return this.withCases((PStack)this.cases.stream().map(mapper).flatMap(Cases::sequentialStream).map(ConsPStack::singleton).reduce(ConsPStack.empty(), (acc, next) -> acc.plus(acc.size(), next.get(0))));
    }

    public <T1, R1, X1 extends Function<T1, R1>> Cases<T1, R1, X1> flatMapAll(Function<PStack<Case<T, R, X>>, Cases<T1, R1, X1>> mapper) {
        return mapper.apply(this.cases);
    }

    public Cases<T, R, X> append(int index, Case<T, R, X> pattern) {
        return this.withCases(this.cases.plus(index, pattern));
    }

    public int size() {
        return this.cases.size();
    }

    public <T1, X> Function<T1, X> asUnwrappedFunction() {
        return t -> ((Optional)this.apply(t)).get();
    }

    public <T1, X> Function<T1, Stream<X>> asStreamFunction() {
        return t -> Stream.of(t).flatMap((? super T input) -> this.matchMany(input));
    }

    @Override
    public Optional<R> apply(T t) {
        return this.match(t);
    }

    public <R> Stream<R> matchManyFromStream(Stream<T> s) {
        return s.flatMap(this::matchMany);
    }

    public <R> CompletableFuture<Stream<R>> matchManyFromStreamAsync(Executor executor, Stream s) {
        return CompletableFuture.supplyAsync(() -> this.matchManyFromStream(s), executor);
    }

    public <R> Stream<R> matchMany(T t) {
        return this.stream().map((? super T pattern) -> pattern.match(t)).filter(Optional::isPresent).map(Optional::get);
    }

    public <R> CompletableFuture<Stream<R>> matchManyAsync(Executor executor, T t) {
        return CompletableFuture.supplyAsync(() -> this.matchMany(t), executor);
    }

    public <R> Stream<R> matchFromStream(Stream<T> s) {
        Stream<Optional> results = s.map(this::match);
        return results.filter(Optional::isPresent).map(Optional::get);
    }

    public <R> CompletableFuture<Stream<R>> matchFromStreamAsync(Executor executor, Stream<T> s) {
        return CompletableFuture.supplyAsync(() -> this.matchFromStream(s), executor);
    }

    public <R> Optional<R> match(Object ... t) {
        return this.match((T)Arrays.asList(t));
    }

    public <R> CompletableFuture<Optional<R>> matchAsync(Executor executor, Object ... t) {
        return CompletableFuture.supplyAsync(() -> this.match((T)t), executor);
    }

    public <R> Optional<R> unapply(Decomposable t) {
        return this.match((T)t.unapply());
    }

    public <R> Optional<R> match(T t) {
        return this.stream().map((? super T pattern) -> pattern.match(t)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private Stream<Case<T, R, X>> sequentialStream() {
        return this.cases.stream();
    }

    private Stream<Case<T, R, X>> stream() {
        if (this.sequential) {
            return this.sequentialStream();
        }
        return this.cases.parallelStream();
    }

    @ConstructorProperties(value={"cases", "sequential"})
    public Cases(PStack<Case<T, R, X>> cases, boolean sequential) {
        this.cases = cases;
        this.sequential = sequential;
    }

    public Cases<T, R, X> withCases(PStack<Case<T, R, X>> cases) {
        return this.cases == cases ? this : new Cases<T, R, X>(cases, this.sequential);
    }

    private Cases<T, R, X> withSequential(boolean sequential) {
        return this.sequential == sequential ? this : new Cases<T, R, X>(this.cases, sequential);
    }
}

