/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher;

import com.aol.cyclops.matcher.Case;
import com.aol.cyclops.matcher.EmptyCase;
import com.aol.cyclops.matcher.Predicates;
import com.aol.cyclops.matcher.Two;
import com.aol.cyclops.matcher.TypedFunction;
import com.aol.cyclops.objects.Decomposable;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CaseTest {
    Case<Integer, Integer, Function<Integer, Integer>> case1;
    Case<Integer, Integer, Function<Integer, Integer>> offCase;

    @Before
    public void setup() {
        this.case1 = Case.of(input -> true, input -> input + 10);
        this.offCase = this.case1.mapPredicate(p -> p.negate());
    }

    @Test
    public void testNegate() {
        Assert.assertThat((Object)this.case1.match((Object)100).isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.case1.negate().match((Object)100).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testNegateAction() {
        Assert.assertThat(this.case1.negate().negate(input -> input * 100).match((Object)100).get(), (Matcher)Matchers.is((Object)10000));
    }

    @Test
    public void testChaining() {
        TypedFunction & Serializable act = (TypedFunction & Serializable)hello -> 10;
        Case caze = Case.of(t -> true, (Function)act);
        Assert.assertThat(caze.filter(t -> ((TypedFunction)t.v2).getType() != null).mapFunction(fn -> input -> 20).match((Object)"hello").get(), (Matcher)Matchers.is((Object)20));
    }

    @Test
    public void testChainingFilterFails() {
        TypedFunction & Serializable act = (TypedFunction & Serializable)hello -> 10;
        Case caze = Case.of(t -> true, (Function)act);
        Assert.assertThat((Object)caze.filter(t -> ((TypedFunction)t.v2).getType() == null).mapFunction(fn -> input -> 20).match((Object)"hello").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testfilterReturnsEmpty() {
        Case empty = Case.of(t -> true, input -> 10).filter(p -> false);
        Assert.assertThat((Object)empty, (Matcher)Matchers.instanceOf(EmptyCase.class));
    }

    @Test
    public void testAnd() {
        Assert.assertThat((Object)this.case1.and(p -> false).match((Object)100).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAndOfType() {
        Assert.assertThat((Object)this.case1.andOfType(Integer.class).match((Object)100).isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAndOfTypeNegative() {
        Assert.assertThat((Object)this.case1.andOfType(String.class).match((Object)100).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAndOfValue() {
        Assert.assertThat((Object)this.case1.andOfValue((Object)100).match((Object)100).isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAndOfValueNegative() {
        Assert.assertThat((Object)this.case1.andOfValue((Object)5).match((Object)100).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAndWithValues() {
        System.out.println(Object.class.isAssignableFrom(Person.class));
        Case case2 = Case.of(p -> ((Person)p).age > 18, p -> ((Person)p).name + " can vote");
        Assert.assertThat((Object)case2.andWithValues(new Object[]{Predicates.__, Predicates.__, Predicates.hasValues((Object[])new Object[]{Predicates.__, Predicates.__, "Ireland"})}).match((Object)new Person("bob", 19, new Address(10, "dublin", "Ireland"))).isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAndWithValuesNegative() {
        Case case2 = Case.of(p -> ((Person)p).age > 18, p -> ((Person)p).name + " can vote");
        Assert.assertThat((Object)case2.andWithValues(new Object[]{Predicates.__, Predicates.__, Predicates.hasValues((Object[])new Object[]{Predicates.__, Predicates.__, "Ireland"})}).match((Object)new Person("bob", 17, new Address(10, "dublin", "Ireland"))).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAndTrue() {
        Assert.assertThat((Object)this.case1.and(p -> true).match((Object)100).isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAndComposeFn() {
        Assert.assertThat((Object)this.case1.composeAnd(p -> false, input -> input * 2).match((Object)100).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAndComposeFnTrue() {
        Assert.assertThat(this.case1.composeAnd(p -> true, input -> input * 2).match((Object)100).get(), (Matcher)Matchers.is((Object)210));
    }

    @Test
    public void mapPredicate() {
        Assert.assertThat((Object)this.case1.mapPredicate(p -> t -> false).match((Object)100).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void mapFunction() {
        Assert.assertThat(this.case1.mapFunction(fn -> input -> input + 20).match((Object)100).get(), (Matcher)Matchers.is((Object)120));
    }

    @Test
    public void map() {
        Two tuple = Two.tuple(t -> false, input -> input + 20);
        Assert.assertThat((Object)this.case1.map(tuple2 -> tuple).match((Object)100).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void mapTrue() {
        Two tuple = Two.tuple(t -> true, input -> input + 20);
        Assert.assertThat(this.case1.map(tuple2 -> tuple).match((Object)100).get(), (Matcher)Matchers.is((Object)120));
    }

    @Test
    public void flatMap() {
        Assert.assertThat(this.case1.flatMap(tuple2 -> Case.of((Predicate)((Predicate)tuple2.v1), input -> input + 20)).match((Object)100).get(), (Matcher)Matchers.is((Object)120));
    }

    @Test
    public void andThen() {
        Assert.assertThat(this.case1.andThen(Case.of(input -> true, input -> input * 2)).match((Object)100).get(), (Matcher)Matchers.is((Object)220));
    }

    @Test
    public void compose() {
        Assert.assertThat(this.case1.compose(Case.of(input -> true, input -> input * 2)).match((Object)100).get(), (Matcher)Matchers.is((Object)210));
    }

    @Test
    public void composeOr() {
        Assert.assertThat(this.case1.composeOr(Case.of(input -> false, input -> input * 2)).match((Object)100).get(), (Matcher)Matchers.is((Object)210));
    }

    @Test
    public void orFunction() {
        Assert.assertThat(this.case1.or(input -> false, input -> input * 2).match((Object)100).get(), (Matcher)Matchers.is((Object)210));
    }

    @Test
    public void composeFunction() {
        Assert.assertThat(this.case1.composeFunction(input -> input * 2).match((Object)100).get(), (Matcher)Matchers.is((Object)210));
    }

    @Test
    public void andThenFunction() {
        Assert.assertThat(this.case1.andThenFunction(input -> input * 2).match((Object)100).get(), (Matcher)Matchers.is((Object)220));
    }

    @Test
    public void or() {
        Assert.assertThat(this.offCase.or(t -> true).match((Object)100).get(), (Matcher)Matchers.is((Object)110));
    }

    @Test
    public void matchAsync() {
        Assert.assertThat(((Optional)this.offCase.or(t -> true).matchAsync((Executor)ForkJoinPool.commonPool(), (Object)100).join()).get(), (Matcher)Matchers.is((Object)110));
    }

    static final class Address
    implements Decomposable {
        private final int number;
        private final String city;
        private final String country;

        @ConstructorProperties(value={"number", "city", "country"})
        public Address(int number, String city, String country) {
            this.number = number;
            this.city = city;
            this.country = country;
        }

        public int getNumber() {
            return this.number;
        }

        public String getCity() {
            return this.city;
        }

        public String getCountry() {
            return this.country;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Address)) {
                return false;
            }
            Address other = (Address)o;
            if (this.getNumber() != other.getNumber()) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            return !(this$country == null ? other$country != null : !this$country.equals(other$country));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNumber();
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 0 : $city.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 0 : $country.hashCode());
            return result;
        }

        public String toString() {
            return "CaseTest.Address(number=" + this.getNumber() + ", city=" + this.getCity() + ", country=" + this.getCountry() + ")";
        }
    }

    static final class Person
    implements Decomposable {
        private final String name;
        private final int age;
        private final Address address;

        @ConstructorProperties(value={"name", "age", "address"})
        public Person(String name, int age, Address address) {
            this.name = name;
            this.age = age;
            this.address = address;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }

        public Address getAddress() {
            return this.address;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Person)) {
                return false;
            }
            Person other = (Person)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            if (this.getAge() != other.getAge()) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 0 : $name.hashCode());
            result = result * 59 + this.getAge();
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 0 : ((Object)$address).hashCode());
            return result;
        }

        public String toString() {
            return "CaseTest.Person(name=" + this.getName() + ", age=" + this.getAge() + ", address=" + this.getAddress() + ")";
        }
    }
}

