/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher;

import com.aol.cyclops.lambda.api.Printable;
import com.aol.cyclops.matcher.Action;
import com.aol.cyclops.matcher.Extractors;
import com.aol.cyclops.matcher.Two;
import com.aol.cyclops.matcher.builders.PatternMatcher;
import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ListMatchingTest
implements Printable {
    String language = null;

    @Test
    public void multiMatch() {
        new PatternMatcher().caseOfMany((Action & Serializable)list -> {
            this.language = (String)list.get(1);
        }, new Predicate[]{v -> v.equals("-l") || v.equals("---lang"), v -> true}).match(Arrays.asList("-l", "java"));
        Assert.assertThat((Object)this.language, (Matcher)Matchers.is((Object)"java"));
    }

    @Test
    public void tupleMatch() {
        new PatternMatcher().caseOfPredicates(Two.tuple(v -> v.equals("-l") || v.equals("---lang"), v -> true), (Action & Serializable)lang -> {
            this.language = lang;
        }, Extractors.at((int)1)).match((Object)Two.tuple((Object)"-l", (Object)"java"));
        Assert.assertThat((Object)this.language, (Matcher)Matchers.is((Object)"java"));
    }

    @Test
    public void generalTuple() {
        new PatternMatcher().caseOfTuple((Iterable)Two.tuple((Object)this.p(v -> v.equals("-l") || v.equals("---lang")), (Object)this.p(v -> true)), (Action & Serializable)lang -> {
            this.language = lang;
        }, Extractors.at((int)1)).match((Object)Two.tuple((Object)"-l", (Object)"java"));
        Assert.assertThat((Object)this.language, (Matcher)Matchers.is((Object)"java"));
    }

    @Test
    public void generalTuple2() {
        new PatternMatcher().caseOfTuple((Iterable)Two.tuple((Object)this.p(v -> v.equals("-l") || v.equals("---lang")), (Object)this.p(v -> true)), (Action & Serializable)t -> {
            this.language = (String)t.v2;
        }, Extractors.of((int)0, (int)1)).match((Object)Two.tuple((Object)"-l", (Object)"java"));
        Assert.assertThat((Object)this.language, (Matcher)Matchers.is((Object)"java"));
    }

    private Predicate p(Predicate p) {
        return p;
    }

    @Test
    public void tupleMatchers() {
        new PatternMatcher().matchOfMatchers(Two.tuple((Object)Matchers.equalTo((Object)"-l"), (Object)Matchers.anything()), (Action & Serializable)lang -> {
            this.language = lang;
        }, Extractors.at((int)1)).match((Object)Two.tuple((Object)"-l", (Object)"java"));
        Assert.assertThat((Object)this.language, (Matcher)Matchers.is((Object)"java"));
    }

    @Test
    public void multiMatchOfIterable() {
        new PatternMatcher().matchOfMany((Action & Serializable)list -> {
            this.language = (String)list.get(1);
        }, new Matcher[]{Matchers.equalTo((Object)"-l"), Matchers.any(String.class)}).match(Arrays.asList("-l", "java"));
        Assert.assertThat((Object)this.language, (Matcher)Matchers.is((Object)"java"));
    }

    @Test
    public void generalMatchTuple() {
        new PatternMatcher().matchOfTuple((Iterable)Two.tuple((Object)Matchers.equalTo((Object)"-l"), (Object)Matchers.anything()), (Action & Serializable)lang -> {
            this.language = lang;
        }, Extractors.at((int)1)).match((Object)Two.tuple((Object)"-l", (Object)"java"));
        Assert.assertThat((Object)this.language, (Matcher)Matchers.is((Object)"java"));
    }
}

