/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher;

import com.aol.cyclops.matcher.Action;
import com.aol.cyclops.matcher.Extractors;
import com.aol.cyclops.matcher.TypedFunction;
import com.aol.cyclops.matcher.builders.Matching;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MatchingTest {
    Object value;

    @Before
    public void setup() {
        this.value = null;
    }

    @Test
    public void testCaseOfTypeWithExtractorAndAction() {
        Matching.when().extract(Person::getAge).isType((TypedFunction & Serializable)i -> {
            this.value = i;
            return this.value;
        }).when().extract(Person::getAge).isType((TypedFunction & Serializable)i -> {
            this.value = i;
            return this.value;
        }).match((Object)new Person(100));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)100));
    }

    @Test(expected=Exception.class)
    public void testCaseOfTypeWithExtractorAndActionBadCase() {
        Matching.when().extract(Person::getName).isType((TypedFunction & Serializable)i -> {
            this.value = i;
            return this.value;
        }).when().extract(Person::getName).isType((TypedFunction & Serializable)i -> {
            this.value = i;
            return this.value;
        }).match((Object)new Person(100));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testCaseOfTypeMethodReference() {
        Matching.when().extract(Person::getAge).isType((TypedFunction & Serializable)i -> {
            this.value = i;
            return this.value;
        }).match((Object)"hello");
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testCaseOfTypeWithExtractorAndActionFalse() {
        Matching.when().extract(Person::getAge).isType((TypedFunction & Serializable)i -> {
            this.value = i;
            return this.value;
        }).match((Object)new Person(100));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testCaseOfValueExtractorAction() {
        Matching.when().extract(Person::getAge).isValue((Object)100).thenConsume((Action & Serializable)i -> {
            this.value = i;
        }).match((Object)new Person(100));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testCaseOfValueExtractorActionFalse() {
        Matching.when().extract(Person::getAge).isValue((Object)200).thenConsume((Action & Serializable)i -> {
            this.value = i;
        }).match((Object)new Person(100));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testCaseOfValueVActionOfV() {
        Matching.when().isValue((Object)"hello").thenConsume((Action & Serializable)s -> {
            this.value = s;
        }).match((Object)"hello");
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)"hello"));
    }

    @Test
    public void testCaseOfValueVActionOfVFalse() {
        Matching.when().isValue((Object)"hello").thenConsume((Action & Serializable)s -> {
            this.value = s;
        }).match((Object)"hello1");
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testCaseOfTypeActionOfV() {
        Matching.when().isType((TypedFunction & Serializable)s -> {
            this.value = s;
            return this.value;
        }).match((Object)"hello");
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)"hello"));
    }

    @Test
    public void testCaseOfTypeActionOfVFalse() {
        Matching.when().isType((TypedFunction & Serializable)s -> {
            this.value = s;
            return this.value;
        }).match((Object)new Date());
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testCaseOfMatcherOfVActionOfV() {
        Matching.when().isMatch(Matchers.hasItem((Object)"hello world")).thenConsume((Action & Serializable)l -> {
            this.value = l;
        }).match(Arrays.asList("hello world"));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is(Arrays.asList("hello world")));
    }

    @Test
    public void testCaseOfMatcherOfVActionOfVFalse() {
        Matching.when().isMatch(Matchers.hasItem((Object)"hello world2")).thenConsume((Action & Serializable)l -> {
            this.value = l;
        }).match(Arrays.asList("hello world"));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testCaseOfPredicateOfVActionOfV() {
        Person person = new Person(42);
        Matching.when().isTrue(v -> v == person).thenConsume((Action & Serializable)p -> {
            this.value = p;
        }).match((Object)person);
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)person));
    }

    @Test
    public void testCaseOfPredicateOfVActionOfVFalse() {
        Person person = new Person(42);
        Matching.when().isTrue(v -> v == person).thenConsume((Action & Serializable)p -> {
            this.value = p;
        }).match((Object)new Person(42));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testCaseOfThenExtractPredicateOfVActionOfVExtractorOfTR() {
        Matching.when().isTrue(it -> it instanceof List).thenExtract(Extractors.get((int)0)).thenConsume((Action & Serializable)it -> {
            this.value = it;
        }).match(Arrays.asList(true, false, "hello"));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testCaseOfThenExtractPredicateOfVActionOfVExtractorOfTRFalseSize() {
        Matching.when().isTrue(it -> it.size() > 3).thenExtract(Extractors.at((int)0)).thenConsume((Action & Serializable)it -> {
            this.value = it;
        }).when().isTrue(it -> it.size() > 3).thenExtract(Extractors.at((int)0)).thenConsume((Action & Serializable)it -> {
            this.value = it;
        }).when().isTrue(it -> it instanceof Map).thenExtract(Extractors.at((int)0)).thenConsume((Action & Serializable)it -> {
            this.value = it;
        }).match(Arrays.asList(true, false, "hello"));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testCaseOfThenExtractMatcherOfVActionOfVExtractorOfTR() {
        Matching.when().isMatch(Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty()))).thenExtract(Extractors.get((int)1)).thenConsume((Action & Serializable)it -> {
            this.value = it;
        }).match(Arrays.asList(true, false, "hello"));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testCaseOfThenExtractMatcherOfVActionOfVExtractorOfTRFalse() {
        Matching.when().isMatch(Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty()))).thenExtract(Extractors.get((int)1)).thenConsume((Action & Serializable)it -> {
            this.value = it;
        }).match(Arrays.asList(new Object[0]));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testCaseOfExtractorOfTRPredicateOfVActionOfV() {
        Matching.when().extract(Extractors.at((int)0)).isTrue(name -> "bob".equals(name)).thenConsume((Action & Serializable)it -> {
            this.value = it;
        }).match((Object)new Person("bob", 22));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)"bob"));
    }

    @Test
    public void testCaseOfExtractorOfTRPredicateOfVActionOfVFalse() {
        Matching.when().extract(Extractors.at((int)0)).isTrue(name -> "bob".equals(name)).thenConsume((Action & Serializable)it -> {
            this.value = it;
        }).match((Object)new Person("rosie", 22));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testCaseOfExtractorOfTRMatcherOfVActionOfV() {
        Matching.when().extract(Extractors.at((int)1)).isMatch(Matchers.greaterThan((Comparable)Integer.valueOf(21))).thenConsume((Action & Serializable)it -> {
            this.value = it;
        }).match((Object)new Person("rosie", 22));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)22));
    }

    @Test
    public void testCaseOfExtractorOfTRMatcherOfVActionOfVFalse() {
        Matching.when().extract(Extractors.at((int)1)).isMatch(Matchers.greaterThan((Comparable)Integer.valueOf(21))).thenApply((TypedFunction & Serializable)it -> {
            this.value = it;
            return this.value;
        }).match((Object)new Person("rosie", 20));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testInCaseOfValueVFunctionOfVX() {
        Assert.assertThat((Object)Matching.when().isValue((Object)100).thenApply((TypedFunction & Serializable)v -> v + 100).match((Object)100).orElse(100), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void testInCaseOfValueVFunctionOfVXFalse() {
        Assert.assertThat((Object)Matching.when().isValue((Object)100).thenApply((TypedFunction & Serializable)v -> v + 100).match((Object)500).orElse(100), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void matchMany() {
        Assert.assertThat(Matching.when().isValue((Object)100).thenApply((TypedFunction & Serializable)v -> v + 100).when().isType((TypedFunction & Serializable)i -> i).matchMany((Object)100).collect(Collectors.toList()), (Matcher)Matchers.is(Arrays.asList(200, 100)));
    }

    @Test
    public void testInCaseOfTypeFunctionOfTX() {
        Assert.assertThat(Matching.when().isType((TypedFunction & Serializable)i -> i - 50).match((Object)100).get(), (Matcher)Matchers.is((Object)50));
    }

    @Test
    public void testInCaseOfTypeFunctionOfTXWithMap() {
        Assert.assertThat((Object)Matching.when().isType((TypedFunction & Serializable)i -> i - 50).match((Object)100).map(x -> x * 100).get(), (Matcher)Matchers.is((Object)5000));
    }

    @Test
    public void testInCaseOfTypeFunctionOfTXFalse() {
        Assert.assertThat(Matching.when().isType((TypedFunction & Serializable)i -> i - 50).match((Object)100L).map(x -> x * 100), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void testInCaseOfPredicateOfVFunctionOfVX() {
        Assert.assertThat(Matching.when().isTrue(a -> a > 100).thenApply((TypedFunction & Serializable)x -> x * 10).apply((Object)101).get(), (Matcher)Matchers.is((Object)1010));
    }

    @Test
    public void testInCaseOfPredicateOfVFunctionOfVXFalse() {
        Assert.assertThat((Object)Matching.when().isTrue(a -> a > 100).thenApply((TypedFunction & Serializable)x -> x * 10).match((Object)99), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void testInCaseOfThenExtractPredicateOfTFunctionOfRXExtractorOfTR() {
        Assert.assertThat(Matching.when().isTrue(person -> person.getAge() > 18).thenExtract(Person::getName).thenApply((TypedFunction & Serializable)name -> name + " is an adult").match((Object)new Person("rosie", 39)).get(), (Matcher)Matchers.is((Object)"rosie is an adult"));
    }

    @Test
    public void testInCaseOfThenExtractPredicateOfTFunctionOfRXExtractorOfTRFalse() {
        Assert.assertThat((Object)Matching.when().isTrue(person -> person.getAge() > 18).thenExtract(Person::getName).thenApply((TypedFunction & Serializable)name -> name + " is an adult").match((Object)new Person("rosie", 9)), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void testInCaseOfExtractorOfTRPredicateOfVFunctionOfVX() {
        Assert.assertThat(Matching.when().extract(Person::getName).isTrue(name -> name.length() > 5).thenApply((TypedFunction & Serializable)name -> name + " is too long").match((Object)new Person("long name", 9)).get(), (Matcher)Matchers.is((Object)"long name is too long"));
    }

    @Test
    public void testInCaseOfExtractorOfTRPredicateOfVActionFalse() {
        Assert.assertThat((Object)Matching.when().extract(Person::getName).isTrue(name -> name.length() > 5).thenApply((TypedFunction & Serializable)name -> name + " is too long").match((Object)new Person("short", 9)), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void testInCaseOfMatcherOfVFunctionOfVX() {
        Assert.assertThat(Matching.when().isMatch(Matchers.hasItem((Object)"hello")).thenApply((TypedFunction & Serializable)hello -> "world").apply(Arrays.asList("hello")).get(), (Matcher)Matchers.is((Object)"world"));
    }

    @Test
    public void testInCaseOfMatcherOfVFunctionOfVXFalse() {
        Assert.assertThat((Object)Matching.when().isMatch(Matchers.hasItem((Object)"hello")).thenApply((TypedFunction & Serializable)hello -> "world").match(Arrays.asList("hello2")), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void testInCaseOfThenExtractMatcherOfTFunctionOfRXExtractorOfTR() {
        Assert.assertThat(Matching.when().isMatch(Matchers.hasItem((Object)"hello")).thenExtract(Extractors.at((int)1)).thenApply((TypedFunction & Serializable)value -> "second value is " + value).match(Arrays.asList("hello", "world")).get(), (Matcher)Matchers.is((Object)"second value is world"));
    }

    public void testInCaseOfThenExtractMatcherOfTFunctionOfRXExtractorOfTRFalse() {
        Assert.assertThat((Object)Matching.when().isMatch(Matchers.hasItem((Object)"hello2")).thenExtract(Extractors.at((int)1)).thenApply((TypedFunction & Serializable)value -> "second value is " + value).match(Arrays.asList("hello", "world")), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void testInCaseOfExtractorOfTRMatcherOfVFunctionOfVX() {
        Assert.assertThat(Matching.when().extract(Person::getName).isMatch(Matchers.is((Object)"bob")).thenApply((TypedFunction & Serializable)name -> name + " wins!").apply((Object)new Person("bob", 65)).get(), (Matcher)Matchers.is((Object)"bob wins!"));
    }

    @Test
    public void testInCaseOfExtractorOfTRMatcherOfVFunctionOfVXFalse() {
        Assert.assertThat((Object)Matching.when().extract(Person::getName).isMatch(Matchers.is((Object)"bob2")).thenApply((TypedFunction & Serializable)name -> name + " wins!").match((Object)new Person("bob", 65)), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void testInCaseOfTypeExtractorOfTRFunctionOfVX() {
        Assert.assertThat(Matching.when().extract(Extractors.at((int)0)).isType((TypedFunction & Serializable)person -> "age is " + person.getAge()).match(Arrays.asList(new Person("amy", 22))).get(), (Matcher)Matchers.is((Object)"age is 22"));
    }

    @Test
    public void testInCaseOfTypeExtractorOfTRFunctionOfVXFalse() {
        Assert.assertThat((Object)Matching.when().extract(Extractors.at((int)0)).isType((TypedFunction & Serializable)person -> "age is " + person.getAge()).match(Arrays.asList(new Address(10, "street", "city", "country"), new Person("amy", 22))), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void testInCaseOfValueRExtractorOfTRFunctionOfVX() {
        Assert.assertThat(Matching.when().extract(Person::getName).isValue((Object)"hello").thenApply((TypedFunction & Serializable)name -> name + " world").match((Object)new Person("hello", 40)).get(), (Matcher)Matchers.is((Object)"hello world"));
    }

    @Test
    public void testInCaseOfValueRExtractorOfTRFunctionOfVXFalse() {
        Assert.assertThat((Object)Matching.when().extract(Person::getName).isValue((Object)"hello").thenApply((TypedFunction & Serializable)name -> name + " world").match((Object)new Person("hello2", 40)), (Matcher)Matchers.is(Optional.empty()));
    }

    static class Address
    implements Iterable {
        int number;
        String street;
        String city;
        String country;

        public Iterator iterator() {
            return Arrays.asList(this.number, this.street, this.city, this.country).iterator();
        }

        @ConstructorProperties(value={"number", "street", "city", "country"})
        public Address(int number, String street, String city, String country) {
            this.number = number;
            this.street = street;
            this.city = city;
            this.country = country;
        }

        public int getNumber() {
            return this.number;
        }

        public String getStreet() {
            return this.street;
        }

        public String getCity() {
            return this.city;
        }

        public String getCountry() {
            return this.country;
        }
    }

    static class Person
    implements Iterable {
        String name;
        int age;

        public Person(int age) {
            this.name = null;
            this.age = age;
        }

        public Iterator iterator() {
            return Arrays.asList(this.name, this.age).iterator();
        }

        @ConstructorProperties(value={"name", "age"})
        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }
    }
}

