/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher;

import com.aol.cyclops.matcher.ChainOfResponsibility;
import com.aol.cyclops.matcher.Two;
import com.aol.cyclops.matcher.builders.Matching;
import java.beans.ConstructorProperties;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SelectFromTest {
    @Test
    public void selectFrom() {
        Stream<Two> chain = Stream.of(Two.tuple(it -> it > 10, it -> it * 100), Two.tuple(it -> it < 10, it -> it * 100));
        int result = (Integer)Matching.whenFromStream().streamOfResponsibilityFromTuple(chain).match((Object)5).get();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)500));
    }

    @Test
    public void selectFromChain() {
        Stream<ChainImpl> chain = Stream.of(new ChainImpl(5, 10), new ChainImpl(7, 100));
        int result = (Integer)Matching.whenFromStream().streamOfResponsibility(chain).match((Object)6).get();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)600));
    }

    static class ChainImpl
    implements ChainOfResponsibility<Integer, Integer> {
        int max;
        int mult;

        public boolean test(Integer t) {
            return t < this.max;
        }

        public Integer apply(Integer t) {
            return t * this.mult;
        }

        @ConstructorProperties(value={"max", "mult"})
        public ChainImpl(int max, int mult) {
            this.max = max;
            this.mult = mult;
        }
    }
}

